/*
 * Decompiled with CFR 0.152.
 */
package org.glite.pseudo.ui.client.message;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.security.GeneralSecurityException;
import java.util.Iterator;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.StreamedSource;
import org.apache.http.HttpResponse;
import org.glite.pseudo.common.pki.Certificate;
import org.glite.pseudo.ui.client.PseudoServiceClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertResponse {
    private static final Logger log = LoggerFactory.getLogger(CertResponse.class);
    protected String status;
    protected String certificate;

    protected CertResponse() {
    }

    public CertResponse(HttpResponse httpResponse) throws PseudoServiceClientException {
        log.debug("Initializing CertResponse");
        if (httpResponse == null) {
            throw new PseudoServiceClientException("Error while parsing the response message: the response is empty!");
        }
        try {
            InputStream inputStream = httpResponse.getEntity().getContent();
            this.parseStream(inputStream);
            inputStream.close();
        }
        catch (IOException e) {
            throw new PseudoServiceClientException("Error while parsing the response message!", e);
        }
        log.trace("CertResponse successfully initialized: {}", (Object)this.toString());
    }

    protected void parseStream(InputStream inputStream) throws IOException {
        StreamedSource source = new StreamedSource(inputStream);
        Iterator iterator = source.iterator();
        if (!source.isXML()) {
            throw new IOException("The response is not a valid XML message!");
        }
        while (iterator.hasNext()) {
            Segment segment = (Segment)iterator.next();
            String segmentStr = segment.toString().trim();
            log.debug("Found segment '{}'", (Object)segmentStr);
            if (segmentStr.equals("<Status>")) {
                segment = (Segment)iterator.next();
                log.debug("Setting status={}", (Object)segment.toString().trim());
                this.status = segment.toString().trim();
                continue;
            }
            if (!segmentStr.equals("<Certificate format=\"PEM\">")) continue;
            segment = (Segment)iterator.next();
            log.debug("Setting certificate={}", (Object)segment.toString().trim());
            this.certificate = segment.toString().trim();
        }
    }

    public Certificate getCertificate() throws PseudoServiceClientException {
        if (this.certificate == null || this.certificate.equals("")) {
            throw new PseudoServiceClientException("The certificate is empty!");
        }
        StringReader reader = new StringReader(this.certificate);
        try {
            return Certificate.readPEM((Reader)reader);
        }
        catch (IOException e) {
            throw new PseudoServiceClientException("Could not read the certificate", e);
        }
        catch (GeneralSecurityException e) {
            throw new PseudoServiceClientException("Failed to reconstitute the certificate", e);
        }
    }

    public String getStatus() {
        return this.status;
    }

    public String toString() {
        return "CertResponse: status=" + this.status + ", certificate=" + this.certificate;
    }
}

