/*
 * Decompiled with CFR 0.152.
 */
package org.glite.pseudo.ui.client.message;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.htmlparser.jericho.Attribute;
import net.htmlparser.jericho.Attributes;
import net.htmlparser.jericho.Segment;
import net.htmlparser.jericho.StreamedSource;
import org.apache.http.HttpResponse;
import org.glite.pseudo.common.pki.CertificateExtension;
import org.glite.pseudo.common.pki.CertificateExtensionFactory;
import org.glite.pseudo.common.pki.CertificateKeys;
import org.glite.pseudo.common.pki.CertificateRequest;
import org.glite.pseudo.ui.client.PseudoServiceClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertInfoResponse {
    private static final Logger log = LoggerFactory.getLogger(CertInfoResponse.class);
    protected String status;
    protected String subjectDN;
    protected String authorizationToken;
    protected String serviceEndpoint;
    protected List<CertificateExtension> certificatePolicy;

    protected CertInfoResponse() {
    }

    public CertInfoResponse(HttpResponse httpResponse) throws PseudoServiceClientException {
        if (httpResponse == null) {
            throw new PseudoServiceClientException("Error while parsing the response message: the response is empty!");
        }
        try {
            InputStream inputStream = httpResponse.getEntity().getContent();
            this.parseStream(inputStream);
            inputStream.close();
        }
        catch (IOException e) {
            throw new PseudoServiceClientException("Error while parsing the response message!", e);
        }
        log.debug("Parsed the following information: {}", (Object)this.toString());
    }

    protected void parseStream(InputStream inputStream) throws IOException {
        StreamedSource source = new StreamedSource(inputStream);
        Iterator<Segment> iterator = source.iterator();
        if (!source.isXML()) {
            throw new IOException("The response is not a valid XML message!");
        }
        while (iterator.hasNext()) {
            Segment segment = (Segment)iterator.next();
            String segmentStr = segment.toString().trim();
            log.debug("Found segment '{}'", (Object)segmentStr);
            if (segmentStr.equals("<Status>")) {
                segment = (Segment)iterator.next();
                log.debug("Setting status={}", (Object)segment.toString().trim());
                this.status = segment.toString().trim();
                continue;
            }
            if (segmentStr.equals("<AuthorizationToken>")) {
                segment = (Segment)iterator.next();
                log.debug("Setting authorizationToken={}", (Object)segment.toString().trim());
                this.authorizationToken = segment.toString().trim();
                continue;
            }
            if (segmentStr.equals("<SubjectDN>")) {
                segment = (Segment)iterator.next();
                log.debug("Setting subjectDN={}", (Object)segment.toString().trim());
                this.subjectDN = segment.toString().trim();
                continue;
            }
            if (segmentStr.equals("<ServiceEndpoint>")) {
                segment = (Segment)iterator.next();
                log.debug("Setting serviceEndpoint={}", (Object)segment.toString().trim());
                this.serviceEndpoint = segment.toString().trim();
                continue;
            }
            if (!segmentStr.equals("<CertificatePolicy>")) continue;
            iterator = this.readCertificatePolicy(iterator);
        }
    }

    private Iterator<Segment> readCertificatePolicy(Iterator<Segment> iterator) {
        String segmentStr;
        this.certificatePolicy = new ArrayList<CertificateExtension>();
        do {
            String name = null;
            String oid = null;
            boolean critical = false;
            Segment segment = iterator.next();
            segmentStr = segment.toString().trim();
            if (segmentStr.length() <= 21 || !segmentStr.substring(0, 22).equals("<CertificateExtension ")) continue;
            log.debug("Segment={}", (Object)segment);
            Attributes attrs = segment.parseAttributes();
            for (int i = 0; i < attrs.size(); ++i) {
                Attribute attribute = (Attribute)attrs.get(i);
                String key = attribute.getKey();
                String value = attribute.getValue();
                if (key.equals("name")) {
                    name = value;
                    continue;
                }
                if (key.equals("oid")) {
                    oid = value;
                    continue;
                }
                if (key.equals("critical")) {
                    critical = new Boolean(value);
                    continue;
                }
                log.warn("Unrecognized attribute in the CertificateExtension");
            }
            segment = iterator.next();
            segmentStr = segment.toString().trim();
            CertificateExtension extension = CertificateExtensionFactory.createCertificateExtension(name, (String)segmentStr, (boolean)critical);
            if (extension.getOID().toString().equals(oid)) {
                log.debug("Adding the extension to the policy");
                this.certificatePolicy.add(extension);
                continue;
            }
            log.warn("The OID did not match, the extension has been ignored!");
        } while (!segmentStr.equals("</CertificatePolicy>"));
        return iterator;
    }

    public CertificateRequest generateCSR(CertificateKeys certKeys) throws PseudoServiceClientException {
        log.debug("Generating a CertificateRequest object");
        CertificateRequest csr = null;
        try {
            csr = new CertificateRequest(certKeys, this.subjectDN, this.certificatePolicy);
        }
        catch (GeneralSecurityException e) {
            throw new PseudoServiceClientException("Could not generate CertificateRequest!", e);
        }
        return csr;
    }

    public String getStatus() {
        return this.status;
    }

    public String getAuthorizationToken() {
        return this.authorizationToken;
    }

    public String getServiceEndpoint() {
        return this.serviceEndpoint;
    }

    public List<CertificateExtension> getCertificateExtensions() {
        return this.certificatePolicy;
    }

    public String toString() {
        return "CertInfoResponse: Status=" + this.status + ", SubjectDN=" + this.subjectDN + ", AuthorizationToken=" + this.authorizationToken + ", ServiceEndpoint=" + this.serviceEndpoint + ", CertificatePolicy=" + this.certificatePolicy;
    }
}

