/*
 * Decompiled with CFR 0.152.
 */
package org.glite.pseudo.ui;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.glite.pseudo.common.log.LogbackLoggingService;
import org.glite.pseudo.common.pki.Certificate;
import org.glite.pseudo.common.pki.CertificateKeys;
import org.glite.pseudo.common.util.Util;
import org.glite.pseudo.ui.PseudoClientVersion;
import org.glite.pseudo.ui.client.PseudoServiceClient;
import org.glite.pseudo.ui.client.PseudoServiceClientException;
import org.glite.pseudo.ui.client.message.CertInfoResponse;
import org.glite.pseudo.ui.client.message.CertResponse;
import org.glite.pseudo.ui.util.PasswordReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PseudoInit {
    private static final int DEFAULT_KEYSIZE = 1024;
    private static final int MINIMUM_KEYSIZE = 512;
    private static final String PSEUDO_CERTIFICATE_FILE_POSTFIX = "cert.pem";
    private static final String PSEUDO_PRIVATE_KEY_FILE_POSTFIX = "key.pem";
    private static final String DEFAULT_FILE_PREFIX = "pseudo";
    private static final String DEFAULT_STORE_DIRECTORY = ".globus";
    private static final Logger log = LoggerFactory.getLogger(PseudoInit.class);
    private CertificateKeys m_certificateKeys = null;
    private URL m_serviceUrl = null;
    private int m_keySize = -1;
    private char[] m_keyPassword = null;
    private String m_proxyFile = null;
    private File m_keyfile = null;
    private File m_certfile = null;
    private boolean m_verbose = false;
    private String m_truststore = null;
    private String m_truststorePwd = null;
    private String m_caDirectory = "/etc/grid-security/certificates";
    private boolean m_checkCrl = true;

    protected PseudoInit() {
    }

    public static void main(String[] args) {
        new LogbackLoggingService("/opt/glite/pseudoclient/logging.xml");
        System.out.println("pseudo-cert-request: " + PseudoInit.class.getName() + " - " + "Copyright (c) 2011. Members of the EMI Collaboration");
        System.out.println();
        String cmdLine = "";
        for (int i = 0; i < args.length; ++i) {
            cmdLine = cmdLine + args[i] + " ";
        }
        log.info("Program started with the following arguments: " + cmdLine);
        PseudoInit client = new PseudoInit();
        String userHome = System.getProperty("user.home");
        String separator = System.getProperty("file.separator");
        String userUid = System.getProperty("userid");
        String defaultDir = userHome + separator + DEFAULT_STORE_DIRECTORY;
        client.m_proxyFile = userUid != null ? separator + "tmp" + separator + "x509up_u" + userUid : "x509up_u";
        Options options = PseudoInit.createCommandLineOptions(defaultDir, client.m_proxyFile);
        client.parseCommandLineOptions(options, args, defaultDir);
        if (client.m_verbose) {
            System.out.print("Connecting to the pseudonymity service ...");
        }
        CertInfoResponse certInfo = null;
        PseudoServiceClient serviceClient = null;
        serviceClient = client.m_truststore == null ? new PseudoServiceClient(client.m_proxyFile, client.m_caDirectory, client.m_checkCrl) : new PseudoServiceClient(client.m_proxyFile, client.m_truststore, client.m_truststorePwd, client.m_checkCrl);
        try {
            certInfo = serviceClient.login(client.m_serviceUrl);
        }
        catch (Exception e) {
            PseudoInit.errorExit("Error while connecting pseudonymity service!", e, client.m_verbose);
        }
        if (client.m_verbose) {
            System.out.println(" ok");
            System.out.print("Generating a public/private keypair (" + client.m_keySize + " bit) ...");
        }
        try {
            client.m_certificateKeys = new CertificateKeys(client.m_keySize, client.m_keyPassword);
        }
        catch (GeneralSecurityException e) {
            PseudoInit.errorExit("unable to generate a certificate request!", e, client.m_verbose);
        }
        if (client.m_verbose) {
            System.out.println(" ok");
            System.out.print("Submitting the certificate request ...");
        }
        CertResponse certResponse = null;
        try {
            URL endpoint = new URL(certInfo.getServiceEndpoint());
            certResponse = serviceClient.sendCertRequest(certInfo.generateCSR(client.m_certificateKeys), endpoint, certInfo.getAuthorizationToken());
        }
        catch (Exception e) {
            PseudoInit.errorExit("could not request a certificate from the service!", e, client.m_verbose);
        }
        if (client.m_verbose) {
            System.out.println(" ok");
        }
        Certificate certificate = null;
        try {
            certificate = certResponse.getCertificate();
            certificate.storePEM(client.m_certfile);
        }
        catch (PseudoServiceClientException e) {
            PseudoInit.errorExit("Could not read the certificate from the response!", e, client.m_verbose);
        }
        catch (IOException e) {
            PseudoInit.errorExit("Unable to save the certificate!", e, client.m_verbose);
        }
        try {
            client.m_certificateKeys.storePEMPrivate(client.m_keyfile);
        }
        catch (IOException e) {
            PseudoInit.errorExit("Unable to save the private key!", e, client.m_verbose);
        }
        System.out.println();
        System.out.println("Pseudo certificate (" + client.m_certfile.getAbsolutePath() + ") expires on '" + certificate.getCertificate().getNotAfter() + "'.");
        System.exit(0);
    }

    private void parseCommandLineOptions(Options options, String[] args, String defaultDir) {
        PosixParser parser = new PosixParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            System.err.println("ERROR: " + e.getMessage());
            PseudoInit.printHelp(options);
            System.exit(1);
        }
        if (cmd.hasOption('V')) {
            System.out.println("Version: " + PseudoClientVersion.getVersion());
            System.exit(0);
        }
        if (cmd.hasOption('h')) {
            PseudoInit.printHelp(options);
            System.exit(1);
        }
        if (cmd.hasOption('v')) {
            this.m_verbose = true;
        }
        if (cmd.hasOption('a')) {
            this.m_truststore = cmd.getOptionValue('a');
            if (!cmd.hasOption('b')) {
                System.err.println("ERROR: --truststorepwd must also be defined with --truststore option!");
                PseudoInit.printHelp(options);
                System.exit(1);
            } else {
                this.m_truststorePwd = cmd.getOptionValue('b');
            }
        }
        if (cmd.hasOption('n')) {
            this.m_checkCrl = false;
        }
        if (cmd.hasOption('c')) {
            this.m_caDirectory = cmd.getOptionValue('c');
        }
        String serviceUrlStr = null;
        if (cmd.hasOption('u')) {
            serviceUrlStr = cmd.getOptionValue('u');
            if (serviceUrlStr == null) {
                PseudoInit.errorExit("--url: empty pseudonymity service url");
            } else {
                try {
                    this.m_serviceUrl = new URL(serviceUrlStr);
                }
                catch (MalformedURLException e) {
                    PseudoInit.errorExit("--url: " + e);
                }
                if (!this.m_serviceUrl.getProtocol().equals("https")) {
                    PseudoInit.errorExit("pseudonymity service protocol (" + this.m_serviceUrl.getProtocol() + ") must be https!");
                }
            }
        } else {
            PseudoInit.errorExit(" mandatory option --url <service-url> is missing");
        }
        log.debug("ServiceUrl: " + this.m_serviceUrl);
        if (this.m_verbose) {
            System.out.println("ServiceUrl: " + this.m_serviceUrl);
        }
        String userPrefix = null;
        if (cmd.hasOption('P')) {
            userPrefix = cmd.getOptionValue('P');
            if (userPrefix == null) {
                PseudoInit.errorExit("--prefix: empty prefix");
            }
            if (this.m_verbose) {
                System.out.println("Prefix: " + userPrefix);
            }
        } else {
            userPrefix = DEFAULT_FILE_PREFIX;
        }
        String storeDirectory = null;
        if (cmd.hasOption('D')) {
            storeDirectory = cmd.getOptionValue('D');
            if (storeDirectory == null) {
                PseudoInit.errorExit("--storedir: empty store dirname");
            }
            if (this.m_verbose) {
                System.out.println("Store Directory: " + storeDirectory);
            }
        } else {
            storeDirectory = defaultDir;
        }
        this.checkStoreDirectory(storeDirectory, userPrefix);
        this.m_keySize = cmd.hasOption('s') ? Integer.parseInt(cmd.getOptionValue('s')) : 1024;
        if (this.m_keySize < 512) {
            PseudoInit.errorExit("--keysize <size>, invalid keysize (minimum 512)");
        }
        if (cmd.hasOption('k')) {
            this.m_keyPassword = cmd.getOptionValue('k').toCharArray();
            if (this.m_verbose) {
                System.out.println("Private key password given in the arguments");
            }
        } else {
            boolean match = false;
            while (!match) {
                try {
                    this.m_keyPassword = PasswordReader.getPassword(System.in, "New Key Password: ");
                    char[] retype = PasswordReader.getPassword(System.in, "Retype: ");
                    if (Util.matchCharArrays((char[])this.m_keyPassword, (char[])retype)) {
                        match = true;
                        continue;
                    }
                    System.out.println("Passwords didn't match!");
                }
                catch (IOException e) {
                    log.error("IOException caught!", (Throwable)e);
                }
            }
        }
        if (this.m_keyPassword == null) {
            PseudoInit.printHelp(options);
            System.exit(1);
        }
        if (cmd.hasOption('p')) {
            this.m_proxyFile = cmd.getOptionValue('p');
            if (this.m_proxyFile == null) {
                PseudoInit.errorExit("--proxyfile: empty proxy filename");
            }
        }
        if (this.m_verbose) {
            System.out.println("Proxy Filename: " + this.m_proxyFile);
        }
    }

    private void checkStoreDirectory(String storeDirectory, String prefix) {
        File directory = new File(storeDirectory);
        if (!directory.isDirectory()) {
            PseudoInit.errorExit("directory ( " + storeDirectory + ") does not exist!");
        }
        prefix = storeDirectory + System.getProperty("file.separator") + prefix;
        String certFilename = prefix + PSEUDO_CERTIFICATE_FILE_POSTFIX;
        String keyFilename = prefix + PSEUDO_PRIVATE_KEY_FILE_POSTFIX;
        this.m_certfile = new File(certFilename);
        try {
            if (!this.m_certfile.createNewFile() && this.m_certfile.length() > 0L) {
                PseudoInit.errorExit("certificate file (" + certFilename + ") already exists!");
            }
        }
        catch (IOException e) {
            PseudoInit.errorExit("unable to create certfile (" + certFilename + "), check permissions.", e, false);
        }
        this.m_keyfile = new File(keyFilename);
        try {
            if (!this.m_keyfile.createNewFile() && this.m_keyfile.length() > 0L) {
                PseudoInit.errorExit("private key file (" + keyFilename + ") already exists!");
            }
        }
        catch (IOException e) {
            PseudoInit.errorExit("unable to create keyfile (" + keyFilename + "), check permissions.", e, false);
        }
    }

    private static Options createCommandLineOptions(String defaultDir, String defaultProxy) {
        Option help = new Option("h", "help", false, "this help");
        Option verbose = new Option("v", "verbose", false, "verbose");
        Option version = new Option("V", "version", false, "shows the version");
        Option keysize = new Option("s", "keysize", true, "private key size (default: 1024)");
        keysize.setArgName("size");
        Option keypassword = new Option("k", "keypass", true, "private key password");
        keypassword.setArgName("password");
        Option prefix = new Option("P", "prefix", true, "optional pseudocert.pem and pseudokey.pem filename prefix");
        prefix.setArgName("prefix");
        Option storedir = new Option("D", "storedir", true, "absolute pathname to the store directory (default: " + defaultDir + ")");
        storedir.setArgName("directory");
        Option proxyFile = new Option("p", "proxyfile", true, "absolute pathname to the proxy file (default: " + defaultProxy + ")");
        proxyFile.setArgName("filename");
        Option host = new Option("u", "url", true, "pseudonymity service url");
        host.setArgName("service-url");
        Option truststoreFile = new Option("a", "truststore", true, "absolute pathname to the truststore");
        truststoreFile.setArgName("filename");
        Option truststorePwd = new Option("b", "truststorePwd", true, "truststore password");
        truststorePwd.setArgName("password");
        Option caDirectory = new Option("c", "cadir", true, "directory for the CA files (default: /etc/grid-security/certificates)");
        caDirectory.setArgName("directory");
        Option requireCrl = new Option("n", "nocrl", false, "ignore CRL check of the service certificate");
        Options options = new Options();
        options.addOption(help);
        options.addOption(verbose);
        options.addOption(version);
        options.addOption(keysize);
        options.addOption(keypassword);
        options.addOption(prefix);
        options.addOption(storedir);
        options.addOption(proxyFile);
        options.addOption(host);
        options.addOption(truststoreFile);
        options.addOption(caDirectory);
        options.addOption(requireCrl);
        options.addOption(truststorePwd);
        return options;
    }

    private static void printHelp(Options options) {
        HelpFormatter help = new HelpFormatter();
        help.printHelp("pseudo-cert-request --url <service-url> [options]", options);
    }

    private static void errorExit(String message) {
        PseudoInit.errorExit(message, null, false);
    }

    private static void errorExit(String message, Exception e, boolean verbose) {
        System.err.println("ERROR: " + message);
        if (e == null) {
            log.error(message);
        } else {
            log.error(message, (Throwable)e);
            if (verbose) {
                e.printStackTrace();
            }
        }
        System.exit(1);
    }
}

