/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.config;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.config.BaseConfig;
import org.apache.struts.config.ExceptionConfig;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.util.RequestUtils;

public class ActionConfig
extends BaseConfig {
    private static final Log log = LogFactory.getLog((Class)ActionConfig.class);
    protected HashMap exceptions = new HashMap();
    protected HashMap forwards = new HashMap();
    protected ModuleConfig moduleConfig = null;
    protected String attribute = null;
    protected String inherit = null;
    protected boolean cancellable = false;
    protected boolean extensionProcessed = false;
    protected String forward = null;
    protected String include = null;
    protected String input = null;
    protected String multipartClass = null;
    protected String name = null;
    protected String parameter = null;
    protected String path = null;
    protected String prefix = null;
    protected String roles = null;
    protected String[] roleNames = new String[0];
    protected String scope = "session";
    protected String suffix = null;
    protected String type = null;
    protected boolean unknown = false;
    protected boolean validate = true;
    protected String command = null;
    protected String catalog = null;

    public ModuleConfig getModuleConfig() {
        return this.moduleConfig;
    }

    public void setModuleConfig(ModuleConfig moduleConfig) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.moduleConfig = moduleConfig;
    }

    public String getAttribute() {
        if (this.attribute == null) {
            return this.name;
        }
        return this.attribute;
    }

    public void setAttribute(String attribute) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.attribute = attribute;
    }

    public boolean getCancellable() {
        return this.cancellable;
    }

    public void setCancellable(boolean cancellable) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.cancellable = cancellable;
    }

    public String getExtends() {
        return this.inherit;
    }

    public void setExtends(String inherit) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.inherit = inherit;
    }

    public boolean isExtensionProcessed() {
        return this.extensionProcessed;
    }

    public String getForward() {
        return this.forward;
    }

    public void setForward(String forward) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.forward = forward;
    }

    public String getInclude() {
        return this.include;
    }

    public void setInclude(String include) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.include = include;
    }

    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.input = input;
    }

    public String getMultipartClass() {
        return this.multipartClass;
    }

    public void setMultipartClass(String multipartClass) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.multipartClass = multipartClass;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.name = name;
    }

    public String getParameter() {
        return this.parameter;
    }

    public void setParameter(String parameter) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.parameter = parameter;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.path = path;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.prefix = prefix;
    }

    public String getRoles() {
        return this.roles;
    }

    public void setRoles(String roles) {
        int comma;
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.roles = roles;
        if (roles == null) {
            this.roleNames = new String[0];
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        while ((comma = roles.indexOf(44)) >= 0) {
            list.add(roles.substring(0, comma).trim());
            roles = roles.substring(comma + 1);
        }
        roles = roles.trim();
        if (roles.length() > 0) {
            list.add(roles);
        }
        this.roleNames = list.toArray(new String[list.size()]);
    }

    public String[] getRoleNames() {
        return this.roleNames;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.scope = scope;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.suffix = suffix;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.type = type;
    }

    public boolean getUnknown() {
        return this.unknown;
    }

    public void setUnknown(boolean unknown) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.unknown = unknown;
    }

    public boolean getValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.validate = validate;
    }

    public String getCommand() {
        return this.command;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCommand(String command) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.command = command;
    }

    public void setCatalog(String catalog) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.catalog = catalog;
    }

    protected boolean checkCircularInheritance(ModuleConfig moduleConfig) {
        String ancestorPath = this.getExtends();
        while (ancestorPath != null) {
            if (this.getPath().equals(ancestorPath)) {
                return true;
            }
            ActionConfig ancestor = moduleConfig.findActionConfig(ancestorPath);
            if (ancestor != null) {
                ancestorPath = ancestor.getExtends();
                continue;
            }
            ancestorPath = null;
        }
        return false;
    }

    protected void inheritExceptionHandlers(ActionConfig baseConfig) throws ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        ExceptionConfig[] baseHandlers = baseConfig.findExceptionConfigs();
        for (int i = 0; i < baseHandlers.length; ++i) {
            ExceptionConfig baseHandler = baseHandlers[i];
            ExceptionConfig copy = this.findExceptionConfig(baseHandler.getType());
            if (copy == null) {
                copy = (ExceptionConfig)RequestUtils.applicationInstance(baseHandler.getClass().getName());
                BeanUtils.copyProperties((Object)copy, (Object)baseHandler);
                this.addExceptionConfig(copy);
                copy.setProperties(baseHandler.copyProperties());
                continue;
            }
            copy.processExtends(this.getModuleConfig(), this);
        }
    }

    protected void inheritForwards(ActionConfig baseConfig) throws ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        ForwardConfig[] baseForwards = baseConfig.findForwardConfigs();
        for (int i = 0; i < baseForwards.length; ++i) {
            ForwardConfig baseForward = baseForwards[i];
            ForwardConfig copy = this.findForwardConfig(baseForward.getName());
            if (copy == null) {
                copy = (ForwardConfig)RequestUtils.applicationInstance(baseForward.getClass().getName());
                BeanUtils.copyProperties((Object)copy, (Object)baseForward);
                this.addForwardConfig(copy);
                copy.setProperties(baseForward.copyProperties());
                continue;
            }
            copy.processExtends(this.getModuleConfig(), this);
        }
    }

    public void addExceptionConfig(ExceptionConfig config) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.exceptions.put(config.getType(), config);
    }

    public void addForwardConfig(ForwardConfig config) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.forwards.put(config.getName(), config);
    }

    public ExceptionConfig findExceptionConfig(String type) {
        return (ExceptionConfig)this.exceptions.get(type);
    }

    public ExceptionConfig[] findExceptionConfigs() {
        ExceptionConfig[] results = new ExceptionConfig[this.exceptions.size()];
        return this.exceptions.values().toArray(results);
    }

    public ExceptionConfig findException(Class type) {
        do {
            String name = type.getName();
            log.debug((Object)("findException: look locally for " + name));
            ExceptionConfig config = this.findExceptionConfig(name);
            if (config != null) {
                return config;
            }
            log.debug((Object)("findException: look globally for " + name));
            config = this.getModuleConfig().findExceptionConfig(name);
            if (config == null) continue;
            return config;
        } while ((type = type.getSuperclass()) != null);
        return null;
    }

    public ForwardConfig findForwardConfig(String name) {
        return (ForwardConfig)this.forwards.get(name);
    }

    public ForwardConfig[] findForwardConfigs() {
        ForwardConfig[] results = new ForwardConfig[this.forwards.size()];
        return this.forwards.values().toArray(results);
    }

    public void freeze() {
        super.freeze();
        ExceptionConfig[] econfigs = this.findExceptionConfigs();
        for (int i = 0; i < econfigs.length; ++i) {
            econfigs[i].freeze();
        }
        ForwardConfig[] fconfigs = this.findForwardConfigs();
        for (int i = 0; i < fconfigs.length; ++i) {
            fconfigs[i].freeze();
        }
    }

    public void inheritFrom(ActionConfig config) throws ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        if (this.getAttribute() == null) {
            this.setAttribute(config.getAttribute());
        }
        if (!this.getCancellable()) {
            this.setCancellable(config.getCancellable());
        }
        if (this.getCatalog() == null) {
            this.setCatalog(config.getCatalog());
        }
        if (this.getCommand() == null) {
            this.setCommand(config.getCommand());
        }
        if (this.getForward() == null) {
            this.setForward(config.getForward());
        }
        if (this.getInclude() == null) {
            this.setInclude(config.getInclude());
        }
        if (this.getInput() == null) {
            this.setInput(config.getInput());
        }
        if (this.getMultipartClass() == null) {
            this.setMultipartClass(config.getMultipartClass());
        }
        if (this.getName() == null) {
            this.setName(config.getName());
        }
        if (this.getParameter() == null) {
            this.setParameter(config.getParameter());
        }
        if (this.getPath() == null) {
            this.setPath(config.getPath());
        }
        if (this.getPrefix() == null) {
            this.setPrefix(config.getPrefix());
        }
        if (this.getRoles() == null) {
            this.setRoles(config.getRoles());
        }
        if (this.getScope().equals("session")) {
            this.setScope(config.getScope());
        }
        if (this.getSuffix() == null) {
            this.setSuffix(config.getSuffix());
        }
        if (this.getType() == null) {
            this.setType(config.getType());
        }
        if (!this.getUnknown()) {
            this.setUnknown(config.getUnknown());
        }
        if (this.getValidate()) {
            this.setValidate(config.getValidate());
        }
        this.inheritExceptionHandlers(config);
        this.inheritForwards(config);
        this.inheritProperties(config);
    }

    public void processExtends(ModuleConfig moduleConfig) throws ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        String ancestorPath = this.getExtends();
        if (!this.extensionProcessed && ancestorPath != null) {
            ActionConfig baseConfig = moduleConfig.findActionConfig(ancestorPath);
            if (baseConfig == null) {
                throw new NullPointerException("Unable to find action for '" + ancestorPath + "' to extend.");
            }
            if (this.checkCircularInheritance(moduleConfig)) {
                throw new IllegalArgumentException("Circular inheritance detected for action " + this.getPath());
            }
            if (!baseConfig.isExtensionProcessed()) {
                baseConfig.processExtends(moduleConfig);
            }
            this.inheritFrom(baseConfig);
        }
        this.extensionProcessed = true;
    }

    public void removeExceptionConfig(ExceptionConfig config) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.exceptions.remove(config.getType());
    }

    public void removeForwardConfig(ForwardConfig config) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.forwards.remove(config.getName());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ActionConfig[");
        sb.append("cancellable=");
        sb.append(this.cancellable);
        sb.append("path=");
        sb.append(this.path);
        sb.append("validate=");
        sb.append(this.validate);
        if (this.attribute != null) {
            sb.append(",attribute=");
            sb.append(this.attribute);
        }
        if (this.catalog != null) {
            sb.append(",catalog=");
            sb.append(this.catalog);
        }
        if (this.command != null) {
            sb.append(",command=");
            sb.append(this.command);
        }
        if (this.inherit != null) {
            sb.append(",extends=");
            sb.append(this.inherit);
        }
        if (this.forward != null) {
            sb.append(",forward=");
            sb.append(this.forward);
        }
        if (this.include != null) {
            sb.append(",include=");
            sb.append(this.include);
        }
        if (this.input != null) {
            sb.append(",input=");
            sb.append(this.input);
        }
        if (this.multipartClass != null) {
            sb.append(",multipartClass=");
            sb.append(this.multipartClass);
        }
        if (this.name != null) {
            sb.append(",name=");
            sb.append(this.name);
        }
        if (this.parameter != null) {
            sb.append(",parameter=");
            sb.append(this.parameter);
        }
        if (this.prefix != null) {
            sb.append(",prefix=");
            sb.append(this.prefix);
        }
        if (this.roles != null) {
            sb.append(",roles=");
            sb.append(this.roles);
        }
        if (this.scope != null) {
            sb.append(",scope=");
            sb.append(this.scope);
        }
        if (this.suffix != null) {
            sb.append(",suffix=");
            sb.append(this.suffix);
        }
        if (this.type != null) {
            sb.append(",type=");
            sb.append(this.type);
        }
        return sb.toString();
    }
}

