/*
 * Decompiled with CFR 0.152.
 */
package org.glite.pseudo.server.struts;

import eu.emi.security.authn.x509.impl.X500NameUtils;
import java.io.IOException;
import java.io.Serializable;
import javax.security.auth.x500.X500Principal;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PseudoActionForm
extends ActionForm
implements Serializable {
    private static final long serialVersionUID = -8113578796120462301L;
    private static final Logger log = LoggerFactory.getLogger(PseudoActionForm.class);
    private String dnQuery = "";

    public String getDnQuery() {
        return this.dnQuery;
    }

    public void setDnQuery(String dn) {
        this.dnQuery = dn;
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        super.validate(mapping, request);
        if (!this.dnQuery.equals("")) {
            X500Principal dn;
            log.debug("Validating dnQuery={}", (Object)this.dnQuery);
            try {
                dn = X500NameUtils.getX500Principal((String)this.dnQuery);
            }
            catch (IOException e) {
                log.debug("Could not convert DN into an X500Principal", (Throwable)e);
                dn = null;
            }
            if (dn == null) {
                ActionMessage message = new ActionMessage("invalid.dn");
                ActionErrors messages = new ActionErrors();
                messages.add("org.apache.struts.action.GLOBAL_MESSAGE", message);
                log.debug("Returning error messages.");
                return messages;
            }
        }
        return null;
    }
}

