/*
 * Decompiled with CFR 0.152.
 */
package org.glite.pseudo.server.standalone;

import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.emi.security.authn.x509.X509Credential;
import eu.emi.security.authn.x509.helpers.ssl.CredentialX509KeyManager;
import eu.emi.security.authn.x509.helpers.ssl.SSLTrustManager;
import eu.emi.security.authn.x509.impl.OpensslCertChainValidator;
import eu.emi.security.authn.x509.impl.PEMCredential;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.util.AbstractQueue;
import java.util.Collections;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.glite.pseudo.server.PseudoServerException;
import org.glite.pseudo.server.standalone.JettyShutdownCommand;
import org.glite.pseudo.server.standalone.JettySslSelectChannelConnector;
import org.glite.pseudo.server.standalone.PseudonymityShutdownAndStatusService;
import org.glite.pseudo.server.standalone.StandaloneConfiguration;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.DefaultHandler;
import org.mortbay.jetty.handler.HandlerCollection;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PseudonymityService {
    private static final Logger log = LoggerFactory.getLogger(PseudonymityService.class);
    private static final String CONF_DIR_OPTION_NAME = "conf-dir";
    protected String configurationDir;
    protected Server jettyServer;
    private WebAppContext webappContext;

    public PseudonymityService(String[] args) {
        try {
            this.parseOptions(args);
            Security.addProvider((Provider)new BouncyCastleProvider());
            StandaloneConfiguration.initialize(this.configurationDir);
            this.configureServer();
            this.jettyServer.start();
            if (this.webappContext.getUnavailableException() != null) {
                throw this.webappContext.getUnavailableException();
            }
            System.out.println("The pseudonymity service has been successfully started.");
            this.jettyServer.join();
        }
        catch (Throwable e) {
            log.error("The service encountered an error that could not be dealt with, shutting down!");
            log.error(e.getMessage());
            System.err.println("The service encountered an error that could not be dealt with, shutting down!");
            System.err.println("Error: " + e.getMessage());
            e.printStackTrace(System.err);
            if (log.isDebugEnabled()) {
                log.error(e.getMessage(), e);
            }
            try {
                this.jettyServer.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.exit(1);
        }
    }

    private Connector configureConnector(String host, int port) throws PseudoServerException {
        PEMCredential credential;
        String privateKey = this.getStringFromStandaloneConfiguration("private_key", "/etc/grid-security/hostkey.pem");
        String privateKeyPwd = this.getStringFromStandaloneConfiguration("private_key_password", null);
        String certificate = this.getStringFromStandaloneConfiguration("certificate", "/etc/grid-security/hostcert.pem");
        try {
            if (privateKeyPwd == null) {
                log.debug("Initializing the PEM credential without a password");
                credential = new PEMCredential(privateKey, certificate, (char[])null);
            } else {
                log.debug("Initializing the PEM credential with a password");
                credential = new PEMCredential(privateKey, certificate, privateKeyPwd.toCharArray());
            }
        }
        catch (KeyStoreException e) {
            throw new PseudoServerException("Could not initialize the private key!", e);
        }
        catch (CertificateException e) {
            throw new PseudoServerException("Could not initialize the certificate!", e);
        }
        catch (IOException e) {
            throw new PseudoServerException("Could not read the private key and/or certificate from the file", e);
        }
        String trustStoreDir = this.getStringFromStandaloneConfiguration("trust_store_dir", String.valueOf("/etc/grid-security/certificates"));
        try {
            OpensslCertChainValidator validator = new OpensslCertChainValidator(trustStoreDir);
            validator.setUpdateInterval(this.getLongFromStandaloneConfiguration("crl_update_interval", 1800000L));
            JettySslSelectChannelConnector connector = new JettySslSelectChannelConnector((X509KeyManager)new CredentialX509KeyManager((X509Credential)credential), (X509TrustManager)new SSLTrustManager((X509CertChainValidator)validator));
            connector.setWantClientAuth(true);
            connector.setNeedClientAuth(true);
            connector.setHost(host);
            connector.setPort(port);
            log.info("Pseudonymity service will listen on https://{}:{}", (Object)host, (Object)port);
            return connector;
        }
        catch (Exception e) {
            log.error("Error initializing connector: " + e.getMessage());
            if (log.isDebugEnabled()) {
                log.error("Error initializing connector: " + e.getMessage(), (Throwable)e);
            }
            throw new PseudoServerException(e);
        }
    }

    private void configureServer() throws PseudoServerException {
        log.info("Configuring jetty server...");
        this.jettyServer = new Server();
        int maxRequestQueueSize = this.getIntFromStandaloneConfiguration("max_request_queue_size", -1);
        log.debug("maxRequestQueueSize = {}", (Object)maxRequestQueueSize);
        int maxConnections = this.getIntFromStandaloneConfiguration("max_connections", 64);
        if (maxConnections <= 0) {
            log.error("Please specify a positive value for the 'maxConnections' configuration parameter!");
            log.error("Will use the hardcoded default '{}' instead...", (Object)64);
            maxConnections = 64;
        }
        log.info("maxConnections = {}", (Object)maxConnections);
        this.jettyServer.setSendServerVersion(false);
        this.jettyServer.setSendDateHeader(false);
        AbstractQueue requestQueue = maxRequestQueueSize < 1 ? new LinkedBlockingQueue() : new ArrayBlockingQueue(maxRequestQueueSize);
        org.mortbay.thread.concurrent.ThreadPool threadPool = new org.mortbay.thread.concurrent.ThreadPool(5, maxConnections, 60L, TimeUnit.SECONDS, requestQueue);
        this.jettyServer.setThreadPool((ThreadPool)threadPool);
        int port = this.getIntFromStandaloneConfiguration("port", 443);
        String host = this.getStringFromStandaloneConfiguration("hostname", "localhost");
        this.jettyServer.setConnectors(new Connector[]{this.configureConnector(host, port)});
        JettyShutdownCommand shutdownCommand = new JettyShutdownCommand(this.jettyServer);
        PseudonymityShutdownAndStatusService.startShutdownAndStatusService(this.getIntFromStandaloneConfiguration("shutdown_port", 8151), Collections.singletonList(shutdownCommand));
        this.webappContext = new WebAppContext();
        this.webappContext.setContextPath("/" + this.getStringFromStandaloneConfiguration("webapp_context", "pseudo"));
        this.webappContext.setWar(this.getStringFromStandaloneConfiguration("warfile", "pseudo.war"));
        this.webappContext.setParentLoaderPriority(true);
        HandlerCollection handlers = new HandlerCollection();
        handlers.setHandlers(new Handler[]{this.webappContext, new DefaultHandler()});
        this.jettyServer.setHandler((Handler)handlers);
    }

    private int getIntFromStandaloneConfiguration(String key, int defaultValue) {
        StandaloneConfiguration conf = null;
        try {
            conf = StandaloneConfiguration.instance();
        }
        catch (PseudoServerException e) {
            log.error("Configuration is not initialized!", (Throwable)e);
        }
        log.debug("Returning {}", (Object)conf.getInt(key, defaultValue));
        return conf.getInt(key, defaultValue);
    }

    private long getLongFromStandaloneConfiguration(String key, long defaultValue) {
        StandaloneConfiguration conf = null;
        try {
            conf = StandaloneConfiguration.instance();
        }
        catch (PseudoServerException e) {
            log.error("Configuration is not initialized!", (Throwable)e);
        }
        log.debug("Returning {}", (Object)conf.getLong(key, defaultValue));
        return conf.getLong(key, defaultValue);
    }

    private String getStringFromStandaloneConfiguration(String key, String defaultValue) {
        StandaloneConfiguration conf = null;
        try {
            conf = StandaloneConfiguration.instance();
        }
        catch (PseudoServerException e) {
            log.error("Configuration is not initialized!", (Throwable)e);
        }
        log.debug("Returning {}", (Object)conf.getString(key, defaultValue));
        return conf.getString(key, defaultValue);
    }

    protected void parseOptions(String[] args) {
        if (args.length > 0) {
            int currentArg = 0;
            while (currentArg < args.length) {
                if (!args[currentArg].startsWith("--")) {
                    this.usage();
                    continue;
                }
                if (args[currentArg].equalsIgnoreCase("--conf-dir")) {
                    this.configurationDir = args[currentArg + 1];
                    log.info("Starting Pseudonymity Service with configuration dir: {}", (Object)this.configurationDir);
                    currentArg += 2;
                    continue;
                }
                this.usage();
            }
        }
    }

    private void usage() {
        String usage = "PseudonymityService [--conf-dir <confDir>]";
        System.out.println(usage);
        System.exit(1);
    }

    public static void main(String[] args) {
        new PseudonymityService(args);
    }

    final class PseudoStandaloneServiceDefaults {
        static final String HOSTNAME = "localhost";
        static final int PORT = 443;
        static final int SHUTDOWN_PORT = 8005;
        static final int MAX_REQUEST_QUEUE_SIZE = -1;
        static final int MAX_CONNECTIONS = 64;
        static final String CERTIFICATE_PATH = "/etc/grid-security/hostcert.pem";
        static final String PRIVATE_KEY_PATH = "/etc/grid-security/hostkey.pem";
        static final String CA_PATH = "/etc/grid-security/certificates";
        static final boolean CRL_ENABLED = true;
        static final long CRL_UPDATE_INTERVAL = 1800000L;
        static final String TRUST_STORE_DIR = "/etc/grid-security/certificates";
        static final String LOG4J_CONFIGURATION_FILE = "/var/lib/trustmanager-tomcat/log4j-trustmanager.properties";

        PseudoStandaloneServiceDefaults() {
        }
    }
}

