/*
 * Decompiled with CFR 0.152.
 */
package org.glite.pseudo.server.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.Provider;
import java.security.Security;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.glite.pseudo.server.auditor.Auditor;
import org.glite.pseudo.server.policy.CertificatePolicy;
import org.glite.pseudo.server.servlet.HttpServletHelper;
import org.glite.pseudo.server.session.SessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServlet
extends HttpServlet {
    private static final long serialVersionUID = 2767774490991442316L;
    private static final Logger log = LoggerFactory.getLogger(AbstractServlet.class);
    protected Auditor auditor;
    protected SessionManager sessionManager;
    protected CertificatePolicy certificatePolicy;

    public void init(ServletConfig config) throws ServletException {
        if (Security.getProvider(BouncyCastleProvider.PROVIDER_NAME) == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        ServletContext context = config.getServletContext();
        this.sessionManager = HttpServletHelper.getSessionManager(context);
        this.auditor = HttpServletHelper.getAuditor(context);
        this.certificatePolicy = HttpServletHelper.getCertificatePolicy(context);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doProcess(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doProcess(request, response);
    }

    protected abstract void doProcess(HttpServletRequest var1, HttpServletResponse var2) throws ServletException, IOException;

    protected String getContextUrl(HttpServletRequest req, String servletPath) {
        StringBuffer sb = new StringBuffer();
        sb.append(req.getScheme()).append("://");
        sb.append(req.getServerName()).append(':').append(req.getServerPort());
        sb.append(req.getContextPath());
        sb.append(servletPath);
        return sb.toString();
    }

    protected void sendXMLErrorResponse(HttpServletRequest req, HttpServletResponse res, String type, String message, Throwable cause) throws IOException {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println(this.getXMLDeclaration());
        pw.print("<");
        pw.print(type);
        pw.println(">");
        pw.println("<Status>Error</Status>");
        pw.print("<Error>");
        pw.print(message);
        pw.println("</Error>");
        if (cause != null) {
            pw.print("<StackTrace>");
            cause.printStackTrace(pw);
            pw.print("</StackTrace>");
        }
        pw.print("</");
        pw.print(type);
        pw.println(">");
        log.info("sending " + type + ":\n" + sw.getBuffer().toString());
        res.setContentType("text/xml");
        PrintWriter out = res.getWriter();
        out.println(sw.getBuffer().toString());
        out.close();
    }

    protected String getXMLDeclaration() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>";
    }
}

