/*
 * Decompiled with CFR 0.152.
 */
package org.glite.pseudo.server.dn.impl;

import java.security.SecureRandom;
import java.util.List;
import org.apache.commons.ssl.util.Hex;
import org.glite.pseudo.common.util.Util;
import org.glite.pseudo.server.PseudoServerException;
import org.glite.pseudo.server.attribute.Attribute;
import org.glite.pseudo.server.config.PseudoServerConfiguration;
import org.glite.pseudo.server.dn.DNBuilder;
import org.ini4j.Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PseudoDNBuilder
implements DNBuilder {
    public static final String PSEUDO_IDENTIFIER_REGEX = "\\$\\{pseudoIdentifier\\}";
    public static final String DN_TEMPLATE_IDENTIFIER = "DNTemplate";
    public static final String ID_LENGTH_IDENTIFIER = "IDLength";
    private final Logger log = LoggerFactory.getLogger(PseudoDNBuilder.class);
    private String m_pattern;
    private int m_idLength;
    private SecureRandom m_random = new SecureRandom();

    @Override
    public String createDN(List<Attribute> attributes) {
        this.log.debug("Generating pseudo DN, idLength={}", (Object)this.getIdLength());
        String pseudoId = this.createRandomString(this.getIdLength());
        this.log.debug("Generated identifier: {}", (Object)pseudoId);
        String dnStr = this.getPattern();
        dnStr = dnStr.replaceAll(PSEUDO_IDENTIFIER_REGEX, pseudoId);
        this.log.debug("Generated DN: {}", (Object)dnStr);
        return dnStr;
    }

    private String getPattern() {
        return this.m_pattern;
    }

    private int getIdLength() {
        return this.m_idLength;
    }

    private String createRandomString(int length) {
        byte[] randomBytes = null;
        randomBytes = new byte[length];
        this.m_random.nextBytes(randomBytes);
        return Hex.encode((byte[])randomBytes);
    }

    @Override
    public void init(PseudoServerConfiguration configuration) throws PseudoServerException {
        Profile.Section cfgSection = configuration.getDNBuilderConfiguration();
        String dnPattern = Util.safeTrimOrNullString((String)((String)cfgSection.get((Object)DN_TEMPLATE_IDENTIFIER)));
        if (dnPattern == null) {
            throw new PseudoServerException("DN Pattern cannot be empty!");
        }
        String pseudoIdLength = Util.safeTrimOrNullString((String)((String)cfgSection.get((Object)ID_LENGTH_IDENTIFIER)));
        if (pseudoIdLength == null) {
            throw new PseudoServerException("Pseudonymous identifier length cannot be null!");
        }
        int length = Integer.valueOf(pseudoIdLength);
        this.log.debug("Initializing a pseudonymous DN builder with pattern={} and idLength={}", (Object)dnPattern, (Object)length);
        this.m_idLength = length;
        this.m_pattern = dnPattern;
    }

    @Override
    public void shutdown() {
    }
}

