/*
 * Decompiled with CFR 0.152.
 */
package org.glite.pseudo.server.config;

import org.glite.pseudo.server.PseudoServerComponent;
import org.glite.pseudo.server.PseudoServerException;
import org.glite.pseudo.server.aaclient.AAClient;
import org.glite.pseudo.server.acl.AccessControlList;
import org.glite.pseudo.server.attribute.AttributeDefinitions;
import org.glite.pseudo.server.auditor.AuditAdmin;
import org.glite.pseudo.server.auditor.Auditor;
import org.glite.pseudo.server.caclient.CAClient;
import org.glite.pseudo.server.config.PseudoServerConfiguration;
import org.glite.pseudo.server.dn.DNBuilder;
import org.glite.pseudo.server.policy.CertificatePolicy;
import org.ini4j.Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentFactory {
    private static final Logger log = LoggerFactory.getLogger(ComponentFactory.class);
    private PseudoServerConfiguration configuration;

    public ComponentFactory(PseudoServerConfiguration configuration) {
        log.debug("Initializing a ComponentFactory");
        this.configuration = configuration;
    }

    public AttributeDefinitions createAttributeDefinitionsInstance() {
        log.debug("Creating a new AttributeDefinitions instance");
        String className = ComponentFactory.getImplementationClassName(this.configuration.getAttributeDefinitionsConfiguration());
        return (AttributeDefinitions)this.createComponentInstance(className);
    }

    public CertificatePolicy createCertificatePolicyInstance() {
        log.debug("Creating a new CertificatePolicy instance");
        String className = ComponentFactory.getImplementationClassName(this.configuration.getCertificatePolicyConfiguration());
        return (CertificatePolicy)this.createComponentInstance(className);
    }

    public DNBuilder createDNBuilderInstance() {
        log.debug("Creating a new DNBuilder instance");
        String className = ComponentFactory.getImplementationClassName(this.configuration.getDNBuilderConfiguration());
        return (DNBuilder)this.createComponentInstance(className);
    }

    public AAClient createAAClientInstance() {
        log.debug("Creating a new AAClient instance");
        String className = ComponentFactory.getImplementationClassName(this.configuration.getAAClientConfiguration());
        return (AAClient)this.createComponentInstance(className);
    }

    public CAClient createCAClientInstance() {
        log.debug("Creating a new CAClient instance");
        String className = ComponentFactory.getImplementationClassName(this.configuration.getCAClientConfiguration());
        return (CAClient)this.createComponentInstance(className);
    }

    public Auditor createAuditorInstance() {
        log.debug("Creating a new Auditor instance");
        String className = ComponentFactory.getImplementationClassName(this.configuration.getAuditorConfiguration());
        return (Auditor)this.createComponentInstance(className);
    }

    public AuditAdmin createAuditAdminInstance() {
        log.debug("Creating a new AuditAdmin instance");
        String className = ComponentFactory.getImplementationClassName(this.configuration.getAuditAdminConfiguration());
        return (AuditAdmin)this.createComponentInstance(className);
    }

    public AccessControlList createAccessControlListInstance() {
        log.debug("Creating a new AccessControl instance");
        String className = ComponentFactory.getImplementationClassName(this.configuration.getAccessControlListConfiguration());
        return (AccessControlList)this.createComponentInstance(className);
    }

    public AccessControlList createAdministratorAccessControlListInstance() {
        log.debug("Creating a new AdminAccessControl instance");
        String className = ComponentFactory.getImplementationClassName(this.configuration.getAdminAccessControlListConfiguration());
        return (AccessControlList)this.createComponentInstance(className);
    }

    protected PseudoServerComponent createComponentInstance(String className) {
        log.debug("Creating a new instance of the class {}", (Object)className);
        if (className.toLowerCase().trim().equals("none")) {
            return null;
        }
        PseudoServerComponent builder = null;
        try {
            builder = (PseudoServerComponent)Class.forName(className).newInstance();
            builder.init(this.configuration);
        }
        catch (InstantiationException e) {
            log.error("Could not build a new instance of " + className, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error("Illegal access error for the class " + className, (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            log.error("Could not find the implementation class " + className, (Throwable)e);
        }
        catch (PseudoServerException e) {
            log.error("Could not initialize the implementation class " + className, (Throwable)e);
        }
        return builder;
    }

    protected static String getImplementationClassName(Profile.Section iniSection) {
        return (String)iniSection.get((Object)"implementation");
    }
}

