/*
 * Decompiled with CFR 0.152.
 */
package org.glite.pseudo.server.caclient.impl;

import com.novosec.pkix.asn1.cmp.CertRepMessage;
import com.novosec.pkix.asn1.cmp.CertResponse;
import com.novosec.pkix.asn1.cmp.PKIMessage;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import org.apache.http.HttpResponse;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.bouncycastle.jce.provider.X509CertificateObject;
import org.glite.pseudo.common.pki.Certificate;
import org.glite.pseudo.server.caclient.CAClientException;
import org.glite.pseudo.server.caclient.CAResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMPResponse
implements CAResponse {
    private static Logger log = LoggerFactory.getLogger(CMPResponse.class);
    private PKIMessage pkiMessage;

    public CMPResponse(HttpResponse caResponse) throws CAClientException {
        if (caResponse == null) {
            throw new CAClientException("The response was empty!");
        }
        try {
            InputStream input = caResponse.getEntity().getContent();
            this.pkiMessage = PKIMessage.getInstance((Object)new ASN1InputStream(input).readObject());
            input.close();
        }
        catch (IOException e) {
            log.error("Error while creating PKIMessage object!", (Throwable)e);
        }
    }

    public Certificate getCertificate(Principal subject) throws CAClientException {
        CertRepMessage certRepMessage = this.pkiMessage.getBody().getCp();
        CertResponse certResp = certRepMessage.getResponse(0);
        if (certResp == null) {
            log.error("No certificates found from the response!");
            return null;
        }
        X509CertificateStructure certSt = certResp.getCertifiedKeyPair().getCertOrEncCert().getCertificate();
        X509CertificateObject certObject = null;
        try {
            certObject = new X509CertificateObject(certSt);
        }
        catch (Exception e) {
            log.error("Error while creating certObject: " + e);
            throw new CAClientException(e);
        }
        if (((Object)certObject.getSubjectDN()).equals(subject)) {
            log.info("The certificate subject matched with the requested one.");
            X509CertificateObject cert = certObject;
            try {
                return new Certificate((X509Certificate)cert);
            }
            catch (GeneralSecurityException e) {
                throw new CAClientException(e);
            }
        }
        log.warn("The certificate subject did NOT match with the requested one!");
        return null;
    }
}

