/*
 * Decompiled with CFR 0.152.
 */
package org.glite.pseudo.server.caclient.impl;

import com.novosec.pkix.asn1.cmp.PKIBody;
import com.novosec.pkix.asn1.cmp.PKIHeader;
import com.novosec.pkix.asn1.cmp.PKIMessage;
import com.novosec.pkix.asn1.crmf.CertReqMessages;
import com.novosec.pkix.asn1.crmf.CertReqMsg;
import com.novosec.pkix.asn1.crmf.CertRequest;
import com.novosec.pkix.asn1.crmf.CertTemplate;
import com.novosec.pkix.asn1.crmf.OptionalValidity;
import com.novosec.pkix.asn1.crmf.PBMParameter;
import com.novosec.pkix.asn1.crmf.ProofOfPossession;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.TimeZone;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.Time;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import org.glite.pseudo.common.pki.CertificateRequest;
import org.glite.pseudo.server.caclient.CARequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMPRequest
implements CARequest {
    private static final int REQUEST_ID_MAXIMUM = 640000000;
    private static Logger log = LoggerFactory.getLogger(CMPRequest.class);
    private PKIMessage pkiMessage;
    private Properties cmpProperties;

    protected CMPRequest(CertificateRequest certRequest, Properties cmpProps) {
        this.cmpProperties = cmpProps;
        this.addCertificateRequest(certRequest);
    }

    public void addCertificateRequest(CertificateRequest certRequest) {
        String issuerDN = this.cmpProperties.getProperty("CADN");
        CertTemplate certTemplate = CMPRequest.makeCertTemplate(certRequest, issuerDN);
        int requestId = CMPRequest.makeRandomInt(640000000);
        log.debug("Constructing CMP CertRequest with id={}", (Object)requestId);
        CertRequest cmpCertRequest = new CertRequest(new DERInteger(requestId), certTemplate);
        CertReqMsg cmpCertReqMsg = new CertReqMsg(cmpCertRequest);
        ProofOfPossession pop = new ProofOfPossession((DEREncodable)new DERNull(), 0);
        cmpCertReqMsg.setPop(pop);
        CertReqMessages cmpCertReqMessages = new CertReqMessages(cmpCertReqMsg);
        PKIBody pkiBody = new PKIBody((DEREncodable)cmpCertReqMessages, 2);
        String saltStr = this.cmpProperties.getProperty("SaltString");
        String owfAlgIdStr = this.cmpProperties.getProperty("OwfAlgId");
        String macAlgIdStr = this.cmpProperties.getProperty("MacAlgId");
        String iterCountStr = this.cmpProperties.getProperty("IterCount");
        String senderDN = this.cmpProperties.getProperty("SenderDN");
        String recipientDN = this.cmpProperties.getProperty("RecipientDN");
        String sharedSecret = this.cmpProperties.getProperty("SharedSecret");
        String senderKID = this.cmpProperties.getProperty("SenderKID");
        String protectionAlgIdStr = this.cmpProperties.getProperty("ProtectionAlgId");
        int iterCountInt = new Integer(iterCountStr);
        DEROctetString salt = new DEROctetString(saltStr.getBytes());
        log.debug("Generating a PKIHeader for the message");
        PKIHeader pkiHeader = CMPRequest.makePKIHeader(senderDN, recipientDN, senderKID, salt, owfAlgIdStr, macAlgIdStr, iterCountInt, protectionAlgIdStr);
        log.debug("Generating a PKIMessage");
        this.pkiMessage = new PKIMessage(pkiHeader, pkiBody);
        byte[] protectionBytes = CMPRequest.makeProtection(sharedSecret, iterCountInt, owfAlgIdStr, macAlgIdStr, salt, this.pkiMessage);
        this.pkiMessage.setProtection(new DERBitString(protectionBytes));
        log.debug("pkiMessage = {}", (Object)this.pkiMessage.toString());
    }

    public byte[] getDEREncoded() {
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        DEROutputStream out = new DEROutputStream((OutputStream)bao);
        try {
            out.writeObject((Object)this.pkiMessage);
        }
        catch (IOException e) {
            log.error("IOException caught while DER-encoding PKIMessage! " + e.getMessage());
        }
        return bao.toByteArray();
    }

    private static byte[] makeProtection(String secret, int iterCount, String owfAlgId, String macAlgId, DEROctetString salt, PKIMessage message) {
        int i;
        byte[] saltBytes = salt.getOctets();
        byte[] sharedSecret = secret.getBytes();
        byte[] firstKey = new byte[sharedSecret.length + saltBytes.length];
        log.debug("length for the firstKey={}", (Object)firstKey.length);
        for (i = 0; i < sharedSecret.length; ++i) {
            firstKey[i] = sharedSecret[i];
        }
        for (i = 0; i < saltBytes.length; ++i) {
            firstKey[sharedSecret.length + i] = saltBytes[i];
        }
        MessageDigest dig = null;
        Mac mac = null;
        try {
            dig = MessageDigest.getInstance(owfAlgId, "BC");
            for (int i2 = 0; i2 < iterCount; ++i2) {
                firstKey = dig.digest(firstKey);
                dig.reset();
            }
            mac = Mac.getInstance(macAlgId, "BC");
            SecretKeySpec key = new SecretKeySpec(firstKey, macAlgId);
            mac.init(key);
        }
        catch (Exception e) {
            log.error("Error while calculating PKIMessage protection", (Throwable)e);
        }
        log.debug("Calculation done, reseting MAC.");
        mac.reset();
        log.debug("Obtaining the protection bytes.");
        byte[] protectedBytes = message.getProtectedBytes();
        log.debug("Protection successfully calculated, protection length={}.", (Object)protectedBytes.length);
        mac.update(protectedBytes, 0, protectedBytes.length);
        return mac.doFinal();
    }

    private static CertTemplate makeCertTemplate(CertificateRequest certRequest, String issuerDN) {
        PKCS10CertificationRequest pkcs10 = new PKCS10CertificationRequest(certRequest.getDEREncoded());
        CertificationRequestInfo pkcs10info = pkcs10.getCertificationRequestInfo();
        log.debug("Constructing CMP CertTemplate...");
        CertTemplate certTemplate = new CertTemplate();
        certTemplate.setPublicKey(pkcs10info.getSubjectPublicKeyInfo());
        certTemplate.setSubject(pkcs10info.getSubject());
        certTemplate.setIssuer(new X509Name(issuerDN));
        OptionalValidity validity = new OptionalValidity();
        GregorianCalendar date = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        date.add(12, -5);
        Time notBefore = new Time(date.getTime());
        date.add(12, 5);
        date.add(13, 1000000);
        Time notAfter = new Time(date.getTime());
        validity.setNotBefore(notBefore);
        validity.setNotAfter(notAfter);
        certTemplate.setValidity(validity);
        log.debug("Constructed certTemplate={}", (Object)certTemplate.toString());
        return certTemplate;
    }

    private static PKIHeader makePKIHeader(String senderDN, String recipientDN, String senderKID, DEROctetString salt, String owfAlgIdStr, String macAlgIdStr, int iterCountInt, String protectionAlgIdStr) {
        AlgorithmIdentifier owfAlgId = new AlgorithmIdentifier(new DERObjectIdentifier(owfAlgIdStr));
        AlgorithmIdentifier macAlgId = new AlgorithmIdentifier(new DERObjectIdentifier(macAlgIdStr));
        DERInteger iterCount = new DERInteger(iterCountInt);
        PBMParameter params = new PBMParameter(salt, owfAlgId, iterCount, macAlgId);
        AlgorithmIdentifier algId = new AlgorithmIdentifier(new DERObjectIdentifier(protectionAlgIdStr), (DEREncodable)params);
        PKIHeader pkiHeader = new PKIHeader(new DERInteger(2), new GeneralName(new X509Name(senderDN)), new GeneralName(new X509Name(recipientDN)));
        pkiHeader.setSenderKID(new DEROctetString(senderKID.getBytes()));
        pkiHeader.setProtectionAlg(algId);
        return pkiHeader;
    }

    private static int makeRandomInt(int digits) {
        SecureRandom random = new SecureRandom();
        return random.nextInt(digits);
    }
}

