/*
 * Decompiled with CFR 0.152.
 */
package org.glite.pseudo.server.caclient.impl;

import com.novosec.pkix.asn1.cmp.CMPObjectIdentifiers;
import java.util.Properties;
import org.apache.http.client.HttpClient;
import org.glite.pseudo.common.http.HttpClientBuilder;
import org.glite.pseudo.server.PseudoServerException;
import org.glite.pseudo.server.caclient.CAClient;
import org.glite.pseudo.server.caclient.CAClientException;
import org.glite.pseudo.server.caclient.CAConnection;
import org.glite.pseudo.server.caclient.impl.AbstractSSLClient;
import org.glite.pseudo.server.caclient.impl.CMPConnection;
import org.glite.pseudo.server.config.PseudoServerConfiguration;
import org.ini4j.Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMPClient
extends AbstractSSLClient
implements CAClient {
    public static final String CA_DN_IDENTIFIER = "CADN";
    public static final String SENDER_DN_IDENTIFIER = "SenderDN";
    public static final String RECIPIENT_DN_IDENTIFIER = "RecipientDN";
    public static final String SENDER_KID_IDENTIFIER = "SenderKID";
    public static final String SHARED_SECRET_IDENTIFIER = "SharedSecret";
    public static final String OWF_ALG_ID_IDENTIFIER = "OwfAlgId";
    public static final String ITERATION_COUNT_IDENTIFIER = "IterCount";
    public static final String MAC_ALG_ID_IDENTIFIER = "MacAlgId";
    public static final String SALT_STRING_IDENTIFIER = "SaltString";
    public static final String PROTECTION_ALG_ID_IDENTIFIER = "ProtectionAlgId";
    public static final String DEFAULT_OWF_ALGID = "1.3.14.3.2.26";
    public static final String DEFAULT_ITERATION_COUNT = "1";
    public static final String DEFAULT_MAC_ALGID = "1.3.6.1.5.5.8.1.2";
    public static final String DEFAULT_PROTECTION_ALGID = CMPObjectIdentifiers.passwordBasedMac.toString();
    private static Logger log = LoggerFactory.getLogger(CMPClient.class);
    private HttpClient httpClient;
    private Properties cmpProperties;

    protected void setCmpProperties(Profile.Section cfgSection) throws CAClientException {
        this.cmpProperties = new Properties();
        this.generateCmpProperties(cfgSection);
    }

    public CAConnection getConnection() throws CAClientException {
        return new CMPConnection(this);
    }

    private void generateCmpProperties(Profile.Section cfgSection) throws CAClientException {
        this.addCmpConfigurationVariable(cfgSection, CA_DN_IDENTIFIER, null);
        this.addCmpConfigurationVariable(cfgSection, SENDER_DN_IDENTIFIER, null);
        this.addCmpConfigurationVariable(cfgSection, RECIPIENT_DN_IDENTIFIER, null);
        this.addCmpConfigurationVariable(cfgSection, SENDER_KID_IDENTIFIER, null);
        this.addCmpConfigurationVariable(cfgSection, SHARED_SECRET_IDENTIFIER, null);
        this.addCmpConfigurationVariable(cfgSection, OWF_ALG_ID_IDENTIFIER, DEFAULT_OWF_ALGID);
        this.addCmpConfigurationVariable(cfgSection, ITERATION_COUNT_IDENTIFIER, DEFAULT_ITERATION_COUNT);
        this.addCmpConfigurationVariable(cfgSection, MAC_ALG_ID_IDENTIFIER, DEFAULT_MAC_ALGID);
        this.addCmpConfigurationVariable(cfgSection, SALT_STRING_IDENTIFIER, "");
        this.addCmpConfigurationVariable(cfgSection, PROTECTION_ALG_ID_IDENTIFIER, DEFAULT_PROTECTION_ALGID);
    }

    private void addCmpConfigurationVariable(Profile.Section cfgSection, String variable, String defaultValue) throws CAClientException {
        String str = (String)cfgSection.get((Object)variable);
        if (str == null || str.equals("")) {
            if (defaultValue == null) {
                throw new CAClientException(variable + " is a required variable!");
            }
            log.info("CAClient." + variable + "='" + defaultValue + "' (was null, using default)");
            this.cmpProperties.setProperty(variable, defaultValue);
        } else {
            this.cmpProperties.setProperty(variable, str);
            log.info(variable + "=" + str);
        }
    }

    private HttpClient createHttpClient(String keyFile, String keyPasswd, String certFile, String truststorePath, String truststorePasswd, String crlCheck) throws CAClientException {
        HttpClientBuilder httpBuilder = new HttpClientBuilder(this.endpoint, certFile, keyFile, keyPasswd);
        HttpClient httpClient = null;
        try {
            httpClient = httpBuilder.buildClient();
        }
        catch (Exception e) {
            log.error("Could not build the httpClient!", (Throwable)e);
            throw new CAClientException("The HTTP client could not be built!", e);
        }
        return httpClient;
    }

    public void shutdown() {
        super.shutdown();
        this.httpClient.getConnectionManager().shutdown();
        this.httpClient = null;
    }

    protected HttpClient getHttpClient() {
        return this.httpClient;
    }

    protected Properties getCmpProperties() {
        return this.cmpProperties;
    }

    protected String getServerUrl() {
        return this.endpoint;
    }

    public void init(PseudoServerConfiguration configuration) throws PseudoServerException {
        log.debug("Initializing CMPClient");
        Profile.Section cfgSection = configuration.getCAClientConfiguration();
        super.init(cfgSection);
        try {
            this.httpClient = this.createHttpClient(this.keyFile, this.keyPasswd, this.certFile, this.truststoreFile, this.truststorePasswd, this.crlCheck);
            this.setCmpProperties(cfgSection);
        }
        catch (CAClientException e) {
            log.error("Could not initialize a CMPClient", (Throwable)e);
            throw new PseudoServerException("Could not initialize a CMPClient", e);
        }
    }
}

