/*
 * Decompiled with CFR 0.152.
 */
package org.glite.pseudo.server.acl.impl;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.FileConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.glite.pseudo.server.PseudoServerException;
import org.glite.pseudo.server.acl.AccessControlList;
import org.glite.pseudo.server.acl.AccessControlRule;
import org.glite.pseudo.server.attribute.Attribute;
import org.glite.pseudo.server.attribute.AttributeDefinitions;
import org.glite.pseudo.server.config.PseudoServerConfiguration;
import org.ini4j.Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLFileAccessControlList
implements AccessControlList,
ApplicationContextAware {
    private static String ACLFILE_CONFIG_PARAM = "ACLFile";
    private static Logger log = LoggerFactory.getLogger(XMLFileAccessControlList.class);
    private XMLConfiguration aclXMLConfiguration_ = null;
    private List<AccessControlRule> accessControlRules_ = null;
    private ApplicationContext context;

    @Override
    public void init(PseudoServerConfiguration configuration) throws PseudoServerException {
        Profile.Section cfgSection = configuration.getAdminAccessControlListConfiguration();
        String filename = (String)cfgSection.get((Object)ACLFILE_CONFIG_PARAM);
        log.info("{}={}", (Object)ACLFILE_CONFIG_PARAM, (Object)filename);
        if (filename == null) {
            throw new PseudoServerException("Configuration parameter " + ACLFILE_CONFIG_PARAM + " is not defined");
        }
        this.aclXMLConfiguration_ = XMLFileAccessControlList.createACLXMLConfiguration(filename);
        log.info("XMLFileAccessControlList successfully initialized");
    }

    @Override
    public boolean isAuthorized(List<Attribute> userAttributes) {
        if (log.isDebugEnabled()) {
            log.debug("userAttributes=" + userAttributes);
        }
        boolean authorized = false;
        if (this.accessControlRules_ == null) {
            log.debug("accessControlRules_ was empty, creating a new one");
            this.accessControlRules_ = XMLFileAccessControlList.createACLAccessControlRules((FileConfiguration)this.aclXMLConfiguration_, (AttributeDefinitions)this.context.getBean("pseudonymity.AttributeDefinitions"));
            log.debug("new accessControlRules_ successfully created");
        }
        Iterator<AccessControlRule> rules = this.accessControlRules_.iterator();
        while (!authorized && rules.hasNext()) {
            AccessControlRule rule = rules.next();
            List<Attribute> ruleAttributes = rule.getAttributes();
            if (log.isDebugEnabled()) {
                log.debug("checking rule:" + rule);
            }
            if (!userAttributes.containsAll(ruleAttributes)) continue;
            authorized = true;
            log.info("User authorized by rule: " + rule);
        }
        if (!authorized) {
            log.warn("User not authorized: " + userAttributes);
        }
        return authorized;
    }

    @Override
    public void shutdown() {
    }

    private static XMLConfiguration createACLXMLConfiguration(String filename) throws PseudoServerException {
        XMLConfiguration config = null;
        try {
            log.info("XMLConfiguration file=" + filename);
            config = new XMLConfiguration(filename);
            if (log.isDebugEnabled()) {
                File configFile = config.getFile();
                log.debug("XMLConfiguration file=" + configFile.getAbsolutePath());
            }
        }
        catch (ConfigurationException e) {
            log.error("Failed to create XMLConfiguration: " + filename, (Throwable)e);
            throw new PseudoServerException("Failed to create XMLConfiguration: " + filename, (Exception)((Object)e));
        }
        return config;
    }

    private static List<AccessControlRule> createACLAccessControlRules(FileConfiguration config, AttributeDefinitions attributeDefinitions) {
        String rulePrefix;
        LinkedList<AccessControlRule> accessControlRules = new LinkedList<AccessControlRule>();
        int i = 0;
        while (true) {
            rulePrefix = "AccessControlRule(" + i + ")";
            ++i;
            String ruleGroup = config.getString(rulePrefix + "[@group]");
            if (ruleGroup == null) break;
            int ruleId = config.getInt(rulePrefix + "[@id]");
            AccessControlRule rule = new AccessControlRule(ruleId, ruleGroup);
            List attributeNames = config.getList(rulePrefix + ".Attribute[@name]");
            log.debug("Found {} attributes for the rule", (Object)attributeNames.size());
            if (attributeNames.isEmpty()) {
                log.error(rulePrefix + ": no attribute in rule, skipping...");
                continue;
            }
            List attributeValues = config.getList(rulePrefix + ".Attribute");
            for (int j = 0; j < attributeNames.size(); ++j) {
                String name = (String)attributeNames.get(j);
                String value = (String)attributeValues.get(j);
                Attribute attribute = attributeDefinitions.createAttribute(name, value);
                rule.addAttribute(attribute);
            }
            if (log.isDebugEnabled()) {
                log.debug("adding rule in ACL: " + rule);
            }
            accessControlRules.add(rule);
        }
        log.debug("{}: no more rules", (Object)rulePrefix);
        return accessControlRules;
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        log.debug("Setting the Spring application context");
        this.context = context;
    }
}

