/*
 * Decompiled with CFR 0.152.
 */
package org.glite.pseudo.server.aaclient.impl;

import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.emi.security.authn.x509.X509Credential;
import eu.emi.security.authn.x509.impl.SocketFactoryCreator;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.GeneralSecurityException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.axis.AxisFault;
import org.apache.axis.Handler;
import org.apache.axis.MessageContext;
import org.apache.axis.SimpleChain;
import org.apache.axis.SimpleTargetedChain;
import org.apache.axis.components.net.BooleanHolder;
import org.apache.axis.configuration.SimpleProvider;
import org.apache.axis.transport.http.HTTPSender;
import org.apache.axis.transport.http.SocketHolder;

public class SSLConfigSender
extends HTTPSender {
    private static final long serialVersionUID = 5618874867252751715L;
    private X509Credential credential;
    private X509CertChainValidator chainValidator;

    public SSLConfigSender(X509Credential credential, X509CertChainValidator validator) {
        this.credential = credential;
        this.chainValidator = validator;
    }

    public static SimpleProvider getTransportProvider(X509Credential credential, X509CertChainValidator validator) throws AxisFault {
        SimpleProvider transportProvider = new SimpleProvider();
        SSLConfigSender sslHandler = new SSLConfigSender(credential, validator);
        SimpleTargetedChain transport = new SimpleTargetedChain((Handler)new SimpleChain(), (Handler)sslHandler, (Handler)new SimpleChain());
        transportProvider.deployTransport("http", (Handler)transport);
        return transportProvider;
    }

    protected void getSocket(SocketHolder sockHolder, MessageContext msgContext, String protocol, String host, int port, int timeout, StringBuffer otherHeaders, BooleanHolder useFullURL) throws IOException, GeneralSecurityException, Exception {
        if (protocol.equalsIgnoreCase("https")) {
            SSLSocketFactory fac = SocketFactoryCreator.getSocketFactory((X509Credential)this.credential, (X509CertChainValidator)this.chainValidator);
            SSLSocket socket = (SSLSocket)fac.createSocket();
            socket.setUseClientMode(true);
            if (timeout >= 0) {
                socket.connect(new InetSocketAddress(host, port), timeout);
                socket.setSoTimeout(timeout);
            } else {
                socket.connect(new InetSocketAddress(host, port));
            }
            sockHolder.setSocket((Socket)socket);
        } else {
            super.getSocket(sockHolder, msgContext, protocol, host, port, timeout, otherHeaders, useFullURL);
        }
    }
}

