/*
 * Decompiled with CFR 0.152.
 */
package com.novosec.pkix.asn1.crmf;

import com.novosec.pkix.asn1.crmf.EncryptedValue;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.cms.EnvelopedData;

public class EncryptedKey
implements DEREncodable {
    public static final int TAGNO_ENV_DATA = 0;
    public static final int TAGNO_ENC_VALUE = 1;
    private int tagNo = -1;
    private DEREncodable obj = null;
    private EncryptedValue encryptedValue = null;

    public static EncryptedKey getInstance(DEREncodable derObj) {
        if (derObj instanceof EnvelopedData) {
            return new EncryptedKey((EnvelopedData)derObj);
        }
        if (derObj instanceof EncryptedValue) {
            return new EncryptedKey((EncryptedValue)derObj);
        }
        if (derObj instanceof ASN1TaggedObject) {
            return EncryptedKey.getInstance((ASN1TaggedObject)derObj, false);
        }
        return new EncryptedKey(EncryptedValue.getInstance(derObj));
    }

    public static EncryptedKey getInstance(ASN1TaggedObject tagObj, boolean explicit) {
        int tag = tagObj == null ? -1 : tagObj.getTagNo();
        switch (tag) {
            case 0: {
                return new EncryptedKey(EnvelopedData.getInstance((ASN1TaggedObject)tagObj, (boolean)explicit));
            }
        }
        return new EncryptedKey(EncryptedValue.getInstance(tagObj, explicit));
    }

    public EncryptedKey(DEREncodable derObj, int tag) {
        this.tagNo = tag;
        if (derObj instanceof EnvelopedData) {
            this.obj = (EnvelopedData)derObj;
        } else if (derObj instanceof EncryptedValue) {
            this.encryptedValue = (EncryptedValue)derObj;
        } else {
            switch (this.tagNo) {
                case 0: {
                    this.obj = EnvelopedData.getInstance((Object)derObj);
                    break;
                }
                default: {
                    this.encryptedValue = EncryptedValue.getInstance(derObj);
                }
            }
        }
    }

    public EncryptedKey(EnvelopedData envelopedData) {
        this((DEREncodable)envelopedData, 0);
    }

    public EncryptedKey(EncryptedValue encryptedValue) {
        this(encryptedValue, 1);
    }

    public void setEncryptedValue(EncryptedValue value) {
        this.encryptedValue = value;
    }

    public EncryptedValue getEncryptedValue() {
        return this.encryptedValue;
    }

    public void setTagNo(int tn) {
        this.tagNo = tn;
    }

    public int getTagNo() {
        return this.tagNo;
    }

    public EnvelopedData getEnvelopedData() {
        return EnvelopedData.getInstance((Object)this.obj);
    }

    public DERObject getDERObject() {
        if (this.encryptedValue != null) {
            return this.encryptedValue.getDERObject();
        }
        if (this.obj != null) {
            return new DERTaggedObject(true, this.tagNo, this.obj);
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append(" (");
        sb.append("tagNo: " + this.tagNo + ", ");
        if (this.encryptedValue != null) {
            sb.append("encryptedValue: " + this.encryptedValue + ", ");
        }
        if (this.obj != null) {
            sb.append("envelopedData: " + this.obj + ", ");
        }
        sb.append("hashCode: " + Integer.toHexString(this.hashCode()) + ")");
        return sb.toString();
    }
}

