/*
 * Decompiled with CFR 0.152.
 */
package com.novosec.pkix.asn1.cmp;

import com.novosec.pkix.asn1.cmp.InfoTypeAndValue;
import com.novosec.pkix.asn1.cmp.PKIFreeText;
import java.util.Enumeration;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.GeneralName;

public class PKIHeader
implements DEREncodable {
    DERInteger pvno;
    GeneralName sender;
    GeneralName recipient;
    DERGeneralizedTime messageTime;
    AlgorithmIdentifier protectionAlg;
    DEROctetString senderKID;
    DEROctetString recipKID;
    DEROctetString transactionID;
    DEROctetString senderNonce;
    DEROctetString recipNonce;
    PKIFreeText freeText;
    Vector generalInfos = new Vector();

    public static PKIHeader getInstance(ASN1TaggedObject obj, boolean explicit) {
        return PKIHeader.getInstance(ASN1Sequence.getInstance((ASN1TaggedObject)obj, (boolean)explicit));
    }

    public static PKIHeader getInstance(Object obj) {
        if (obj instanceof PKIHeader) {
            return (PKIHeader)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new PKIHeader((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public PKIHeader(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        this.pvno = DERInteger.getInstance(e.nextElement());
        this.sender = GeneralName.getInstance(e.nextElement());
        this.recipient = GeneralName.getInstance(e.nextElement());
        while (e.hasMoreElements()) {
            ASN1TaggedObject tagObj = (ASN1TaggedObject)e.nextElement();
            switch (tagObj.getTagNo()) {
                case 0: {
                    this.messageTime = DERGeneralizedTime.getInstance((Object)tagObj.getObject());
                    break;
                }
                case 1: {
                    this.protectionAlg = AlgorithmIdentifier.getInstance((Object)tagObj.getObject());
                    break;
                }
                case 2: {
                    this.senderKID = (DEROctetString)DEROctetString.getInstance((Object)tagObj);
                    break;
                }
                case 3: {
                    this.recipKID = (DEROctetString)DEROctetString.getInstance((Object)tagObj);
                    break;
                }
                case 4: {
                    this.transactionID = (DEROctetString)DEROctetString.getInstance((Object)tagObj);
                    break;
                }
                case 5: {
                    this.senderNonce = (DEROctetString)DEROctetString.getInstance((Object)tagObj);
                    break;
                }
                case 6: {
                    this.recipNonce = (DEROctetString)DEROctetString.getInstance((Object)tagObj);
                    break;
                }
                case 7: {
                    this.freeText = PKIFreeText.getInstance(tagObj.getObject());
                    break;
                }
                case 8: {
                    ASN1Sequence s = (ASN1Sequence)tagObj.getObject();
                    for (int i = 0; i < s.size(); ++i) {
                        this.generalInfos.addElement(InfoTypeAndValue.getInstance(s.getObjectAt(i)));
                    }
                    break;
                }
            }
        }
    }

    public PKIHeader(DERInteger pvno, GeneralName sender, GeneralName recipient) {
        this.pvno = pvno;
        this.sender = sender;
        this.recipient = recipient;
    }

    public DERInteger getPvno() {
        return this.pvno;
    }

    public GeneralName getSender() {
        return this.sender;
    }

    public GeneralName getRecipient() {
        return this.recipient;
    }

    public void setMessageTime(DERGeneralizedTime messageTime) {
        this.messageTime = messageTime;
    }

    public DERGeneralizedTime getMessageTime() {
        return this.messageTime;
    }

    public void setProtectionAlg(AlgorithmIdentifier protectionAlg) {
        this.protectionAlg = protectionAlg;
    }

    public AlgorithmIdentifier getProtectionAlg() {
        return this.protectionAlg;
    }

    public void setSenderKID(DEROctetString senderKID) {
        this.senderKID = senderKID;
    }

    public DEROctetString getSenderKID() {
        return this.senderKID;
    }

    public void setRecipKID(DEROctetString recipKID) {
        this.recipKID = recipKID;
    }

    public DEROctetString getRecipKID() {
        return this.recipKID;
    }

    public void setTransactionID(DEROctetString transactionID) {
        this.transactionID = transactionID;
    }

    public DEROctetString getTransactionID() {
        return this.transactionID;
    }

    public void setSenderNonce(DEROctetString senderNonce) {
        this.senderNonce = senderNonce;
    }

    public DEROctetString getSenderNonce() {
        return this.senderNonce;
    }

    public void setRecipNonce(DEROctetString recipNonce) {
        this.recipNonce = recipNonce;
    }

    public DEROctetString getRecipNonce() {
        return this.recipNonce;
    }

    public void setFreeText(PKIFreeText freeText) {
        this.freeText = freeText;
    }

    public PKIFreeText getFreeText() {
        return this.freeText;
    }

    public void addGeneralInfo(InfoTypeAndValue generalInfo) {
        this.generalInfos.addElement(generalInfo);
    }

    public InfoTypeAndValue getGeneralInfo(int nr) {
        if (this.generalInfos.size() > nr) {
            return (InfoTypeAndValue)this.generalInfos.elementAt(nr);
        }
        return null;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)this.pvno);
        v.add((DEREncodable)this.sender);
        v.add((DEREncodable)this.recipient);
        if (this.messageTime != null) {
            v.add((DEREncodable)new DERTaggedObject(true, 0, (DEREncodable)this.messageTime));
        }
        if (this.protectionAlg != null) {
            v.add((DEREncodable)new DERTaggedObject(true, 1, (DEREncodable)this.protectionAlg));
        }
        if (this.senderKID != null) {
            v.add((DEREncodable)new DERTaggedObject(true, 2, (DEREncodable)this.senderKID));
        }
        if (this.recipKID != null) {
            v.add((DEREncodable)new DERTaggedObject(true, 3, (DEREncodable)this.recipKID));
        }
        if (this.transactionID != null) {
            v.add((DEREncodable)new DERTaggedObject(true, 4, (DEREncodable)this.transactionID));
        }
        if (this.senderNonce != null) {
            v.add((DEREncodable)new DERTaggedObject(true, 5, (DEREncodable)this.senderNonce));
        }
        if (this.recipNonce != null) {
            v.add((DEREncodable)new DERTaggedObject(true, 6, (DEREncodable)this.recipNonce));
        }
        if (this.freeText != null) {
            v.add((DEREncodable)new DERTaggedObject(true, 7, (DEREncodable)this.freeText));
        }
        if (this.generalInfos.size() > 0) {
            ASN1EncodableVector giv = new ASN1EncodableVector();
            for (int i = 0; i < this.generalInfos.size(); ++i) {
                giv.add((DEREncodable)((InfoTypeAndValue)this.generalInfos.elementAt(i)));
            }
            v.add((DEREncodable)new DERTaggedObject(true, 8, (DEREncodable)new DERSequence(giv)));
        }
        return new DERSequence(v);
    }

    public String toString() {
        String s = "PKIHeader: ( pvno: " + this.pvno + ", sender: " + this.sender + ", recipient: " + this.recipient + ", ";
        if (this.messageTime != null) {
            s = s + "messageTime: " + this.messageTime + ", ";
        }
        if (this.protectionAlg != null) {
            s = s + "protectionAlg: " + this.protectionAlg + ", ";
        }
        if (this.senderKID != null) {
            s = s + "senderKID: " + this.senderKID + ", ";
        }
        if (this.recipKID != null) {
            s = s + "recipKID: " + this.recipKID + ", ";
        }
        if (this.transactionID != null) {
            s = s + "transactionID: " + this.transactionID + ", ";
        }
        if (this.senderNonce != null) {
            s = s + "senderNonce: " + this.senderNonce + ", ";
        }
        if (this.recipNonce != null) {
            s = s + "recipNonce: " + this.recipNonce + ", ";
        }
        if (this.freeText != null) {
            s = s + "freeText: " + this.freeText + ", ";
        }
        if (this.generalInfos.size() > 0) {
            s = s + "generalInfo: (";
            for (int i = 0; i < this.generalInfos.size(); ++i) {
                s = s + this.generalInfos.elementAt(i) + ", ";
            }
            s = s + ")";
        }
        return s;
    }
}

