/*
 * Decompiled with CFR 0.152.
 */
package com.novosec.pkix.asn1.cmp;

import com.novosec.pkix.asn1.crmf.CertId;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class OOBCertHash
implements DEREncodable {
    AlgorithmIdentifier hashAlg;
    CertId certId;
    DERBitString hashVal;

    public static OOBCertHash getInstance(ASN1TaggedObject obj, boolean explicit) {
        return OOBCertHash.getInstance(ASN1Sequence.getInstance((ASN1TaggedObject)obj, (boolean)explicit));
    }

    public static OOBCertHash getInstance(Object obj) {
        if (obj instanceof OOBCertHash) {
            return (OOBCertHash)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new OOBCertHash((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public OOBCertHash(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            if (obj instanceof ASN1TaggedObject) {
                ASN1TaggedObject tagObj = (ASN1TaggedObject)obj;
                switch (tagObj.getTagNo()) {
                    case 0: {
                        this.hashAlg = AlgorithmIdentifier.getInstance((Object)tagObj.getObject());
                        break;
                    }
                    case 1: {
                        this.certId = CertId.getInstance(tagObj.getObject());
                    }
                }
                continue;
            }
            this.hashVal = DERBitString.getInstance(obj);
            break;
        }
    }

    public OOBCertHash(DERBitString hashVal) {
        this.hashVal = hashVal;
    }

    public DERBitString getHashVal() {
        return this.hashVal;
    }

    public void setHashAlg(AlgorithmIdentifier hashAlg) {
        this.hashAlg = hashAlg;
    }

    public AlgorithmIdentifier getHashAlg() {
        return this.hashAlg;
    }

    public void setCertId(CertId certId) {
        this.certId = certId;
    }

    public CertId getCertId() {
        return this.certId;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (this.hashAlg != null) {
            v.add((DEREncodable)new DERTaggedObject(true, 0, (DEREncodable)this.hashAlg));
        }
        if (this.certId != null) {
            v.add((DEREncodable)new DERTaggedObject(true, 1, (DEREncodable)this.certId));
        }
        v.add((DEREncodable)this.hashVal);
        return new DERSequence(v);
    }

    public String toString() {
        String s = "OOBCertHash: ( ";
        if (this.getHashAlg() != null) {
            s = s + "hashAlg: " + this.getHashAlg() + ", ";
        }
        if (this.getCertId() != null) {
            s = s + "certId: " + this.getCertId() + ", ";
        }
        s = s + "hashVal: " + this.getHashVal();
        s = s + ")";
        return s;
    }
}

