/*
 * Decompiled with CFR 0.152.
 */
package com.novosec.pkix.asn1.cmp;

import com.novosec.pkix.asn1.cmp.CertOrEncCert;
import com.novosec.pkix.asn1.crmf.EncryptedValue;
import com.novosec.pkix.asn1.crmf.PKIPublicationInfo;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;

public class CertifiedKeyPair
implements DEREncodable {
    CertOrEncCert certOrEncCert;
    EncryptedValue privateKey;
    PKIPublicationInfo publicationInfo;

    public static CertifiedKeyPair getInstance(ASN1TaggedObject obj, boolean explicit) {
        return CertifiedKeyPair.getInstance(ASN1Sequence.getInstance((ASN1TaggedObject)obj, (boolean)explicit));
    }

    public static CertifiedKeyPair getInstance(Object obj) {
        if (obj instanceof CertifiedKeyPair) {
            return (CertifiedKeyPair)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new CertifiedKeyPair((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory");
    }

    public CertifiedKeyPair(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        this.certOrEncCert = CertOrEncCert.getInstance((DERObject)e.nextElement());
        while (e.hasMoreElements()) {
            ASN1TaggedObject tagObj = (ASN1TaggedObject)e.nextElement();
            switch (tagObj.getTagNo()) {
                case 0: {
                    this.privateKey = EncryptedValue.getInstance(tagObj.getObject());
                    break;
                }
                case 1: {
                    this.publicationInfo = PKIPublicationInfo.getInstance(tagObj.getObject());
                }
            }
        }
    }

    public CertifiedKeyPair(CertOrEncCert certOrEncCert) {
        this.certOrEncCert = certOrEncCert;
    }

    public CertOrEncCert getCertOrEncCert() {
        return this.certOrEncCert;
    }

    public void setPrivateKey(EncryptedValue privateKey) {
        this.privateKey = privateKey;
    }

    public EncryptedValue getPrivateKey() {
        return this.privateKey;
    }

    public void setPublicationInfo(PKIPublicationInfo publicationInfo) {
        this.publicationInfo = publicationInfo;
    }

    public PKIPublicationInfo getPublicationInfo() {
        return this.publicationInfo;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)this.certOrEncCert);
        if (this.privateKey != null) {
            v.add((DEREncodable)new DERTaggedObject(true, 0, (DEREncodable)this.privateKey));
        }
        if (this.publicationInfo != null) {
            v.add((DEREncodable)new DERTaggedObject(true, 1, (DEREncodable)this.publicationInfo));
        }
        return new DERSequence(v);
    }

    public String toString() {
        String s = "CertifiedKeyPair: ( certOrEncCert: " + this.getCertOrEncCert() + ", ";
        if (this.getPrivateKey() != null) {
            s = s + "privateKey: " + this.getPrivateKey() + ", ";
        }
        if (this.getPublicationInfo() != null) {
            s = s + "publicationInfo: " + this.getPublicationInfo() + ", ";
        }
        s = s + ")";
        return s;
    }
}

