/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.renderer.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.tiles.TilesApplicationContext;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.awareness.TilesApplicationContextAware;
import org.apache.tiles.awareness.TilesContainerAware;
import org.apache.tiles.awareness.TilesRequestContextFactoryAware;
import org.apache.tiles.context.TilesRequestContextFactory;
import org.apache.tiles.evaluator.AttributeEvaluatorFactory;
import org.apache.tiles.evaluator.AttributeEvaluatorFactoryAware;
import org.apache.tiles.reflect.ClassUtil;
import org.apache.tiles.renderer.AttributeRenderer;
import org.apache.tiles.renderer.RendererException;
import org.apache.tiles.renderer.RendererFactory;
import org.apache.tiles.renderer.impl.DefinitionAttributeRenderer;
import org.apache.tiles.renderer.impl.StringAttributeRenderer;
import org.apache.tiles.renderer.impl.TemplateAttributeRenderer;
import org.apache.tiles.renderer.impl.UntypedAttributeRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicRendererFactory
implements RendererFactory,
TilesContainerAware,
TilesRequestContextFactoryAware,
TilesApplicationContextAware,
AttributeEvaluatorFactoryAware {
    public static final String TYPE_RENDERERS_INIT_PARAM = "org.apache.tiles.renderer.impl.BasicRendererFactory.TYPE_RENDERERS";
    public static final String DEFAULT_RENDERER_INIT_PARAM = "org.apache.tiles.rendere.impl.BasicRendererFactory.DEFAULT_RENDERER";
    public static final String DEFAULT_RENDERER_CLASS_NAME = UntypedAttributeRenderer.class.getName();
    protected static final Map<String, String> DEFAULT_TYPE_2_RENDERER = new HashMap<String, String>();
    protected TilesRequestContextFactory contextFactory;
    protected TilesApplicationContext applicationContext;
    protected TilesContainer container;
    protected AttributeEvaluatorFactory attributeEvaluatorFactory;
    protected Map<String, AttributeRenderer> renderers = new HashMap<String, AttributeRenderer>();
    protected AttributeRenderer defaultRenderer;

    @Override
    public void init(Map<String, String> parameters) {
        String defaultRendererParam = parameters.get(DEFAULT_RENDERER_INIT_PARAM);
        if (defaultRendererParam == null) {
            defaultRendererParam = DEFAULT_RENDERER_CLASS_NAME;
        }
        this.defaultRenderer = (AttributeRenderer)ClassUtil.instantiate((String)defaultRendererParam);
        this.initializeRenderer(this.defaultRenderer);
        String typeRenderersParam = parameters.get(TYPE_RENDERERS_INIT_PARAM);
        HashMap<String, String> completeParams = new HashMap<String, String>(DEFAULT_TYPE_2_RENDERER);
        if (typeRenderersParam != null) {
            String[] pairs = typeRenderersParam.split("\\s*;\\s*");
            for (int i = 0; i < pairs.length; ++i) {
                String[] pair = pairs[i].split("\\s*,\\s*");
                if (pair == null || pair.length != 2) {
                    throw new RendererException("The string '" + pairs[i] + "' is not a valid type-renderer pair");
                }
                completeParams.put(pair[0], pair[1]);
            }
        }
        for (Map.Entry entry : completeParams.entrySet()) {
            AttributeRenderer renderer = (AttributeRenderer)ClassUtil.instantiate((String)((String)entry.getValue()));
            this.initializeRenderer(renderer);
            this.renderers.put((String)entry.getKey(), renderer);
        }
    }

    @Override
    public AttributeRenderer getRenderer(String name) {
        AttributeRenderer retValue;
        if (name != null) {
            retValue = this.renderers.get(name);
            if (retValue == null) {
                retValue = (AttributeRenderer)ClassUtil.instantiate((String)name);
                this.initializeRenderer(retValue);
                this.renderers.put(name, retValue);
            }
        } else {
            retValue = this.defaultRenderer;
        }
        return retValue;
    }

    public void setDefaultRenderer(AttributeRenderer renderer) {
        this.defaultRenderer = renderer;
    }

    public void registerRenderer(String name, AttributeRenderer renderer) {
        this.renderers.put(name, renderer);
    }

    @Override
    public void setContainer(TilesContainer container) {
        this.container = container;
    }

    @Override
    public void setAttributeEvaluatorFactory(AttributeEvaluatorFactory attributeEvaluatorFactory) {
        this.attributeEvaluatorFactory = attributeEvaluatorFactory;
    }

    @Override
    public void setRequestContextFactory(TilesRequestContextFactory contextFactory) {
        this.contextFactory = contextFactory;
    }

    @Override
    public void setApplicationContext(TilesApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    protected void initializeRenderer(AttributeRenderer renderer) {
        if (renderer instanceof TilesRequestContextFactoryAware) {
            ((TilesRequestContextFactoryAware)((Object)renderer)).setRequestContextFactory(this.contextFactory);
        }
        if (renderer instanceof TilesApplicationContextAware) {
            ((TilesApplicationContextAware)((Object)renderer)).setApplicationContext(this.applicationContext);
        }
        if (renderer instanceof TilesContainerAware) {
            ((TilesContainerAware)((Object)renderer)).setContainer(this.container);
        }
        if (renderer instanceof AttributeEvaluatorFactoryAware) {
            ((AttributeEvaluatorFactoryAware)((Object)renderer)).setAttributeEvaluatorFactory(this.attributeEvaluatorFactory);
        }
    }

    static {
        DEFAULT_TYPE_2_RENDERER.put("string", StringAttributeRenderer.class.getName());
        DEFAULT_TYPE_2_RENDERER.put("definition", DefinitionAttributeRenderer.class.getName());
        DEFAULT_TYPE_2_RENDERER.put("template", TemplateAttributeRenderer.class.getName());
    }
}

