/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms.contact;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.glite.voms.contact.VOMSException;
import org.glite.voms.contact.VOMSResponse;
import org.xml.sax.SAXException;

public class VOMSParser {
    private static Logger log = Logger.getLogger(VOMSParser.class);
    protected DocumentBuilder docBuilder;

    private VOMSParser() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringComments(true);
        factory.setNamespaceAware(false);
        factory.setValidating(false);
        try {
            this.docBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            log.fatal((Object)"Error configuring DOM document builder.");
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
            throw new VOMSException(e.getMessage(), e);
        }
    }

    public VOMSResponse parseResponse(InputStream is) {
        try {
            return new VOMSResponse(this.docBuilder.parse(is));
        }
        catch (SAXException e) {
            log.error((Object)("Error parsing voms server response:" + e.getMessage()));
            if (log.isDebugEnabled()) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            throw new VOMSException(e);
        }
        catch (IOException e) {
            log.error((Object)("I/O error reading voms server response:" + e.getMessage()));
            if (log.isDebugEnabled()) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            throw new VOMSException(e);
        }
    }

    public static VOMSParser instance() {
        return new VOMSParser();
    }
}

