/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms.ac;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.IssuerSerial;
import org.glite.voms.ac.ObjectDigestInfo;
import org.glite.voms.ac.Util;

public class Holder
implements DEREncodable {
    IssuerSerial baseCertificateID = null;
    GeneralNames entityName = null;
    ObjectDigestInfo objectDigestInfo = null;

    public Holder(X509Certificate cert) {
        this(cert.getIssuerX500Principal(), cert.getSerialNumber());
    }

    public Holder(X500Principal issuer, BigInteger serial) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)Util.x500nameToGeneralNames(issuer));
        v.add((DEREncodable)new DERInteger(serial));
        this.baseCertificateID = new IssuerSerial((ASN1Sequence)new DERSequence((DEREncodableVector)v));
    }

    public Holder(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        block5: while (e.hasMoreElements()) {
            DERObject obj = (DERObject)e.nextElement();
            if (!(obj instanceof ASN1TaggedObject)) {
                throw new IllegalArgumentException("Holder element not tagged");
            }
            ASN1TaggedObject tObj = (ASN1TaggedObject)obj;
            switch (tObj.getTagNo()) {
                case 0: {
                    this.baseCertificateID = new IssuerSerial((ASN1Sequence)tObj.getObject());
                    continue block5;
                }
                case 1: {
                    this.entityName = GeneralNames.getInstance((ASN1TaggedObject)tObj, (boolean)false);
                    continue block5;
                }
                case 2: {
                    this.objectDigestInfo = new ObjectDigestInfo((ASN1Sequence)tObj.getObject());
                    continue block5;
                }
            }
            throw new IllegalArgumentException("Unknown tag number " + tObj.getTagNo());
        }
    }

    public GeneralNames getIssuer() {
        if (this.baseCertificateID != null) {
            return this.baseCertificateID.getIssuer();
        }
        if (this.entityName != null) {
            return this.entityName;
        }
        return null;
    }

    protected static boolean matchesDN(X500Principal subject, GeneralNames targets) {
        Enumeration e = ((ASN1Sequence)targets.getDERObject()).getObjects();
        while (e.hasMoreElements()) {
            GeneralName gn = GeneralName.getInstance(e.nextElement());
            if (gn.getTagNo() != 4) continue;
            try {
                ByteArrayOutputStream b = new ByteArrayOutputStream();
                new DEROutputStream((OutputStream)b).writeObject((Object)gn.getName());
                X500Principal principal = new X500Principal(b.toByteArray());
                if (!principal.equals(subject)) continue;
                return true;
            }
            catch (IOException i) {
            }
        }
        return false;
    }

    public boolean isHolder(X509Certificate cert) {
        if (this.baseCertificateID != null && this.baseCertificateID.getSerial().getValue().equals(cert.getSerialNumber())) {
            if (Holder.matchesDN(cert.getIssuerX500Principal(), this.baseCertificateID.getIssuer())) {
                return true;
            }
            if (Holder.matchesDN(cert.getSubjectX500Principal(), this.baseCertificateID.getIssuer())) {
                return true;
            }
        }
        return this.entityName != null && Holder.matchesDN(cert.getSubjectX500Principal(), this.entityName);
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (this.baseCertificateID != null) {
            v.add((DEREncodable)new DERTaggedObject(false, 0, (DEREncodable)this.baseCertificateID));
        }
        if (this.entityName != null) {
            v.add((DEREncodable)new DERTaggedObject(false, 1, (DEREncodable)this.entityName));
        }
        if (this.objectDigestInfo != null) {
            v.add((DEREncodable)new DERTaggedObject(false, 2, (DEREncodable)this.objectDigestInfo));
        }
        return new DERSequence((DEREncodableVector)v);
    }
}

