/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms.ac;

import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.glite.voms.ac.GenericAttribute;

public class AttributeHolder
implements DEREncodable {
    private List l;
    private GeneralNames grantor;

    public AttributeHolder() {
        this.l = null;
        this.grantor = null;
    }

    public AttributeHolder(ASN1Sequence seq) {
        this.l = new Vector();
        this.grantor = null;
        if (seq.size() != 2) {
            throw new IllegalArgumentException("Encoding error in AttributeHolder");
        }
        if (seq.getObjectAt(0) instanceof ASN1Sequence && seq.getObjectAt(1) instanceof ASN1Sequence) {
            this.grantor = GeneralNames.getInstance((Object)seq.getObjectAt(0));
            seq = (ASN1Sequence)seq.getObjectAt(1);
            Enumeration e = seq.getObjects();
            while (e.hasMoreElements()) {
                GenericAttribute att = new GenericAttribute((ASN1Sequence)e.nextElement());
                this.l.add(att);
            }
        } else {
            throw new IllegalArgumentException("Encoding error in AttributeHolder");
        }
    }

    public static AttributeHolder getInstance(ASN1Sequence seq) {
        return new AttributeHolder(seq);
    }

    public String getGrantor() {
        ASN1Sequence seq = ASN1Sequence.getInstance((Object)this.grantor.getDERObject());
        GeneralName name = GeneralName.getInstance((Object)seq.getObjectAt(0));
        return DERIA5String.getInstance((Object)name.getName()).getString();
    }

    public List getAttributes() {
        return this.l;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)this.grantor);
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        ListIterator li = this.l.listIterator();
        while (li.hasNext()) {
            GenericAttribute att = (GenericAttribute)li.next();
            v2.add((DEREncodable)att);
        }
        DERSequence seq = new DERSequence((DEREncodableVector)v2);
        v.add((DEREncodable)seq);
        return new DERSequence((DEREncodableVector)v);
    }
}

