/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.glite.voms.BasicVOMSTrustStore;
import org.glite.voms.CertUtil;
import org.glite.voms.FQAN;
import org.glite.voms.PKIStoreFactory;
import org.glite.voms.PKIVerifier;
import org.glite.voms.VOMSAttribute;
import org.glite.voms.ac.ACTrustStore;
import org.glite.voms.ac.ACValidator;
import org.glite.voms.ac.AttributeCertificate;
import org.glite.voms.ac.VOMSTrustStore;

public class VOMSValidator {
    static Logger log = Logger.getLogger(VOMSValidator.class);
    public static final String VOMS_EXT_OID = "1.3.6.1.4.1.8005.100.100.5";
    protected static ACTrustStore theTrustStore;
    protected ACValidator myValidator;
    protected X509Certificate[] myValidatedChain;
    protected Vector myVomsAttributes = new Vector();
    protected boolean isParsed = false;
    protected boolean isValidated = false;
    protected FQANTree myFQANTree = null;
    protected static VOMSTrustStore vomsStore;
    protected static volatile ACValidator DEFAULT_VALIDATOR;

    public VOMSValidator(X509Certificate validatedCert) {
        this(new X509Certificate[]{validatedCert});
    }

    public VOMSValidator(X509Certificate[] validatedChain) {
        this(validatedChain, null);
    }

    private synchronized ACValidator initializeValidator() {
        if (DEFAULT_VALIDATOR == null) {
            try {
                PKIVerifier verifier = new PKIVerifier();
                DEFAULT_VALIDATOR = new ACValidator(verifier);
            }
            catch (Exception e) {
                log.error((Object)("Error initializing default ACValidator: " + e.getMessage()), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return DEFAULT_VALIDATOR;
    }

    public VOMSValidator(X509Certificate[] validatedChain, ACValidator acValidator) {
        this.myValidatedChain = validatedChain == null ? null : (X509Certificate[])validatedChain.clone();
        this.myValidator = acValidator == null ? this.initializeValidator() : acValidator;
    }

    public static void setTrustStore(ACTrustStore trustStore) {
        if (trustStore instanceof BasicVOMSTrustStore) {
            BasicVOMSTrustStore store = (BasicVOMSTrustStore)trustStore;
            String directory = store.getDirList();
            try {
                VOMSValidator.setTrustStore(PKIStoreFactory.getStore(directory, 1, true));
                store.stopRefresh();
            }
            catch (Exception e) {
                log.error((Object)"Cannot set upgraded truststore!");
                theTrustStore = trustStore;
            }
        } else {
            log.error((Object)"Cannot set upgraded truststore!");
            theTrustStore = trustStore;
        }
    }

    public static synchronized void setTrustStore(VOMSTrustStore trustStore) {
        vomsStore = trustStore;
    }

    public synchronized void cleanup() {
        this.myValidatedChain = null;
        if (this.myVomsAttributes != null) {
            this.myVomsAttributes.clear();
            this.myVomsAttributes = null;
        }
        this.myFQANTree = null;
        if (this.myValidator != null && this.myValidator != DEFAULT_VALIDATOR) {
            this.myValidator.cleanup();
            this.myValidator = null;
        }
    }

    public static synchronized void shutdown() {
        if (DEFAULT_VALIDATOR != null) {
            DEFAULT_VALIDATOR.cleanup();
            DEFAULT_VALIDATOR = null;
        }
    }

    public VOMSValidator setClientChain(X509Certificate[] validatedChain) {
        this.myValidatedChain = validatedChain == null ? null : (X509Certificate[])validatedChain.clone();
        this.myVomsAttributes = new Vector();
        this.myFQANTree = null;
        this.isParsed = false;
        this.isValidated = false;
        return this;
    }

    public static Vector parse(X509Certificate[] myValidatedChain) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"VOMSValidator : parsing cert chain");
        }
        int aclen = -1;
        int clientIdx = CertUtil.findClientCert(myValidatedChain);
        if (clientIdx < 0) {
            log.error((Object)"VOMSValidator : no client cert found in cert chain");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Parsing VOMS attributes for subject " + myValidatedChain[clientIdx].getSubjectX500Principal().getName()));
        }
        Vector<VOMSAttribute> myVomsAttributes = new Vector<VOMSAttribute>();
        for (int i = 0; i < myValidatedChain.length; ++i) {
            byte[] payload = myValidatedChain[i].getExtensionValue(VOMS_EXT_OID);
            if (payload == null) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("No VOMS extension in certificate issued to " + myValidatedChain[i].getSubjectX500Principal().getName()));
                continue;
            }
            try {
                payload = ((DEROctetString)new ASN1InputStream((InputStream)new ByteArrayInputStream(payload)).readObject()).getOctets();
                ASN1Sequence seq1 = (ASN1Sequence)new ASN1InputStream((InputStream)new ByteArrayInputStream(payload)).readObject();
                Enumeration e1 = seq1.getObjects();
                while (e1.hasMoreElements()) {
                    ASN1Sequence seq2 = (ASN1Sequence)e1.nextElement();
                    Enumeration e2 = seq2.getObjects();
                    while (e2.hasMoreElements()) {
                        AttributeCertificate ac = new AttributeCertificate((ASN1Sequence)e2.nextElement());
                        ++aclen;
                        for (int j = clientIdx; j < myValidatedChain.length; ++j) {
                            if (ac.getHolder().isHolder(myValidatedChain[j])) {
                                VOMSAttribute va = new VOMSAttribute(ac);
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Found VOMS attribute from " + va.getHostPort() + " in certificate issued to " + myValidatedChain[j].getSubjectX500Principal().getName()));
                                }
                                myVomsAttributes.add(va);
                                continue;
                            }
                            log.debug((Object)"VOMS attribute cert found, but holder checking failed!");
                        }
                    }
                }
                break;
            }
            catch (Exception e) {
                log.info((Object)("Error parsing VOMS extension in certificate issued to " + myValidatedChain[i].getSubjectX500Principal().getName()), (Throwable)e);
                throw new IllegalArgumentException("Error parsing VOMS extension in certificate issued to " + myValidatedChain[i].getSubjectX500Principal().getName() + "error was:" + e.getMessage());
            }
        }
        return myVomsAttributes;
    }

    public VOMSValidator parse() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"VOMSValidator : parsing cert chain");
        }
        if (this.isParsed) {
            return this;
        }
        int clientIdx = CertUtil.findClientCert(this.myValidatedChain);
        if (clientIdx < 0) {
            log.error((Object)"VOMSValidator : no client cert found in cert chain");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Parsing VOMS attributes for subject " + this.myValidatedChain[clientIdx].getSubjectX500Principal().getName()));
        }
        this.myVomsAttributes.clear();
        for (int i = 0; i < this.myValidatedChain.length; ++i) {
            byte[] payload = this.myValidatedChain[i].getExtensionValue(VOMS_EXT_OID);
            if (payload == null) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("No VOMS extension in certificate issued to " + this.myValidatedChain[i].getSubjectX500Principal().getName()));
                continue;
            }
            try {
                payload = ((DEROctetString)new ASN1InputStream((InputStream)new ByteArrayInputStream(payload)).readObject()).getOctets();
                ASN1Sequence seq1 = (ASN1Sequence)new ASN1InputStream((InputStream)new ByteArrayInputStream(payload)).readObject();
                Enumeration e1 = seq1.getObjects();
                while (e1.hasMoreElements()) {
                    ASN1Sequence seq2 = (ASN1Sequence)e1.nextElement();
                    Enumeration e2 = seq2.getObjects();
                    while (e2.hasMoreElements()) {
                        AttributeCertificate ac = new AttributeCertificate((ASN1Sequence)e2.nextElement());
                        for (int j = clientIdx; j < this.myValidatedChain.length; ++j) {
                            if (ac.getHolder().isHolder(this.myValidatedChain[j])) {
                                VOMSAttribute va = new VOMSAttribute(ac);
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Found VOMS attribute from " + va.getHostPort() + " in certificate issued to " + this.myValidatedChain[j].getSubjectX500Principal().getName()));
                                }
                                this.myVomsAttributes.add(va);
                                continue;
                            }
                            log.debug((Object)"VOMS attribute cert found, but holder checking failed!");
                        }
                    }
                }
                break;
            }
            catch (Exception e) {
                log.info((Object)("Error parsing VOMS extension in certificate issued to " + this.myValidatedChain[i].getSubjectX500Principal().getName()), (Throwable)e);
                throw new IllegalArgumentException("Error parsing VOMS extension in certificate issued to " + this.myValidatedChain[i].getSubjectX500Principal().getName() + "error was:" + e.getMessage());
            }
        }
        this.isParsed = true;
        return this;
    }

    public VOMSValidator validate() {
        if (this.isValidated) {
            return this;
        }
        if (!this.isParsed) {
            this.parse();
            this.isParsed = true;
        }
        ListIterator i = this.myVomsAttributes.listIterator();
        while (i.hasNext()) {
            AttributeCertificate ac = ((VOMSAttribute)i.next()).privateGetAC();
            if (this.myValidator.validate(ac)) continue;
            i.remove();
        }
        this.isValidated = true;
        return this;
    }

    private void populate() {
        if (!this.isParsed && !this.isValidated) {
            throw new IllegalStateException("VOMSValidator: trying to populate FQAN tree before call to parse() or validate()");
        }
        this.myFQANTree = new FQANTree();
        ListIterator i = this.myVomsAttributes.listIterator();
        while (i.hasNext()) {
            this.myFQANTree.add(((VOMSAttribute)i.next()).getListOfFQAN());
        }
    }

    public String[] getAllFullyQualifiedAttributes() {
        ArrayList clientAttributes = new ArrayList();
        for (int i = 0; i < this.myVomsAttributes.size(); ++i) {
            List vomsAttributes = ((VOMSAttribute)this.myVomsAttributes.get(i)).getFullyQualifiedAttributes();
            clientAttributes.addAll(vomsAttributes);
        }
        return clientAttributes.toArray(new String[0]);
    }

    public List getVOMSAttributes() {
        return this.myVomsAttributes;
    }

    public List getRoles(String subGroup) {
        if (!this.isParsed && !this.isValidated) {
            throw new IllegalStateException("Must call parse() or validate() first");
        }
        if (this.myFQANTree == null) {
            this.populate();
        }
        return this.myFQANTree.getRoles(subGroup);
    }

    public List getCapabilities(String subGroup) {
        if (!this.isParsed && !this.isValidated) {
            throw new IllegalStateException("Must call parse() or validate() first");
        }
        if (this.myFQANTree == null) {
            this.populate();
        }
        return this.myFQANTree.getCapabilities(subGroup);
    }

    public boolean isValidated() {
        return this.isValidated;
    }

    public boolean isValid() {
        return true;
    }

    public String toString() {
        return "isParsed : " + this.isParsed + "\nhas been validated : " + this.isValidated + "\nVOMS attrs:" + this.myVomsAttributes;
    }

    static {
        vomsStore = null;
        DEFAULT_VALIDATOR = null;
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    public class FQANTree {
        Hashtable myTree = new Hashtable();
        Hashtable myResults = new Hashtable();

        public void add(List fqans) {
            if (fqans == null) {
                return;
            }
            Iterator i = fqans.iterator();
            while (i.hasNext()) {
                this.add((FQAN)i.next());
            }
        }

        public void add(FQAN fqan) {
            String group = fqan.getGroup();
            Vector<FQAN> v = (Vector<FQAN>)this.myTree.get(group);
            if (v == null) {
                v = new Vector<FQAN>();
                this.myTree.put(group, v);
            }
            if (!v.contains(fqan)) {
                v.add(fqan);
            }
        }

        protected RoleCaps traverse(String voGroup) {
            RoleCaps rc = (RoleCaps)this.myResults.get(voGroup);
            if (rc != null) {
                return rc;
            }
            rc = new RoleCaps();
            StringTokenizer tok = new StringTokenizer(voGroup, "/", true);
            StringBuilder sb = new StringBuilder();
            while (tok.hasMoreTokens()) {
                sb.append(tok.nextToken());
                rc.add((Vector)this.myTree.get(sb.toString()));
            }
            this.myResults.put(voGroup, rc);
            return rc;
        }

        public List getRoles(String voGroup) {
            return this.traverse(voGroup).getRoles();
        }

        public List getCapabilities(String voGroup) {
            return this.traverse(voGroup).getCapabilities();
        }
    }

    class RoleCaps {
        List roles;
        List caps;

        RoleCaps() {
        }

        void add(List v, String s) {
            if (s == null) {
                return;
            }
            if (!v.contains(s)) {
                v.add(s);
            }
        }

        public void add(Vector fqans) {
            if (fqans == null) {
                return;
            }
            if (this.roles == null) {
                this.roles = new Vector();
                this.caps = new Vector();
            }
            for (FQAN f : fqans) {
                this.add(this.roles, f.getRole());
                this.add(this.caps, f.getCapability());
            }
        }

        public List getRoles() {
            return this.roles;
        }

        public List getCapabilities() {
            return this.caps;
        }
    }
}

