/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.glite.voms.PKIUtils;

public class SigningPolicy {
    private static final int ACCESS_ID_CA = 1;
    private static final int POS_RIGHTS = 2;
    private static final int COND_SUBJECTS = 3;
    private static final Pattern access_id_ca_pattern = Pattern.compile("access_id_CA\\s+x509\\s+(.*)", 2);
    private static final Pattern pos_rights_pattern = Pattern.compile("pos_rights\\s+globus\\s+(.*)", 2);
    private static final Pattern cond_subjects_pattern = Pattern.compile("cond_subjects\\s+globus\\s+(['\"])(.*?)\\1\\s*", 2);
    private static final Pattern remove_single_quotes = Pattern.compile("'(.*)'");
    private static final Pattern remove_double_quotes = Pattern.compile("\"(.*)\"");
    private static final Pattern get_subject_pattern = Pattern.compile("(['\"]?)(.*?)\\1\\s*?");
    private String gname = null;
    private Vector access_id_ca_list = new Vector();
    private Vector pos_rights_list = new Vector();
    private Vector subjects_list = new Vector();
    private int current = -1;
    private int mode = 1;
    private static Logger logger = Logger.getLogger((String)SigningPolicy.class.getName());

    public SigningPolicy(File f) throws IOException {
        this.parse(f);
    }

    public String getName() {
        return this.gname;
    }

    public int findIssuer(String issuer) {
        return this.findIssuer(issuer, -1);
    }

    public int findIssuer(String issuer, int previous) {
        if (previous < -1) {
            return -1;
        }
        return this.access_id_ca_list.indexOf(issuer, previous + 1);
    }

    public void setCurrent(int index) {
        if (index > this.access_id_ca_list.size() || index < 0) {
            throw new IllegalArgumentException("Index out of bounds for SigningPolicy " + this.gname);
        }
        this.current = index;
    }

    public String getAccessIDCA() {
        if (this.current != -1) {
            return (String)this.access_id_ca_list.elementAt(this.current);
        }
        throw new IllegalArgumentException("Current record must be set in Signing Policy object " + this.gname);
    }

    public String getPosRights() {
        if (this.current != -1) {
            return (String)this.pos_rights_list.elementAt(this.current);
        }
        throw new IllegalArgumentException("Current record must be set in Signing Policy object " + this.gname);
    }

    public Vector getCondSubjects() {
        if (this.current != -1) {
            return (Vector)this.subjects_list.elementAt(this.current);
        }
        throw new IllegalArgumentException("Current record must be set in Signing Policy object " + this.gname);
    }

    private String parseAccessIDCA(String line) {
        String access_id_ca = null;
        Matcher m = access_id_ca_pattern.matcher(line);
        if (m.matches()) {
            String match = m.group(1);
            Matcher m2 = null;
            switch (match.charAt(0)) {
                case '\'': {
                    m2 = remove_single_quotes.matcher(match);
                    if (!m2.matches()) break;
                    access_id_ca = m2.group(1);
                    break;
                }
                case '\"': {
                    m2 = remove_double_quotes.matcher(match);
                    if (!m2.matches()) break;
                    access_id_ca = m2.group(1);
                    break;
                }
                default: {
                    access_id_ca = match;
                }
            }
        }
        logger.debug((Object)("Access_id_CA=" + PKIUtils.Normalize(access_id_ca)));
        return PKIUtils.Normalize(access_id_ca);
    }

    private String parsePosRights(String line) {
        String pos_rights = null;
        Matcher m = pos_rights_pattern.matcher(line);
        if (m.matches()) {
            pos_rights = m.group(1);
        }
        return pos_rights;
    }

    private Vector parseCondSubjects(String line) {
        Matcher subjects = cond_subjects_pattern.matcher(line);
        Vector<String> subjectList = new Vector<String>();
        while (subjects.find()) {
            String substring = subjects.group(2);
            Matcher subject_it = get_subject_pattern.matcher(substring);
            while (subject_it.find()) {
                String subject = subject_it.group(2);
                if (subject.length() == 0) continue;
                subjectList.add(subject);
            }
            if (substring.length() == 0 || subjectList.size() != 0) continue;
            subjectList.add(substring);
        }
        return subjectList;
    }

    private SigningPolicy parse(File theFile) throws IOException {
        BufferedReader theBuffer = new BufferedReader(new FileReader(theFile));
        String s = null;
        boolean firstrun = true;
        this.gname = PKIUtils.getBaseName(theFile);
        String access_id_ca = null;
        String pos_rights = null;
        Vector subjects = null;
        boolean error = false;
        s = theBuffer.readLine();
        while (s != null) {
            if ((s = s.trim()).length() != 0 && s.charAt(0) != '#') {
                switch (this.mode) {
                    case 1: {
                        if (!firstrun) {
                            if (access_id_ca != null && pos_rights != null && subjects != null) {
                                this.access_id_ca_list.add(access_id_ca);
                                this.pos_rights_list.add(pos_rights);
                                this.subjects_list.add(subjects);
                            }
                            access_id_ca = null;
                            pos_rights = null;
                            subjects = null;
                        }
                        if ((access_id_ca = this.parseAccessIDCA(s)) == null) {
                            error = true;
                        }
                        this.mode = 2;
                        break;
                    }
                    case 2: {
                        pos_rights = this.parsePosRights(s);
                        if (pos_rights == null) {
                            error = true;
                        }
                        this.mode = 3;
                        break;
                    }
                    case 3: {
                        subjects = this.parseCondSubjects(s);
                        if (subjects.size() == 0) {
                            error = true;
                        }
                        this.mode = 1;
                        firstrun = false;
                    }
                }
                if (error) break;
            }
            s = theBuffer.readLine();
        }
        if (access_id_ca != null && pos_rights != null && subjects != null && !error) {
            this.access_id_ca_list.add(access_id_ca);
            this.pos_rights_list.add(pos_rights);
            this.subjects_list.add(subjects);
        }
        theBuffer.close();
        if (error) {
            throw new IOException("Error in reading format of file: " + theFile.getName());
        }
        return this;
    }
}

