/*
 * Decompiled with CFR 0.152.
 */
package org.glite.voms;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.glite.voms.FileEndingIterator;

class DirectoryList {
    static Logger logger = Logger.getLogger((String)DirectoryList.class.getName());
    List files = null;

    public DirectoryList(String path) throws IOException {
        String[] parts = path.split("\\*");
        if (parts.length < 1 || parts.length > 2) {
            return;
        }
        if (parts.length == 1) {
            File fileOrDir = new File(parts[0]);
            if (fileOrDir.isFile()) {
                this.files = new Vector();
                this.files.add(fileOrDir);
                return;
            }
            File[] fileDirArray = fileOrDir.listFiles();
            if (fileDirArray == null) {
                logger.error((Object)("No files found matching " + path));
                throw new IOException("No files found matching " + path);
            }
            Iterator<File> filesAndDirs = Arrays.asList(fileDirArray).iterator();
            this.files = new Vector();
            while (filesAndDirs.hasNext()) {
                File nextFile = filesAndDirs.next();
                if (!nextFile.isFile()) continue;
                this.files.add(nextFile);
            }
            return;
        }
        this.files = new Vector();
        FileEndingIterator iterator = new FileEndingIterator(parts[0], parts[1]);
        while (iterator.hasNext()) {
            this.files.add(iterator.next());
        }
    }

    public List getListing() {
        return this.files;
    }
}

