/*
 * Decompiled with CFR 0.152.
 */
package org.glite.pseudo.common.util;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.commons.lang.SystemUtils;

public class Util {
    public static boolean setFilePermissions(File file, int mode) {
        String filename = file.getPath();
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (!SystemUtils.IS_OS_WINDOWS) {
            Runtime runtime = Runtime.getRuntime();
            String[] cmd = new String[]{"chmod", String.valueOf(mode), filename};
            try {
                Process process = runtime.exec(cmd);
                return process.waitFor() == 0;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public static String convertUTF8ToUnicode(String utf8) throws UnsupportedEncodingException {
        if (utf8 == null) {
            return null;
        }
        String unicode = null;
        byte[] latin1 = utf8.getBytes("ISO-8859-1");
        unicode = new String(latin1, "UTF-8");
        return unicode;
    }

    public static String safeTrimOrNullString(String s) {
        String sTrimmed;
        if (s != null && (sTrimmed = s.trim()).length() > 0) {
            return sTrimmed;
        }
        return null;
    }

    public static boolean matchCharArrays(char[] first, char[] second) {
        if (first == null || second == null || first.length != second.length) {
            return false;
        }
        for (int i = 0; i < first.length; ++i) {
            if (first[i] == second[i]) continue;
            return false;
        }
        return true;
    }
}

