/*
 * Decompiled with CFR 0.152.
 */
package org.glite.pseudo.common.pki.bouncycastle;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.x509.X509DefaultEntryConverter;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class X509PrincipalUtil {
    private final Logger log = LoggerFactory.getLogger(X509PrincipalUtil.class);
    private Boolean start_ = false;

    public X509Principal createX509Principal(String name) throws GeneralSecurityException {
        Vector<DERObjectIdentifier> oids = new Vector<DERObjectIdentifier>();
        Vector<Object> values = new Vector<Object>();
        Vector<Boolean> added = new Vector<Boolean>();
        this.start_ = false;
        try {
            LdapName ldapName = new LdapName(name);
            this.log.debug("RDNs: {}", ldapName.getRdns());
            Rdn[] rdnArray = new Rdn[ldapName.getRdns().size()];
            ldapName.getRdns().toArray(rdnArray);
            for (int i = rdnArray.length - 1; i >= 0; --i) {
                this.readRdn(rdnArray[i], oids, values, added);
                this.start_ = false;
            }
            X509Principal principal = this.buildX509Principal(oids, values, added);
            return principal;
        }
        catch (Exception e) {
            this.log.error("Fail to create X509Principal(" + name + ")", (Throwable)e);
            throw new GeneralSecurityException("Fail to create X509Principal(" + name + "): " + e.getMessage(), e);
        }
    }

    private void readRdn(Rdn rdn, Vector<DERObjectIdentifier> oids, Vector<Object> values, Vector<Boolean> added) throws NamingException {
        this.log.debug("RDN: {}", (Object)rdn);
        NamingEnumeration<? extends Attribute> attrs = rdn.toAttributes().getAll();
        do {
            if (!attrs.hasMoreElements()) continue;
            Attribute attr = (Attribute)attrs.nextElement();
            this.readAttr(attr, oids, values, added);
            this.start_ = true;
        } while (attrs.hasMoreElements());
    }

    private void readAttr(Attribute attr, Vector<DERObjectIdentifier> oids, Vector<Object> values, Vector<Boolean> added) throws NamingException {
        this.log.debug("Attribute: {}", (Object)attr);
        for (int i = 0; i < attr.size(); ++i) {
            if (attr.get(i) instanceof Attribute) {
                Attribute rdnAttr = (Attribute)attr.get(i);
                this.log.debug("Attribute RDN: {}", (Object)rdnAttr);
                this.readAttr(rdnAttr, oids, values, added);
                continue;
            }
            DERObjectIdentifier oid = (DERObjectIdentifier)X509Name.DefaultLookUp.get(Strings.toLowerCase((String)attr.getID()));
            oids.add(oid);
            Object attrValue = attr.get(i);
            this.log.debug("Attribute value: {}", attrValue);
            values.add(attrValue);
            added.add(this.start_);
            this.start_ = true;
        }
    }

    private X509Principal buildX509Principal(Vector<DERObjectIdentifier> ordering, Vector<Object> values, Vector<Boolean> added) throws IOException {
        X509DefaultEntryConverter converter = new X509DefaultEntryConverter();
        ASN1EncodableVector vec = new ASN1EncodableVector();
        ASN1EncodableVector sVec = new ASN1EncodableVector();
        DERObjectIdentifier lstOid = null;
        for (int i = 0; i != ordering.size(); ++i) {
            ASN1EncodableVector v = new ASN1EncodableVector();
            DERObjectIdentifier oid = ordering.elementAt(i);
            v.add((DEREncodable)oid);
            String str = (String)values.elementAt(i);
            v.add((DEREncodable)converter.getConvertedValue(oid, str));
            if (lstOid == null || added.elementAt(i).booleanValue()) {
                sVec.add((DEREncodable)new DERSequence(v));
            } else {
                vec.add((DEREncodable)new DERSet(sVec));
                sVec = new ASN1EncodableVector();
                sVec.add((DEREncodable)new DERSequence(v));
            }
            lstOid = oid;
        }
        vec.add((DEREncodable)new DERSet(sVec));
        DERSequence seq = new DERSequence(vec);
        byte[] bytes = seq.getDEREncoded();
        return new X509Principal(bytes);
    }
}

