/*
 * Decompiled with CFR 0.152.
 */
package org.glite.pseudo.common.pki.bouncycastle;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.Attribute;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMReader;
import org.bouncycastle.openssl.PEMWriter;
import org.glite.pseudo.common.pki.bouncycastle.X509PrincipalUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKCS10 {
    private final Logger log = LoggerFactory.getLogger(PKCS10.class);
    public static String SIGNATURE_ALGORITHM;
    private PKCS10CertificationRequest bcPKCS10_ = null;

    public PKCS10(String subject, PublicKey publicKey, PrivateKey privateKey) throws GeneralSecurityException {
        this(subject, publicKey, privateKey, null);
    }

    public PKCS10(String subject, PublicKey publicKey, PrivateKey privateKey, X509Extensions x509Extensions) throws GeneralSecurityException {
        X509PrincipalUtil util = new X509PrincipalUtil();
        X509Principal principal = util.createX509Principal(subject);
        this.log.debug("X509Principal: {}", (Object)principal.toString());
        DERSet attributes = new DERSet();
        if (x509Extensions != null) {
            DERSet extensions = new DERSet((DEREncodable)x509Extensions);
            Attribute attribute = new Attribute((DERObjectIdentifier)PKCSObjectIdentifiers.pkcs_9_at_extensionRequest, (ASN1Set)extensions);
            attributes = new DERSet((DEREncodable)attribute);
        }
        this.bcPKCS10_ = new PKCS10CertificationRequest(SIGNATURE_ALGORITHM, (X509Name)principal, publicKey, (ASN1Set)attributes, privateKey);
        if (!this.bcPKCS10_.verify()) {
            this.log.error("Failed to verify the PKCS#10");
            throw new GeneralSecurityException("PKCS#10 verification failed");
        }
    }

    private PKCS10(PKCS10CertificationRequest pkcs10) throws GeneralSecurityException {
        this.bcPKCS10_ = pkcs10;
        if (!this.bcPKCS10_.verify()) {
            this.log.error("Failed to verify the PKCS#10");
            throw new GeneralSecurityException("PKCS#10 verification failed");
        }
    }

    public byte[] getDEREncoded() {
        return this.bcPKCS10_.getEncoded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPEMEncoded() {
        StringWriter sw = new StringWriter();
        PEMWriter pem = new PEMWriter((Writer)sw);
        try {
            pem.writeObject((Object)this.bcPKCS10_);
        }
        catch (IOException e) {
            this.log.warn("Failed to write PKCS10 in PEM format", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            try {
                pem.close();
                sw.close();
            }
            catch (IOException e) {}
        }
        return sw.toString();
    }

    public void storePEMEncoded(File file) throws IOException {
        FileWriter fw = new FileWriter(file);
        PEMWriter pem = new PEMWriter((Writer)fw);
        pem.writeObject((Object)this.bcPKCS10_);
        try {
            pem.close();
            fw.close();
        }
        catch (IOException e) {
            this.log.warn("Exception while closing the file", (Throwable)e);
        }
    }

    public void storeDEREncoded(File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        byte[] derBytes = this.bcPKCS10_.getEncoded();
        fos.write(derBytes);
        try {
            fos.close();
        }
        catch (IOException e) {
            this.log.warn("Exception while closing the file", (Throwable)e);
        }
    }

    public static PKCS10 readPEMEncoded(Reader reader) throws IOException, GeneralSecurityException {
        PEMReader pem = new PEMReader(reader);
        PKCS10CertificationRequest pkcs10csr = (PKCS10CertificationRequest)pem.readObject();
        try {
            pem.close();
        }
        catch (IOException e) {
            throw new IOException(e.getMessage());
        }
        PKCS10 pkcs10 = new PKCS10(pkcs10csr);
        return pkcs10;
    }

    public String getSubject() {
        Principal principal = this.getPrincipal();
        return principal.getName();
    }

    public Principal getPrincipal() {
        X509Name subject = this.bcPKCS10_.getCertificationRequestInfo().getSubject();
        X509Principal principal = new X509Principal(subject);
        return principal;
    }

    public X509Extensions getX509Extensions() {
        ASN1Set attributeValues;
        ASN1Sequence attributeSequence;
        Attribute attribute;
        ASN1ObjectIdentifier oid;
        X509Extensions x509Extensions = null;
        ASN1Set attributes = this.bcPKCS10_.getCertificationRequestInfo().getAttributes();
        if (attributes.size() > 0 && (oid = (attribute = new Attribute(attributeSequence = (ASN1Sequence)attributes.getObjectAt(0))).getAttrType()).equals((Object)PKCSObjectIdentifiers.pkcs_9_at_extensionRequest) && (attributeValues = attribute.getAttrValues()).size() > 0) {
            ASN1Sequence x509extensionsSequence = (ASN1Sequence)attributeValues.getObjectAt(0);
            x509Extensions = new X509Extensions(x509extensionsSequence);
        }
        return x509Extensions;
    }

    static {
        if (Security.getProvider(BouncyCastleProvider.PROVIDER_NAME) == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        SIGNATURE_ALGORITHM = "SHA1WithRSA";
    }
}

