/*
 * Decompiled with CFR 0.152.
 */
package org.glite.pseudo.common.pki.bouncycastle;

import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyPairGenerator {
    private final Logger log = LoggerFactory.getLogger(KeyPairGenerator.class);
    private java.security.KeyPairGenerator generator_ = null;

    public KeyPairGenerator(String algorithm) throws GeneralSecurityException {
        this.generator_ = java.security.KeyPairGenerator.getInstance(algorithm, BouncyCastleProvider.PROVIDER_NAME);
    }

    public void initialize(int keysize) {
        this.log.debug("Initializing a keypair with keysize={}", (Object)keysize);
        this.generator_.initialize(keysize);
    }

    public KeyPair generateKeyPair() {
        this.log.debug("Generating a new keypair");
        return this.generator_.generateKeyPair();
    }

    static {
        if (Security.getProvider(BouncyCastleProvider.PROVIDER_NAME) == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

