/*
 * Decompiled with CFR 0.152.
 */
package org.glite.pseudo.common.pki.bouncycastle;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Vector;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.jce.PrincipalUtil;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.interfaces.PKCS12BagAttributeCarrier;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMReader;
import org.bouncycastle.openssl.PEMWriter;
import org.bouncycastle.x509.extension.SubjectKeyIdentifierStructure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Codec {
    private static Logger log = LoggerFactory.getLogger(Codec.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPEMEncoded(Key key) {
        StringWriter sw = new StringWriter();
        PEMWriter pem = new PEMWriter((Writer)sw);
        try {
            pem.writeObject((Object)key);
        }
        catch (IOException e) {
            log.warn("Failed to write PEM key", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            try {
                pem.close();
            }
            catch (IOException e) {
                log.warn("Catched exception while closing a writer", (Throwable)e);
            }
        }
        return sw.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPEMEncoded(Key key, char[] password) {
        StringWriter sw = new StringWriter();
        PEMWriter pem = new PEMWriter((Writer)sw);
        try {
            String algorithm = "DESEDE";
            SecureRandom random = new SecureRandom();
            pem.writeObject((Object)key, algorithm, password, random);
        }
        catch (IOException e) {
            log.warn("Failed to write encoded PEM key", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            try {
                pem.close();
            }
            catch (IOException e) {
                log.warn("Catched exception while closing a writer", (Throwable)e);
            }
        }
        return sw.toString();
    }

    public static void storePEMEncoded(Key key, File file) throws IOException {
        FileWriter fw = new FileWriter(file);
        PEMWriter pem = new PEMWriter((Writer)fw);
        pem.writeObject((Object)key);
        try {
            pem.close();
            fw.close();
        }
        catch (IOException e) {
            log.warn("Catched exception while closing a file", (Throwable)e);
        }
    }

    public static void storePEMEncoded(Key key, char[] password, File file) throws IOException {
        FileWriter fw = new FileWriter(file);
        PEMWriter pem = new PEMWriter((Writer)fw);
        String algorithm = "DESEDE";
        SecureRandom random = new SecureRandom();
        pem.writeObject((Object)key, algorithm, password, random);
        try {
            pem.close();
            fw.close();
        }
        catch (IOException e) {
            log.warn("Catched exception while closing a file", (Throwable)e);
        }
    }

    public static void storePEMEncoded(X509Certificate cert, File file) throws IOException {
        FileWriter fw = new FileWriter(file);
        PEMWriter pem = new PEMWriter((Writer)fw);
        pem.writeObject((Object)cert);
        try {
            pem.close();
            fw.close();
        }
        catch (IOException e) {
            log.warn("Catched exception while closing a file", (Throwable)e);
        }
    }

    public static void storePEMEncoded(X509Certificate cert, X509Certificate[] chain, File file) throws IOException {
        FileWriter fw = new FileWriter(file);
        PEMWriter pem = new PEMWriter((Writer)fw);
        pem.writeObject((Object)cert);
        if (chain != null) {
            for (int i = 0; i < chain.length; ++i) {
                pem.writeObject((Object)chain[i]);
            }
        }
        try {
            pem.close();
            fw.close();
        }
        catch (IOException e) {
            log.warn("Catched exception while closing a file", (Throwable)e);
        }
    }

    public static String getPEMEncoded(X509Certificate cert) throws IOException {
        StringWriter sw = new StringWriter();
        PEMWriter pem = new PEMWriter((Writer)sw);
        try {
            pem.writeObject((Object)cert);
        }
        catch (IOException e) {
            throw new IOException("Failed to write PKCS7 in PEM format");
        }
        finally {
            try {
                pem.close();
                sw.close();
            }
            catch (IOException e) {
                throw new IOException("Catched an exception while closing a writer");
            }
        }
        return sw.toString();
    }

    public static X509Certificate[] readPEMEncodedCertificates(Reader reader) throws IOException {
        Vector<X509Certificate> certificates = new Vector<X509Certificate>();
        log.debug("read all certificates");
        PEMReader pr = new PEMReader(reader);
        boolean haveNext = true;
        while (haveNext) {
            X509Certificate certificate = (X509Certificate)pr.readObject();
            if (certificate == null) {
                haveNext = false;
                continue;
            }
            certificates.add(certificate);
        }
        int length = certificates.size();
        log.debug(length + " certificates found");
        X509Certificate[] certificatesArray = certificates.toArray(new X509Certificate[length]);
        return certificatesArray;
    }

    public static void storePKCS12(PrivateKey privateKey, X509Certificate certificate, X509Certificate[] chain, File file, char[] password) throws GeneralSecurityException, IOException {
        PKCS12BagAttributeCarrier bagAttr = (PKCS12BagAttributeCarrier)privateKey;
        PublicKey publicKey = certificate.getPublicKey();
        bagAttr.setBagAttribute((DERObjectIdentifier)PKCSObjectIdentifiers.pkcs_9_at_localKeyId, (DEREncodable)new SubjectKeyIdentifierStructure(publicKey));
        String alias = Codec.getPrincipalValue(certificate, X509Principal.CN);
        int nCerts = chain.length + 1;
        Certificate[] certs = new Certificate[nCerts];
        certs[0] = certificate;
        for (int i = 0; i < chain.length; ++i) {
            certs[i + 1] = chain[i];
        }
        KeyStore p12Store = KeyStore.getInstance("PKCS12", BouncyCastleProvider.PROVIDER_NAME);
        p12Store.load(null, null);
        p12Store.setKeyEntry(alias, privateKey, null, certs);
        FileOutputStream fos = new FileOutputStream(file);
        p12Store.store(fos, password);
        fos.close();
    }

    public static String getPrincipalValue(X509Certificate certificate, DERObjectIdentifier oid) throws GeneralSecurityException {
        X509Principal subject = PrincipalUtil.getSubjectX509Principal((X509Certificate)certificate);
        Vector oids = subject.getOIDs();
        int valueIndex = oids.indexOf(oid);
        if (valueIndex < 0) {
            return null;
        }
        Vector values = subject.getValues();
        String value = values.get(valueIndex).toString();
        return value;
    }

    private Codec() {
    }

    static {
        if (Security.getProvider(BouncyCastleProvider.PROVIDER_NAME) == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

