/*
 * Decompiled with CFR 0.152.
 */
package org.glite.pseudo.common.pki;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.glite.pseudo.common.pki.CertificateExtension;
import org.glite.pseudo.common.pki.CertificateKeys;
import org.glite.pseudo.common.pki.bouncycastle.PKCS10;
import org.glite.pseudo.common.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertificateRequest {
    private final Logger log = LoggerFactory.getLogger(CertificateRequest.class);
    private static final int CSR_FILE_PERMISSION = 640;
    private PKCS10 pkcs10_ = null;

    public CertificateRequest(CertificateKeys keys, Principal principal) throws GeneralSecurityException {
        this(keys, principal.getName());
    }

    public CertificateRequest(CertificateKeys keys, String subject) throws GeneralSecurityException {
        this(keys, subject, null);
    }

    public CertificateRequest(CertificateKeys keys, String subject, List<CertificateExtension> certificateExtensions) throws GeneralSecurityException {
        X509Extensions x509extensions = null;
        if (certificateExtensions != null && !certificateExtensions.isEmpty()) {
            Hashtable<DERObjectIdentifier, X509Extension> extensionsMap = new Hashtable<DERObjectIdentifier, X509Extension>();
            for (CertificateExtension extension : certificateExtensions) {
                extensionsMap.put(extension.getOID(), extension.getExtension());
            }
            x509extensions = new X509Extensions(extensionsMap);
        }
        this.pkcs10_ = new PKCS10(subject, keys.getPublic(), keys.getPrivate(), x509extensions);
    }

    public CertificateRequest(PKCS10 pkcs10) {
        this.pkcs10_ = pkcs10;
    }

    public List<CertificateExtension> getCertificateExtensions() {
        ArrayList<CertificateExtension> certificateExtensions = new ArrayList<CertificateExtension>();
        X509Extensions x509Extensions = this.pkcs10_.getX509Extensions();
        if (x509Extensions != null) {
            Enumeration oids = x509Extensions.oids();
            while (oids.hasMoreElements()) {
                DERObjectIdentifier oid = (DERObjectIdentifier)oids.nextElement();
                X509Extension x509Extension = x509Extensions.getExtension(oid);
                boolean critical = x509Extension.isCritical();
                CertificateExtension extension = new CertificateExtension(oid, x509Extension, critical);
                certificateExtensions.add(extension);
            }
        }
        return certificateExtensions;
    }

    public Principal getPrincipal() {
        return this.pkcs10_.getPrincipal();
    }

    public String getPEMEncoded() {
        return this.pkcs10_.getPEMEncoded();
    }

    public byte[] getDEREncoded() {
        return this.pkcs10_.getDEREncoded();
    }

    public void storePEM(String filename) throws IOException {
        File file = new File(filename);
        this.storePEM(file);
    }

    public void storePEM(File file) throws IOException {
        boolean permOk = Util.setFilePermissions(file, 640);
        if (!permOk) {
            this.log.warn("Failed to set permission: 640 for file: " + file);
        }
        this.pkcs10_.storePEMEncoded(file);
    }

    public static CertificateRequest loadPEM(File file) throws IOException, GeneralSecurityException {
        FileReader reader = new FileReader(file);
        CertificateRequest csr = CertificateRequest.readPEM(reader);
        try {
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return csr;
    }

    public static CertificateRequest readPEM(Reader reader) throws IOException, GeneralSecurityException {
        PKCS10 pkcs10 = PKCS10.readPEMEncoded(reader);
        CertificateRequest csr = new CertificateRequest(pkcs10);
        return csr;
    }
}

