/*
 * Decompiled with CFR 0.152.
 */
package org.glite.pseudo.common.pki;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.glite.pseudo.common.pki.bouncycastle.Codec;
import org.glite.pseudo.common.pki.bouncycastle.KeyPairGenerator;
import org.glite.pseudo.common.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateKeys {
    private final Logger log = LoggerFactory.getLogger(CertificateKeys.class);
    private static final String KEY_ALGORITHM = "RSA";
    private static final int KEY_SIZE = 1024;
    private static final int KEY_FILE_PERMISSION = 600;
    private KeyPair keyPair_ = null;
    private char[] password_ = null;

    public CertificateKeys(int keySize, char[] password) throws GeneralSecurityException {
        try {
            KeyPairGenerator generator = new KeyPairGenerator(KEY_ALGORITHM);
            generator.initialize(keySize);
            this.keyPair_ = generator.generateKeyPair();
            this.password_ = password;
        }
        catch (NoSuchAlgorithmException e) {
            this.log.error("Failed to create keys", (Throwable)e);
            throw e;
        }
    }

    public CertificateKeys(char[] password) throws GeneralSecurityException {
        this(1024, password);
    }

    public CertificateKeys(int keySize) throws GeneralSecurityException {
        this(keySize, null);
    }

    public CertificateKeys() throws GeneralSecurityException {
        this(1024, null);
    }

    public PrivateKey getPrivate() {
        if (this.keyPair_ == null) {
            return null;
        }
        return this.keyPair_.getPrivate();
    }

    public PublicKey getPublic() {
        if (this.keyPair_ == null) {
            return null;
        }
        return this.keyPair_.getPublic();
    }

    public void setPassword(String password) {
        this.password_ = password.toCharArray();
    }

    public void setPassword(char[] password) {
        this.password_ = password;
    }

    public void storePEMPrivate(String filename) throws IOException {
        File file = new File(filename);
        this.storePEMPrivate(file);
    }

    public void storePEMPrivate(File file) throws IOException {
        boolean permOk = Util.setFilePermissions(file, 600);
        if (!permOk) {
            this.log.warn("Failed to set permissions: 600 for file: " + file);
        }
        if (this.password_ != null) {
            Codec.storePEMEncoded(this.getPrivate(), this.password_, file);
        } else {
            Codec.storePEMEncoded(this.getPrivate(), file);
        }
    }

    public String getPEMPrivate() throws IOException {
        if (this.password_ != null) {
            return Codec.getPEMEncoded(this.getPrivate(), this.password_);
        }
        return Codec.getPEMEncoded(this.getPrivate());
    }

    public char[] getPassword() {
        return this.password_;
    }
}

