/*
 * Decompiled with CFR 0.152.
 */
package org.glite.pseudo.common.pki;

import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.X509Extension;
import org.glite.pseudo.common.pki.CertificateExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertificateExtensionFactory {
    private static final Logger log = LoggerFactory.getLogger(CertificateExtensionFactory.class);

    public static CertificateExtension createCertificateExtension(String id, String values) {
        log.debug("Creating a new non-critical CertificateExtension id={}, values={}", (Object)id, (Object)values);
        return CertificateExtensionFactory.createCertificateExtension(id, values, false);
    }

    public static CertificateExtension createCertificateExtension(String id, String values, boolean critical) {
        log.debug("Creating a new CertificateExtension id={}, values={}", (Object)id, (Object)values);
        if (log.isDebugEnabled()) {
            log.debug("id:" + id + " value(s):" + values);
        }
        if (id.equals(X509Extension.keyUsage.getId()) || id.equalsIgnoreCase("KeyUsage")) {
            int usage = 0;
            StringTokenizer st = new StringTokenizer(values, ",");
            while (st.hasMoreElements()) {
                String keyUsage = (String)st.nextElement();
                if ((keyUsage = keyUsage.trim()).equalsIgnoreCase("DigitalSignature")) {
                    usage += 128;
                    continue;
                }
                if (keyUsage.equalsIgnoreCase("NonRepudiation")) {
                    usage += 64;
                    continue;
                }
                if (keyUsage.equalsIgnoreCase("KeyEncipherment")) {
                    usage += 32;
                    continue;
                }
                if (keyUsage.equalsIgnoreCase("DataEncipherment")) {
                    usage += 16;
                    continue;
                }
                if (keyUsage.equalsIgnoreCase("KeyAgreement")) {
                    usage += 8;
                    continue;
                }
                if (keyUsage.equalsIgnoreCase("KeyCertSign")) {
                    usage += 4;
                    continue;
                }
                if (keyUsage.equalsIgnoreCase("CRLSign")) {
                    usage += 2;
                    continue;
                }
                if (keyUsage.equalsIgnoreCase("EncipherOnly")) {
                    ++usage;
                    continue;
                }
                if (keyUsage.equalsIgnoreCase("DecipherOnly")) {
                    usage += 32768;
                    continue;
                }
                log.error("Unknown KeyUsage: " + keyUsage);
            }
            return CertificateExtensionFactory.createKeyUsageExtension(usage, values, critical);
        }
        if (id.equals(X509Extension.extendedKeyUsage.getId()) || id.equalsIgnoreCase("ExtendedKeyUsage")) {
            Vector<KeyPurposeId> keyPurposeIds = new Vector<KeyPurposeId>();
            StringTokenizer st = new StringTokenizer(values, ",");
            while (st.hasMoreElements()) {
                String keyPurpose = (String)st.nextElement();
                if ((keyPurpose = keyPurpose.trim()).equalsIgnoreCase("AnyExtendedKeyUsage")) {
                    keyPurposeIds.add(KeyPurposeId.anyExtendedKeyUsage);
                    continue;
                }
                if (keyPurpose.equalsIgnoreCase("ServerAuth")) {
                    keyPurposeIds.add(KeyPurposeId.id_kp_serverAuth);
                    continue;
                }
                if (keyPurpose.equalsIgnoreCase("ClientAuth")) {
                    keyPurposeIds.add(KeyPurposeId.id_kp_clientAuth);
                    continue;
                }
                if (keyPurpose.equalsIgnoreCase("CodeSigning")) {
                    keyPurposeIds.add(KeyPurposeId.id_kp_codeSigning);
                    continue;
                }
                if (keyPurpose.equalsIgnoreCase("EmailProtection")) {
                    keyPurposeIds.add(KeyPurposeId.id_kp_emailProtection);
                    continue;
                }
                if (keyPurpose.equalsIgnoreCase("IPSecEndSystem")) {
                    keyPurposeIds.add(KeyPurposeId.id_kp_ipsecEndSystem);
                    continue;
                }
                if (keyPurpose.equalsIgnoreCase("IPSecTunnel")) {
                    keyPurposeIds.add(KeyPurposeId.id_kp_ipsecTunnel);
                    continue;
                }
                if (keyPurpose.equalsIgnoreCase("IPSecUser")) {
                    keyPurposeIds.add(KeyPurposeId.id_kp_ipsecUser);
                    continue;
                }
                if (keyPurpose.equalsIgnoreCase("TimeStamping")) {
                    keyPurposeIds.add(KeyPurposeId.id_kp_timeStamping);
                    continue;
                }
                if (keyPurpose.equalsIgnoreCase("OCSPSigning")) {
                    keyPurposeIds.add(KeyPurposeId.id_kp_OCSPSigning);
                    continue;
                }
                if (keyPurpose.equalsIgnoreCase("Smartcardlogon")) {
                    keyPurposeIds.add(KeyPurposeId.id_kp_smartcardlogon);
                    continue;
                }
                log.error("Unknown ExtendedKeyUsage: " + keyPurpose);
            }
            return CertificateExtensionFactory.createExtendedKeyUsageExtension(keyPurposeIds, values, critical);
        }
        if (id.equals(X509Extension.certificatePolicies.getId()) || id.equalsIgnoreCase("CertificatePolicies")) {
            Vector<String> policyOIDs = new Vector<String>();
            StringTokenizer st = new StringTokenizer(values, ",");
            while (st.hasMoreElements()) {
                String policyOID = (String)st.nextElement();
                policyOID = policyOID.trim();
                policyOIDs.add(policyOID);
            }
            return CertificateExtensionFactory.createCertificatePoliciesExtension(policyOIDs, values, critical);
        }
        if (id.equals(X509Extension.subjectAlternativeName.getId()) || id.equalsIgnoreCase("SubjectAltName")) {
            Vector<String> typedSubjectAltNames = new Vector<String>();
            StringTokenizer st = new StringTokenizer(values, ",");
            while (st.hasMoreElements()) {
                String typedAltName = (String)st.nextElement();
                typedAltName = typedAltName.trim();
                typedSubjectAltNames.add(typedAltName);
            }
            return CertificateExtensionFactory.createSubjectAltNameExtension(typedSubjectAltNames, values, critical);
        }
        log.error("Unsupported CertificateExtension: " + id);
        return null;
    }

    protected static CertificateExtension createExtendedKeyUsageExtension(Vector<KeyPurposeId> keyPurposeIds, String keyPurposeNames, boolean critical) {
        ExtendedKeyUsage extendedKeyUsage = new ExtendedKeyUsage(keyPurposeIds);
        X509Extension extendedKeyUsageExtension = new X509Extension(critical, (ASN1OctetString)new DEROctetString((DEREncodable)extendedKeyUsage));
        return new CertificateExtension((DERObjectIdentifier)X509Extension.extendedKeyUsage, "ExtendedKeyUsage", extendedKeyUsageExtension, keyPurposeNames, critical);
    }

    protected static CertificateExtension createExtendedKeyUsageExtension(KeyPurposeId keyPurposeId, String keyPurposeName, boolean critical) {
        DERSequence keyPurposeIds = new DERSequence((DEREncodable)keyPurposeId);
        ExtendedKeyUsage extendedKeyUsage = new ExtendedKeyUsage((ASN1Sequence)keyPurposeIds);
        X509Extension extendedKeyUsageExtension = new X509Extension(critical, (ASN1OctetString)new DEROctetString((DEREncodable)extendedKeyUsage));
        return new CertificateExtension((DERObjectIdentifier)X509Extension.extendedKeyUsage, "ExtendedKeyUsage", extendedKeyUsageExtension, keyPurposeName, critical);
    }

    protected static CertificateExtension createSubjectAltNameExtension(String emailAddress, boolean critical) {
        GeneralName subjectAltName = new GeneralName(1, emailAddress);
        GeneralNames subjectAltNames = new GeneralNames(subjectAltName);
        X509Extension subjectAltNameExtension = new X509Extension(critical, (ASN1OctetString)new DEROctetString((DEREncodable)subjectAltNames));
        return new CertificateExtension((DERObjectIdentifier)X509Extension.subjectAlternativeName, "SubjectAltName", subjectAltNameExtension, emailAddress, critical);
    }

    protected static CertificateExtension createSubjectAltNameExtension(Vector<String> prefixedAltNames, String values, boolean critical) {
        ASN1EncodableVector altNames = new ASN1EncodableVector();
        Enumeration<String> typeAndNames = prefixedAltNames.elements();
        while (typeAndNames.hasMoreElements()) {
            GeneralName altName;
            String typeAndName = typeAndNames.nextElement();
            if ((typeAndName = typeAndName.trim()).startsWith("email:")) {
                String emailAddress = typeAndName.substring("email:".length());
                altName = new GeneralName(1, emailAddress);
                altNames.add((DEREncodable)altName);
                continue;
            }
            if (!typeAndName.startsWith("dns:")) continue;
            String hostname = typeAndName.substring("dns:".length());
            altName = new GeneralName(2, hostname);
            altNames.add((DEREncodable)altName);
        }
        DERSequence subjectAltNames = new DERSequence(altNames);
        GeneralNames generalNames = new GeneralNames((ASN1Sequence)subjectAltNames);
        X509Extension subjectAltNameExtension = new X509Extension(critical, (ASN1OctetString)new DEROctetString((DEREncodable)generalNames));
        return new CertificateExtension((DERObjectIdentifier)X509Extension.subjectAlternativeName, "SubjectAltName", subjectAltNameExtension, values, critical);
    }

    protected static CertificateExtension createCertificatePoliciesExtension(String policyOID, boolean critical) {
        DERObjectIdentifier policyIdentifier = new DERObjectIdentifier(policyOID);
        PolicyInformation policyInformation = new PolicyInformation(policyIdentifier);
        DERSequence certificatePolicies = new DERSequence((DEREncodable)policyInformation);
        X509Extension certificatePoliciesExtension = new X509Extension(critical, (ASN1OctetString)new DEROctetString((DEREncodable)certificatePolicies));
        return new CertificateExtension((DERObjectIdentifier)X509Extension.certificatePolicies, "CertificatePolicies", certificatePoliciesExtension, policyOID, critical);
    }

    protected static CertificateExtension createCertificatePoliciesExtension(Vector<String> policyOIDs, String values, boolean critical) {
        ASN1EncodableVector policyInformations = new ASN1EncodableVector();
        Enumeration<String> pOids = policyOIDs.elements();
        while (pOids.hasMoreElements()) {
            String policyOid = pOids.nextElement();
            DERObjectIdentifier policyIdentifier = new DERObjectIdentifier(policyOid);
            PolicyInformation policyInformation = new PolicyInformation(policyIdentifier);
            policyInformations.add((DEREncodable)policyInformation);
        }
        DERSequence certificatePolicies = new DERSequence(policyInformations);
        X509Extension certificatePoliciesExtension = new X509Extension(critical, (ASN1OctetString)new DEROctetString((DEREncodable)certificatePolicies));
        return new CertificateExtension((DERObjectIdentifier)X509Extension.certificatePolicies, "CertificatePolicies", certificatePoliciesExtension, values, critical);
    }

    protected static CertificateExtension createKeyUsageExtension(int usage, String value, boolean critical) {
        KeyUsage keyUsage = new KeyUsage(usage);
        X509Extension keyUsageExtension = new X509Extension(critical, (ASN1OctetString)new DEROctetString((DEREncodable)keyUsage));
        return new CertificateExtension((DERObjectIdentifier)X509Extension.keyUsage, "KeyUsage", keyUsageExtension, value, critical);
    }

    private CertificateExtensionFactory() {
    }
}

