/*
 * Decompiled with CFR 0.152.
 */
package org.glite.pseudo.common.pki;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import org.glite.pseudo.common.pki.bouncycastle.Codec;
import org.glite.pseudo.common.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Certificate {
    private static Logger log = LoggerFactory.getLogger(Certificate.class);
    public static final int CRT_FILE_PERMISSION = 640;
    private X509Certificate cert_;
    private X509Certificate[] chain_;

    public static Certificate readPEM(Reader reader) throws IOException, GeneralSecurityException {
        log.debug("read cert and chain...");
        X509Certificate[] certificates = Codec.readPEMEncodedCertificates(reader);
        int length = certificates.length;
        if (length < 1) {
            log.error("No X509 certificate found in source");
            throw new GeneralSecurityException("No valid X509 certificates found");
        }
        X509Certificate cert = certificates[0];
        X509Certificate[] chain = null;
        int chainLength = length - 1;
        if (chainLength > 0) {
            chain = new X509Certificate[chainLength];
            System.arraycopy(certificates, 1, chain, 0, chainLength);
        }
        return new Certificate(cert, chain);
    }

    public Certificate(X509Certificate cert, X509Certificate[] chain) throws GeneralSecurityException {
        if (cert == null) {
            throw new GeneralSecurityException("X509Certificate is null");
        }
        this.cert_ = cert;
        this.chain_ = chain;
    }

    public Certificate(X509Certificate cert) throws GeneralSecurityException {
        this(cert, null);
    }

    public void storePEM(String filename) throws IOException {
        File file = new File(filename);
        this.storePEM(file);
    }

    public void storePEM(File file) throws IOException {
        boolean permOk = Util.setFilePermissions(file, 640);
        if (!permOk) {
            log.warn("Failed to set permission: 640 for file: " + file);
        }
        Codec.storePEMEncoded(this.cert_, this.chain_, file);
    }

    public String getPEM() throws IOException {
        StringBuffer sb = new StringBuffer();
        sb.append(Codec.getPEMEncoded(this.cert_));
        if (this.chain_ != null) {
            for (int i = 0; i < this.chain_.length; ++i) {
                X509Certificate chainCert = this.chain_[i];
                sb.append(Codec.getPEMEncoded(chainCert));
            }
        }
        return sb.toString();
    }

    public X509Certificate[] getCertificateChain() {
        return this.chain_;
    }

    public X509Certificate getCertificate() {
        return this.cert_;
    }
}

