/*
 * Decompiled with CFR 0.152.
 */
package org.glite.pseudo.common.log;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.slf4j.LoggerFactory;

public class LogbackLoggingService {
    public LogbackLoggingService(String loggingConfigurationFile) {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        StatusManager statusManager = loggerContext.getStatusManager();
        statusManager.add((Status)new InfoStatus("Loading logging configuration file: " + loggingConfigurationFile, (Object)this));
        loggerContext.reset();
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext((Context)loggerContext);
        try {
            configurator.doConfigure((InputStream)new FileInputStream(loggingConfigurationFile));
        }
        catch (FileNotFoundException e) {
            statusManager.add((Status)new ErrorStatus("Error loading logging configuration file: " + loggingConfigurationFile, (Object)this, (Throwable)e));
        }
        catch (JoranException e) {
            statusManager.add((Status)new ErrorStatus("Error loading logging configuration file: " + loggingConfigurationFile, (Object)this, (Throwable)e));
        }
        loggerContext.start();
    }
}

