/*
 * Decompiled with CFR 0.152.
 */
package org.glite.pseudo.common.http;

import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.emi.security.authn.x509.X509Credential;
import eu.emi.security.authn.x509.impl.OpensslCertChainValidator;
import eu.emi.security.authn.x509.impl.PEMCredential;
import eu.emi.security.authn.x509.impl.SocketFactoryCreator;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.security.cert.CertificateException;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.client.protocol.RequestAcceptEncoding;
import org.apache.http.client.protocol.ResponseContentEncoding;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.SingleClientConnManager;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientBuilder {
    private static final Logger log = LoggerFactory.getLogger(HttpClientBuilder.class);
    public static final String CA_CERTIFICATE_DIRECTORY = "/etc/grid-security/certificates";
    private URL serverUrl;
    private boolean connectionPooling;
    private int connectionsMaxTotal;
    private int connectionsMaxPerRoute;
    private X509Credential credential;
    private X509CertChainValidator chainValidator = new OpensslCertChainValidator("/etc/grid-security/certificates");

    public HttpClientBuilder(URL url, String gridProxyFile) {
        this.serverUrl = url;
        this.setGridProxyFile(gridProxyFile);
    }

    public HttpClientBuilder(String url, String gridProxyFile) {
        this.setUrl(url);
        this.setGridProxyFile(gridProxyFile);
    }

    public HttpClientBuilder(String url, String certFile, String keyFile) {
        this(url, certFile, keyFile, null);
    }

    public HttpClientBuilder(String url, String certFile, String keyFile, String keyPasswd) {
        this.setUrl(url);
        try {
            if (!this.serverUrl.getProtocol().equals("http")) {
                this.credential = keyPasswd == null ? new PEMCredential(keyFile, certFile, null) : new PEMCredential(keyFile, certFile, keyPasswd.toCharArray());
            } else {
                log.info("No security credential configured to this builder");
            }
        }
        catch (KeyStoreException e) {
            log.error("Could not load private key", (Throwable)e);
        }
        catch (CertificateException e) {
            log.error("Could not load certificate", (Throwable)e);
        }
        catch (IOException e) {
            log.error("Could not read the proxy file", (Throwable)e);
        }
    }

    protected void setGridProxyFile(String gridProxyFile) {
        try {
            this.credential = new PEMCredential(gridProxyFile, (char[])null);
        }
        catch (KeyStoreException e) {
            log.error("Could not load private key", (Throwable)e);
        }
        catch (CertificateException e) {
            log.error("Could not load certificate", (Throwable)e);
        }
        catch (IOException e) {
            log.error("Could not read the proxy file", (Throwable)e);
        }
    }

    protected void setUrl(String url) {
        log.debug("Setting service URL for {}", (Object)url);
        try {
            this.serverUrl = new URL(url);
        }
        catch (MalformedURLException e) {
            log.error("The given URL {} is not valid", (Object)url);
        }
    }

    public HttpClient buildClient() throws IOException, GeneralSecurityException {
        DefaultHttpClient client = new DefaultHttpClient(this.buildConnectionManager());
        client.addRequestInterceptor((HttpRequestInterceptor)new RequestAcceptEncoding());
        client.addResponseInterceptor((HttpResponseInterceptor)new ResponseContentEncoding());
        return client;
    }

    private ClientConnectionManager buildConnectionManager() throws IOException, GeneralSecurityException {
        SchemeRegistry registry = this.buildSchemeRegistry();
        if (!this.connectionPooling) {
            return new SingleClientConnManager(registry);
        }
        ThreadSafeClientConnManager manager = new ThreadSafeClientConnManager(registry);
        manager.setDefaultMaxPerRoute(this.connectionsMaxPerRoute);
        manager.setMaxTotal(this.connectionsMaxTotal);
        return manager;
    }

    private SchemeRegistry buildSchemeRegistry() throws IOException, GeneralSecurityException {
        SchemeRegistry registry = new SchemeRegistry();
        String protocol = this.serverUrl.getProtocol();
        if (protocol.equals("http")) {
            registry.register(new Scheme("http", this.serverUrl.getPort(), (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        } else if (protocol.equals("https")) {
            SSLSocketFactory sslSF = new SSLSocketFactory(SocketFactoryCreator.getSocketFactory((X509Credential)this.credential, (X509CertChainValidator)this.chainValidator), SSLSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
            registry.register(new Scheme("https", this.serverUrl.getPort(), (SchemeSocketFactory)sslSF));
        } else {
            log.error("Invalid protocol ({}), HTTP client could not be initialized!", (Object)protocol);
        }
        return registry;
    }
}

