from arcnagios.nagutils import ServiceUNKNOWN
import os, random, time

def _subst_option(config, section, var, target_env):
    if config.has_option(section, 'default'):
	default = config.get(section, 'default', vars = target_env)
    else:
	default = None
    if default is None:
	raise ServiceUNKNOWN(
		'Missing required option (-O %s=...).'%var)
    target_env[var] = default

def _subst_getenv(config, section, var, target_env):
    if config.has_option(section, 'default'):
	default = config.get(section, 'default', vars = target_env)
    else:
	default = None
    if config.has_option(section, 'prefix'):
	prefix = config.get(section, 'prefix')
    else:
	prefix = ''
    if config.has_option(section, 'envvar'):
	v = os.getenv(config.get(section, 'envvar'), default)
    else:
	v = os.getenv(prefix + var, default)
    if v is None:
	raise ServiceUNKNOWN('Missing required option (-O) or '
			     'enviroment variable %s.'%var)
    target_env[var] = v

def _subst_random_line(config, section, var, target_env):
    path = config.get(section, 'input_file', vars = target_env)
    try:
	fh = open(path)
	ln = fh.next().strip()
    except IOError, xc:
	raise ServiceUNKNOWN(str(xc))
    except StopIteration:
	raise ServiceUNKNOWN('%s must contains at least one line'%path)

    rng = random.Random(time.time())
    n = 1
    while True:
	try:
	    ln_next = fh.next().strip()
	    if not ln_next:
		continue
	    if rng.randint(0, n) == 0:
		ln = ln_next
	except StopIteration:
	    fh.close()
	    target_env[var] = ln
	    return
	n += 1

def _subst_strftime(config, section, var, target_env):
    if config.has_option(section, 'raw_format'):
	format = config.get(section, 'raw_format', vars = target_env, raw=True)
    else:
	format = config.get(section, 'format', vars = target_env)
    target_env[var] = time.strftime(format)

_method_by_name = {
    'option': _subst_option,
    'getenv': _subst_getenv,
    'random_line': _subst_random_line,
    'strftime': _subst_strftime,
}

def register_substitution_method(name, f):
    _method_by_name[name] = f

def import_section_variables(config, section, target_env):
    if config.has_option(section, 'variables'):
	vars = config.get(section, 'variables').split()
	for var in vars:
	    if var in target_env:
		if target_env[var] == None:
		    raise ServiceUNKNOWN('Substitutions involving %s are '
					 'cyclic.'%var)
		continue
	    target_env[var] = None
	    import_variable(config, var, target_env)

def import_variable(config, var, target_env):
    section = 'variable.' + var
    import_section_variables(config, section, target_env)
    method = config.get(section, 'method')
    try:
	return _method_by_name[method](config, section, var, target_env)
    except KeyError:
	raise ServiceUNKNOWN('Unknown substitution method %s.'%method)
