# Generated by rpcgen.py from rpc.x on Fri Mar  8 00:59:53 2013
import rpc_const as const
import rpc_type as types
import xdrlib
from xdrlib import Error as XDRError

class nullclass(object):
    pass

class RPCPacker(xdrlib.Packer):
    def __init__(self, check_enum=True, check_array=True):
        xdrlib.Packer.__init__(self)
        self.check_enum = check_enum
        self.check_array = check_array

    pack_hyper = xdrlib.Packer.pack_hyper
    pack_string = xdrlib.Packer.pack_string
    pack_int = xdrlib.Packer.pack_int
    pack_float = xdrlib.Packer.pack_float
    pack_uint = xdrlib.Packer.pack_uint
    pack_opaque = xdrlib.Packer.pack_opaque
    pack_double = xdrlib.Packer.pack_double
    pack_unsigned = xdrlib.Packer.pack_uint
    pack_quadruple = xdrlib.Packer.pack_double
    pack_uhyper = xdrlib.Packer.pack_uhyper
    pack_bool = xdrlib.Packer.pack_bool
    def pack_auth_flavor(self, data):
        if hasattr(self, 'filter_auth_flavor'):
            data = getattr(self, 'filter_auth_flavor')(data)
        if self.check_enum and data not in [const.AUTH_NONE, const.AUTH_SYS, const.AUTH_SHORT, const.AUTH_DH, const.RPCSEC_GSS]:
            raise XDRError, 'value=%s not in enum auth_flavor' % data
        self.pack_int(data)

    def pack_opaque_auth(self, data):
        if hasattr(self, 'filter_opaque_auth'):
            data = getattr(self, 'filter_opaque_auth')(data)
        if data.flavor is None:
            raise TypeError, 'data.flavor == None'
        self.pack_auth_flavor(data.flavor)
        if data.body is None:
            raise TypeError, 'data.body == None'
        if len(data.body) > 400 and self.check_array:
            raise XDRError, 'array length too long for data.body'
        self.pack_opaque(data.body)

    def pack_msg_type(self, data):
        if hasattr(self, 'filter_msg_type'):
            data = getattr(self, 'filter_msg_type')(data)
        if self.check_enum and data not in [const.CALL, const.REPLY]:
            raise XDRError, 'value=%s not in enum msg_type' % data
        self.pack_int(data)

    def pack_reply_stat(self, data):
        if hasattr(self, 'filter_reply_stat'):
            data = getattr(self, 'filter_reply_stat')(data)
        if self.check_enum and data not in [const.MSG_ACCEPTED, const.MSG_DENIED]:
            raise XDRError, 'value=%s not in enum reply_stat' % data
        self.pack_int(data)

    def pack_accept_stat(self, data):
        if hasattr(self, 'filter_accept_stat'):
            data = getattr(self, 'filter_accept_stat')(data)
        if self.check_enum and data not in [const.SUCCESS, const.PROG_UNAVAIL, const.PROG_MISMATCH, const.PROC_UNAVAIL, const.GARBAGE_ARGS, const.SYSTEM_ERR]:
            raise XDRError, 'value=%s not in enum accept_stat' % data
        self.pack_int(data)

    def pack_reject_stat(self, data):
        if hasattr(self, 'filter_reject_stat'):
            data = getattr(self, 'filter_reject_stat')(data)
        if self.check_enum and data not in [const.RPC_MISMATCH, const.AUTH_ERROR]:
            raise XDRError, 'value=%s not in enum reject_stat' % data
        self.pack_int(data)

    def pack_auth_stat(self, data):
        if hasattr(self, 'filter_auth_stat'):
            data = getattr(self, 'filter_auth_stat')(data)
        if self.check_enum and data not in [const.AUTH_OK, const.AUTH_BADCRED, const.AUTH_REJECTEDCRED, const.AUTH_BADVERF, const.AUTH_REJECTEDVERF, const.AUTH_TOOWEAK, const.AUTH_INVALIDRESP, const.AUTH_FAILED, const.AUTH_KERB_GENERIC, const.AUTH_TIMEEXPIRE, const.AUTH_TKT_FILE, const.AUTH_DECODE, const.AUTH_NET_ADDR, const.RPCSEC_GSS_CREDPROBLEM, const.RPCSEC_GSS_CTXPROBLEM]:
            raise XDRError, 'value=%s not in enum auth_stat' % data
        self.pack_int(data)

    def pack_rpc_msg(self, data):
        if hasattr(self, 'filter_rpc_msg'):
            data = getattr(self, 'filter_rpc_msg')(data)
        if data.xid is None:
            raise TypeError, 'data.xid == None'
        self.pack_uint(data.xid)
        if data.body is None:
            raise TypeError, 'data.body == None'
        self.pack_rpc_msg_body(data.body)

    def pack_rpc_msg_body(self, data):
        if hasattr(self, 'filter_rpc_msg_body'):
            data = getattr(self, 'filter_rpc_msg_body')(data)
        if data.mtype is None:
            raise TypeError, 'data.mtype == None'
        self.pack_msg_type(data.mtype)
        if data.mtype == const.CALL:
            if data.cbody is None:
                raise TypeError, 'data.cbody == None'
            self.pack_call_body(data.cbody)
        elif data.mtype == const.REPLY:
            if data.rbody is None:
                raise TypeError, 'data.rbody == None'
            self.pack_reply_body(data.rbody)
        else:
            raise XDRError, 'bad switch=%s' % data.mtype

    def pack_call_body(self, data):
        if hasattr(self, 'filter_call_body'):
            data = getattr(self, 'filter_call_body')(data)
        if data.rpcvers is None:
            raise TypeError, 'data.rpcvers == None'
        self.pack_uint(data.rpcvers)
        if data.prog is None:
            raise TypeError, 'data.prog == None'
        self.pack_uint(data.prog)
        if data.vers is None:
            raise TypeError, 'data.vers == None'
        self.pack_uint(data.vers)
        if data.proc is None:
            raise TypeError, 'data.proc == None'
        self.pack_uint(data.proc)
        if data.cred is None:
            raise TypeError, 'data.cred == None'
        self.pack_opaque_auth(data.cred)
        if data.verf is None:
            raise TypeError, 'data.verf == None'
        self.pack_opaque_auth(data.verf)

    def pack_reply_body(self, data):
        if hasattr(self, 'filter_reply_body'):
            data = getattr(self, 'filter_reply_body')(data)
        if data.stat is None:
            raise TypeError, 'data.stat == None'
        self.pack_reply_stat(data.stat)
        if data.stat == const.MSG_ACCEPTED:
            if data.areply is None:
                raise TypeError, 'data.areply == None'
            self.pack_accepted_reply(data.areply)
        elif data.stat == const.MSG_DENIED:
            if data.rreply is None:
                raise TypeError, 'data.rreply == None'
            self.pack_rejected_reply(data.rreply)
        else:
            raise XDRError, 'bad switch=%s' % data.stat

    def pack_rpc_mismatch_info(self, data):
        if hasattr(self, 'filter_rpc_mismatch_info'):
            data = getattr(self, 'filter_rpc_mismatch_info')(data)
        if data.low is None:
            raise TypeError, 'data.low == None'
        self.pack_uint(data.low)
        if data.high is None:
            raise TypeError, 'data.high == None'
        self.pack_uint(data.high)

    def pack_rpc_reply_data(self, data):
        if hasattr(self, 'filter_rpc_reply_data'):
            data = getattr(self, 'filter_rpc_reply_data')(data)
        if data.stat is None:
            raise TypeError, 'data.stat == None'
        self.pack_accept_stat(data.stat)
        if data.stat == const.SUCCESS:
            if data.results is None:
                raise TypeError, 'data.results == None'
            self.pack_fopaque(0, data.results)
        elif data.stat == const.PROG_MISMATCH:
            if data.mismatch_info is None:
                raise TypeError, 'data.mismatch_info == None'
            self.pack_rpc_mismatch_info(data.mismatch_info)
        else:
            pass

    def pack_accepted_reply(self, data):
        if hasattr(self, 'filter_accepted_reply'):
            data = getattr(self, 'filter_accepted_reply')(data)
        if data.verf is None:
            raise TypeError, 'data.verf == None'
        self.pack_opaque_auth(data.verf)
        if data.reply_data is None:
            raise TypeError, 'data.reply_data == None'
        self.pack_rpc_reply_data(data.reply_data)

    def pack_rejected_reply(self, data):
        if hasattr(self, 'filter_rejected_reply'):
            data = getattr(self, 'filter_rejected_reply')(data)
        if data.stat is None:
            raise TypeError, 'data.stat == None'
        self.pack_reject_stat(data.stat)
        if data.stat == const.RPC_MISMATCH:
            if data.mismatch_info is None:
                raise TypeError, 'data.mismatch_info == None'
            self.pack_rpc_mismatch_info(data.mismatch_info)
        elif data.stat == const.AUTH_ERROR:
            if data.astat is None:
                raise TypeError, 'data.astat == None'
            self.pack_auth_stat(data.astat)
        else:
            raise XDRError, 'bad switch=%s' % data.stat

    def pack_authsys_parms(self, data):
        if hasattr(self, 'filter_authsys_parms'):
            data = getattr(self, 'filter_authsys_parms')(data)
        if data.stamp is None:
            raise TypeError, 'data.stamp == None'
        self.pack_uint(data.stamp)
        if data.machinename is None:
            raise TypeError, 'data.machinename == None'
        if len(data.machinename) > 255 and self.check_array:
            raise XDRError, 'array length too long for data.machinename'
        self.pack_string(data.machinename)
        if data.uid is None:
            raise TypeError, 'data.uid == None'
        self.pack_uint(data.uid)
        if data.gid is None:
            raise TypeError, 'data.gid == None'
        self.pack_uint(data.gid)
        if data.gids is None:
            raise TypeError, 'data.gids == None'
        if len(data.gids) > 16 and self.check_array:
            raise XDRError, 'array length too long for data.gids'
        self.pack_array(data.gids, self.pack_uint)

class RPCUnpacker(xdrlib.Unpacker):
    def __init__(self, data, check_enum=True, check_array=True):
        xdrlib.Unpacker.__init__(self, data)
        self.check_enum = check_enum
        self.check_array = check_array

    unpack_hyper = xdrlib.Unpacker.unpack_hyper
    unpack_string = xdrlib.Unpacker.unpack_string
    unpack_int = xdrlib.Unpacker.unpack_int
    unpack_float = xdrlib.Unpacker.unpack_float
    unpack_uint = xdrlib.Unpacker.unpack_uint
    unpack_opaque = xdrlib.Unpacker.unpack_opaque
    unpack_double = xdrlib.Unpacker.unpack_double
    unpack_unsigned = xdrlib.Unpacker.unpack_uint
    unpack_quadruple = xdrlib.Unpacker.unpack_double
    unpack_uhyper = xdrlib.Unpacker.unpack_uhyper
    unpack_bool = xdrlib.Unpacker.unpack_bool
    def unpack_auth_flavor(self):
        data = self.unpack_int()
        if self.check_enum and data not in [const.AUTH_NONE, const.AUTH_SYS, const.AUTH_SHORT, const.AUTH_DH, const.RPCSEC_GSS]:
            raise XDRError, 'value=%s not in enum auth_flavor' % data
        if hasattr(self, 'filter_auth_flavor'):
            data = getattr(self, 'filter_auth_flavor')(data)
        return data

    def unpack_opaque_auth(self):
        data = types.opaque_auth()
        data.flavor = self.unpack_auth_flavor()
        data.body = self.unpack_opaque()
        if len(data.body) > 400 and self.check_array:
            raise XDRError, 'array length too long for data.body'
        if hasattr(self, 'filter_opaque_auth'):
            data = getattr(self, 'filter_opaque_auth')(data)
        return data

    def unpack_msg_type(self):
        data = self.unpack_int()
        if self.check_enum and data not in [const.CALL, const.REPLY]:
            raise XDRError, 'value=%s not in enum msg_type' % data
        if hasattr(self, 'filter_msg_type'):
            data = getattr(self, 'filter_msg_type')(data)
        return data

    def unpack_reply_stat(self):
        data = self.unpack_int()
        if self.check_enum and data not in [const.MSG_ACCEPTED, const.MSG_DENIED]:
            raise XDRError, 'value=%s not in enum reply_stat' % data
        if hasattr(self, 'filter_reply_stat'):
            data = getattr(self, 'filter_reply_stat')(data)
        return data

    def unpack_accept_stat(self):
        data = self.unpack_int()
        if self.check_enum and data not in [const.SUCCESS, const.PROG_UNAVAIL, const.PROG_MISMATCH, const.PROC_UNAVAIL, const.GARBAGE_ARGS, const.SYSTEM_ERR]:
            raise XDRError, 'value=%s not in enum accept_stat' % data
        if hasattr(self, 'filter_accept_stat'):
            data = getattr(self, 'filter_accept_stat')(data)
        return data

    def unpack_reject_stat(self):
        data = self.unpack_int()
        if self.check_enum and data not in [const.RPC_MISMATCH, const.AUTH_ERROR]:
            raise XDRError, 'value=%s not in enum reject_stat' % data
        if hasattr(self, 'filter_reject_stat'):
            data = getattr(self, 'filter_reject_stat')(data)
        return data

    def unpack_auth_stat(self):
        data = self.unpack_int()
        if self.check_enum and data not in [const.AUTH_OK, const.AUTH_BADCRED, const.AUTH_REJECTEDCRED, const.AUTH_BADVERF, const.AUTH_REJECTEDVERF, const.AUTH_TOOWEAK, const.AUTH_INVALIDRESP, const.AUTH_FAILED, const.AUTH_KERB_GENERIC, const.AUTH_TIMEEXPIRE, const.AUTH_TKT_FILE, const.AUTH_DECODE, const.AUTH_NET_ADDR, const.RPCSEC_GSS_CREDPROBLEM, const.RPCSEC_GSS_CTXPROBLEM]:
            raise XDRError, 'value=%s not in enum auth_stat' % data
        if hasattr(self, 'filter_auth_stat'):
            data = getattr(self, 'filter_auth_stat')(data)
        return data

    def unpack_rpc_msg(self):
        data = types.rpc_msg()
        data.xid = self.unpack_uint()
        data.body = self.unpack_rpc_msg_body()
        if hasattr(self, 'filter_rpc_msg'):
            data = getattr(self, 'filter_rpc_msg')(data)
        return data

    def unpack_rpc_msg_body(self):
        data = types.rpc_msg_body()
        data.mtype = self.unpack_msg_type()
        if data.mtype == const.CALL:
            data.cbody = self.unpack_call_body()
        elif data.mtype == const.REPLY:
            data.rbody = self.unpack_reply_body()
        else:
            raise XDRError, 'bad switch=%s' % data.mtype
        if hasattr(self, 'filter_rpc_msg_body'):
            data = getattr(self, 'filter_rpc_msg_body')(data)
        return data

    def unpack_call_body(self):
        data = types.call_body()
        data.rpcvers = self.unpack_uint()
        data.prog = self.unpack_uint()
        data.vers = self.unpack_uint()
        data.proc = self.unpack_uint()
        data.cred = self.unpack_opaque_auth()
        data.verf = self.unpack_opaque_auth()
        if hasattr(self, 'filter_call_body'):
            data = getattr(self, 'filter_call_body')(data)
        return data

    def unpack_reply_body(self):
        data = types.reply_body()
        data.stat = self.unpack_reply_stat()
        if data.stat == const.MSG_ACCEPTED:
            data.areply = self.unpack_accepted_reply()
        elif data.stat == const.MSG_DENIED:
            data.rreply = self.unpack_rejected_reply()
        else:
            raise XDRError, 'bad switch=%s' % data.stat
        if hasattr(self, 'filter_reply_body'):
            data = getattr(self, 'filter_reply_body')(data)
        return data

    def unpack_rpc_mismatch_info(self):
        data = types.rpc_mismatch_info()
        data.low = self.unpack_uint()
        data.high = self.unpack_uint()
        if hasattr(self, 'filter_rpc_mismatch_info'):
            data = getattr(self, 'filter_rpc_mismatch_info')(data)
        return data

    def unpack_rpc_reply_data(self):
        data = types.rpc_reply_data()
        data.stat = self.unpack_accept_stat()
        if data.stat == const.SUCCESS:
            data.results = self.unpack_fopaque(0)
        elif data.stat == const.PROG_MISMATCH:
            data.mismatch_info = self.unpack_rpc_mismatch_info()
        else:
            pass
        if hasattr(self, 'filter_rpc_reply_data'):
            data = getattr(self, 'filter_rpc_reply_data')(data)
        return data

    def unpack_accepted_reply(self):
        data = types.accepted_reply()
        data.verf = self.unpack_opaque_auth()
        data.reply_data = self.unpack_rpc_reply_data()
        if hasattr(self, 'filter_accepted_reply'):
            data = getattr(self, 'filter_accepted_reply')(data)
        return data

    def unpack_rejected_reply(self):
        data = types.rejected_reply()
        data.stat = self.unpack_reject_stat()
        if data.stat == const.RPC_MISMATCH:
            data.mismatch_info = self.unpack_rpc_mismatch_info()
        elif data.stat == const.AUTH_ERROR:
            data.astat = self.unpack_auth_stat()
        else:
            raise XDRError, 'bad switch=%s' % data.stat
        if hasattr(self, 'filter_rejected_reply'):
            data = getattr(self, 'filter_rejected_reply')(data)
        return data

    def unpack_authsys_parms(self):
        data = types.authsys_parms()
        data.stamp = self.unpack_uint()
        data.machinename = self.unpack_string()
        if len(data.machinename) > 255 and self.check_array:
            raise XDRError, 'array length too long for data.machinename'
        data.uid = self.unpack_uint()
        data.gid = self.unpack_uint()
        data.gids = self.unpack_array(self.unpack_uint)
        if len(data.gids) > 16 and self.check_array:
            raise XDRError, 'array length too long for data.gids'
        if hasattr(self, 'filter_authsys_parms'):
            data = getattr(self, 'filter_authsys_parms')(data)
        return data

