#!/usr/bin/env python
# ops_gen.py - generate nfs4_ops.py file from nfs4_const and nfs4_type
#
# Written by Fred Isaman <iisaman@citi.umich.edu>
# Copyright (C) 2004 University of Michigan, Center for 
#                    Information Technology Integration
#

from nfs4.nfs4_const import nfs_opnum4
import nfs4.nfs4_type as nfs4_type
import time

header = """\
from nfs4_const import *
from nfs4_type import *

class NFS4Operations:
"""

indent = ' ' * 4
indent2 = indent * 2

def get_argnames(class_name):
    """Get the args names, in order"""
    klass = getattr(nfs4_type, class_name)
    args = range(len(klass().__dict__))
    c = klass(*args)
    pairs = [(v, k) for k,v in c.__dict__.items()]
    pairs.sort()
    names = [k for v,k in pairs]
    return ', '.join([''] + names)

def run():
    f = file('nfs4_ops.py', 'w')
    f.write("# Generated by ops_gen.py on %s\n" % time.asctime())
    f.write(header)
    keys = nfs_opnum4.keys()
    keys.sort()
    for k in keys:
        op_name = nfs_opnum4[k]
        funct_name = "%s_op" % op_name.lower()[3:]
        class_name = "%s4args" % op_name[3:]
        if hasattr(nfs4_type, class_name):
            arg_names = get_argnames(class_name)
            arg_set = ", op%s=args" % op_name.lower()[3:]
        else:
            arg_names = ""
            arg_set = ""
        f.write("\n%sdef %s(self%s):\n" % (indent, funct_name, arg_names))
        if arg_names:
            f.write("%sargs = %s(%s)\n" % (indent2, class_name, arg_names[2:]))
        f.write("%sreturn nfs_argop4(argop=%s%s)\n" % (indent2, op_name, arg_set))
    f.close()

if __name__ == "__main__":
    run()
