/*
 * Copyright (c) Members of the EGEE Collaboration. 2004.
 * See http://www.eu-egee.org/partners/ for details on the copyright holders.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * @(#)$RCSfile: lcg_util.h,v $ $Revision: 1.43 $ $Date: 2009/11/18 13:53:33 $ CERN Jean-Philippe Baud
 */
#ifndef _LCG_UTIL_H
#define _LCG_UTIL_H

#include "gfal_api.h"
#include "gfal_internals.h"

#define PROTOCOL_LIST_DELIMITER ","

typedef struct {
	GFAL_LONG64 transferred_bytes;
	float instant_throughput;
	float avg_throughput;
} perf_t;

typedef struct {
	char *file;
	int status;
	char *explanation;
} lcg_filestatus;

typedef struct {
	char *file;
	int status;
	char *explanation;
	char *checksum;
} lcg_checksum;

typedef void (* copyfile_callback_t) (
		perf_t                  s_perf,
		struct  timespec        ts,
		int                     *timeoutflg
		/* set timeoutflg = 1 to cancel the copy operation*/
		);


		/* User-callable entry points */

const char *lcg_util_version ();
void lcg_set_transfer_callback (copyfile_callback_t);
copyfile_callback_t lcg_get_transfer_callback ();
int lcg_aa (char *, char *, char *, char *, int);
int lcg_aax (char *, char *, char *, char *, int, char *, int);
int lcg_aa2 (char *, char *, int, char *, char *, int);
int lcg_cp (char *, char *, char *, int, char *, int, int);
int lcg_cpt (char *, char *, char *, int, char *, int, int, int);
int lcg_cpx (char *, char *, char *, int, char *, int, int, char *, int);
int lcg_cpxt (char *, char *, char *, int, char *, int, int, int, char *, int);
int lcg_cp2 (char *, char *, char *, int, char *, int, int, int, char *, char *, char *, int);
int lcg_cp3 (char *, char *, enum se_type, enum se_type, enum se_type, int, char *, int, char *, int, int, int, char *, char *, char *, int);
int lcg_cp4 (char *, char *, enum se_type, enum se_type, enum se_type, int, char *, int, char *, int, int, int, char *, char *, enum gfal_cksm_type, char *, int);

int lcg_cp5 (char *src_file, char *dest_file, enum se_type defaulttype,
    enum se_type srctype, enum se_type dsttype, int nobdii, char *vo,
    int nbstreams, char *conf_file, int insecure, int verbose, int timeout,
    char *src_spacetokendesc, char *dest_spacetokendesc,
    enum gfal_cksm_type cksmtype, char** src_protocols, char** dst_protocols,
    char *errbuf, int errbufsz);

int lcg_cr (char *, char *, char *, char *, char *, char *, int, char *, int, int, char *);
int lcg_crt (char *, char *, char *, char *, char *, char *, int, char *, int, int, int, char *);
int lcg_crx (char *, char *, char *, char *, char *, char *, int, char *, int, int, char *, char *, int);
int lcg_crxt (char *, char *, char *, char *, char *, char *, int, char *, int, int, int, char *, char *, int);
int lcg_cr2 (char *, char *, char *, char *, char *, char *, int, char *, int, int, int, char *, char *, char *, int);
int lcg_cr3 (char *, char *, char *, char *, enum se_type, enum se_type, int, char *, char *, int, char *, int, int, int, char *, char *, char *, int);
int lcg_cr4 (char *, char *, char *, char *, enum se_type, enum se_type, int, char *, char *, int, char *, int, int, int, char *, char *, enum gfal_cksm_type, char *, int);

int lcg_cr5 (char *src_file, char *dest_file, char *guid, char *lfn,
    enum se_type defaulttype, enum se_type dst_setype, int nobdii, char *vo,
    char *relative_path, int nbstreams, char *conf_file, int insecure,
    int verbose, int timeout, char *spacetokendesc, char *actual_guid,
    enum gfal_cksm_type cksmtype, char** dst_protocols,
    char *errbuf, int errbufsz);

int lcg_cr6 (char *src_file, char *dest_file, char *guid, char *lfn,
    enum se_type defaulttype, enum se_type dst_setype, int nobdii, char *vo,
    char *relative_path, int nbstreams, char *conf_file, int insecure,
    int verbose, int timeout, char *spacetokendesc, char *actual_guid,
    enum gfal_cksm_type cksmtype, char** dst_protocols,int nofilsizecheck,
    char *errbuf, int errbufsz);

int lcg_del (char *, int, char *, char *, char *, int, int);
int lcg_delt (char *, int, char *, char *, char *, int, int, int);
int lcg_delx (char *, int, char *, char *, char *, int, int, char *, int);
int lcg_delxt (char *, int, char *, char *, char *, int, int, int, char *, int);
int lcg_del3 (char *, enum se_type, enum se_type, int, int, char *, char *, char *, int, int, int, char *, int);
int lcg_del4 (char *, enum se_type, enum se_type, int, int, int, char *, char *, char *, int, int, int, char *, int);
int lcg_del5 (int, char **, enum se_type, enum se_type, int, int, int, char *, char *, char *, int, int, int, lcg_filestatus **, char *, int);
int lcg_del6 (int, char **, enum se_type, enum se_type, int, int, int, char *, char *, char *, int, int, int, int, lcg_filestatus **, char *, int);
int lcg_del7 (int, char **, enum se_type, enum se_type, int, int, int, char *, char *, char *, int, int, int, int, int, lcg_filestatus **, char *, int);
int lcg_get_checksum (int, char **, enum se_type, enum se_type, int, int, char *, enum gfal_cksm_type, lcg_checksum **, char *, int);
int lcg_get_checksum_surls (gfal_internal, int, enum gfal_cksm_type, lcg_checksum **, char *, int);
int lcg_gt (char *, char *, char **, int *, int *, char **);
int lcg_gtt (char *, char *, char **, int *, int *, char **, int);
int lcg_gtx (char *, char *, char **, int *, int *, char **, char *, int);
int lcg_gtxt (char *, char *, char **, int *, int *, char **, char *, int, int);
int lcg_gt2 (char *, char **, char **, int *, int *, char **, char *, int, int, char *);
int lcg_gt3 (char *, enum se_type, enum se_type, int, char **, char **, int *, int *, char **, char *, int, int, char *);
int lcg_gt4 (char *, enum se_type, enum se_type, int, char **, char **, enum se_type *, int *, int *, char **, char *, int, int, char *);
int lcg_la (char *, char *, char *, int, char ***);
int lcg_lax (char *, char *, char *, int, char ***, char *, int);
int lcg_la2 (char *, int, char *, char ***, char *, int);
int lcg_lg (char *, char *, char *, int, char *);
int lcg_lgx (char *, char *, char *, int, char *, char *, int);
int lcg_lg2 (char *, int, char *, char *, char *, int);
int lcg_lr (char *, char *, char *, int, char ***);
int lcg_lrx (char *, char *, char *, int, char ***, char *, int);
int lcg_lr2 (char *, int, char *, char ***, char *, int);
int lcg_lr3 (char *, int, char *, char ***, int, char *, int);
int lcg_ra (char *, char *, char *, char *, int);
int lcg_rax (char *, char *, char *, char *, int, char *, int);
int lcg_ra2 (char *, char *, int, char *, char *, int);
int lcg_rep (char *, char *, char *, char *, int, char *, int, int);
int lcg_rept (char *, char *, char *, char *, int, char *, int, int, int);
int lcg_repx (char *, char *, char *, char *, int, char *, int, int, char *, int);
int lcg_repxt (char *, char *, char *, char *, int, char *, int, int, int, char *, int);
int lcg_rep2 (char *, char *, char *, char *, int, char *, int, int, int, char *, char *, char *, int);
int lcg_rep3 (char *, char *, enum se_type, enum se_type, enum se_type, int, char *, char *, int, char *, int, int, int, char *, char *, char **, char *, int);
int lcg_rep4 (char *, char *, enum se_type, enum se_type, enum se_type, int, char *, char *, int, char *, int, int, int, char *, char *, char **, enum gfal_cksm_type, char *, int);

int lcg_rep5 (char *src_file, char *dest_file, enum se_type defaulttype,
    enum se_type srctype, enum se_type dsttype, int nobdii, char *vo,
    char *relative_path, int nbstreams, char *conf_file, int insecure,
    int verbose, int timeout, char *src_spacetokendesc,
    char *dest_spacetokendesc, char **actual_surl, enum gfal_cksm_type cksmtype,
    char** src_protocols, char** dst_protocols, char *errbuf, int errbufsz);

int lcg_rf (char *, char *, char *, char *, char *, int, int, char *);
int lcg_rft (char *, char *, char *, char *, char *, int, int, int, char *);
int lcg_rfx (char *, char *, char *, char *, char *, int, int, char *, char *, int);
int lcg_rfxt (char *, char *, char *, char *, char *, int, int, int, char *, char *, int);
int lcg_rf3 (char *, char *, char *, enum se_type, enum se_type, int, char *, char *, int, int, int, char *, char *, int);
int lcg_sd (char *, int, int, char *, int);
int lcg_sdt (char *, int, int, char *, int, int);
int lcg_sdx (char *, int, int, char *, int, char *, int);
int lcg_sdxt (char *, int, int, char *, int, char *, int, int);
int lcg_sd3 (char *, int, int, int, char *, char *, int, int);
int lcg_stmd (const char *, const char *, int *, gfal_spacemd **, int, int, char *, int);
int lcg_uf (char *, char *, char *, char *, int);
int lcg_ufx (char *, char *, char *, char *, int, char *, int);
int lcg_uf3 (char *, char *, char *, char *, int, int, char *, int);
int lcg_uf4 (char *, char *, int, char *, int, char *, int);

		/* Internal functions */

const char *lcg_se_type_string (enum se_type);
void copy_print_callback(perf_t, struct timespec, int *);
int copyfile (char *, char *, int, char *, int);
int copyfilex (char *, char *, int, char *, int, int, int);
int getfilesize (char *, GFAL_LONG64 *, char *, int);
int getfilesizet (char *, GFAL_LONG64 *, char *, int, int);
int makedir (char *, char *, int);
int makedirt (char *, char *, int, int);
int makedirp (char *, char *, int);
int makedirpt (char *, char *, int, int);
int gridftp_checksum (char *, enum gfal_cksm_type, char **, int, char *, int, int);
int se_match (char *, char *, char *, int);
int import_surls_from_file (const char *filename, char ***surls, char *errbuf, int errbufsz);
int check_surls (int, char **, char *, int);
char *lcg_compute_checksum (const char *, enum gfal_cksm_type, char *, int);

/**
 * Free properly a NULL-terminated string array. NULL-terminated: the last char*
 * pointer is NULL. The function frees the individual strings, then the array
 * or pointers.
 */
void lcg_free_string_array(char **s);

/**
 * Tokenize a string, and return the tokens as a NULL-terminated string array.
 * NULL-terminated: the last char* pointer is NULL.
 *
 * @param str The string to be tokenized
 * @param sep The separator characters. The tokens are separated by any of those
 *            characters. The tokens so not contain the separator characters.
 * @return The tokens, in a dynamically allocated, NULL-terminated string
 *         array. Delete the pointer with lcg_free_string_array.
 */
char ** lcg_tokenize(const char *str, const char *sep);

/** Convert a string to lowercase. The function modifies the original string.*/
void lcgutil_str_tolower
(
    char* str /**< The string to convert. */
);

#endif /* #ifndef _LCG_UTIL_H */
