#!/bin/sh

usage()
{
    echo "Usage: $0 [-n]" >&2
    exit 2
}

GRACE=60	# grace period in minutes
DRYRUN=		# dry run if non-empty
CONF=kill-stale-ftp.conf
dirs="
    ${GLITE_LOCATION:-/opt/glite}/etc
    ${GLOBUS_LOCATION:-/opt/globus}/etc
    /usr/local/etc
    /etc/sysconfig
    /etc
"

for dir in $dirs
do
    f=$dir/$CONF
    [ -r "$f" ] && . "$f"
done

while [ $# != 0 ]
do
    case $1 in
    -n)
	DRYRUN=1
	;;
    *)
	usage
    esac

    shift
done

echo "=== START `date` PID $$"

ps auxwww | awk '/gridftp[-]server/ && $1 != "root"' |
while read user pid rest
do
    if  find /proc/"$pid" -maxdepth 0 -mmin +"$GRACE" 2> /dev/null |
	grep . > /dev/null
    then
	printf '%-8s %5s %s\n' "$user" "$pid" "$rest"
	/usr/sbin/lsof -p "$pid" | grep '.->'
	[ "x$DRYRUN" = x ] && kill -9 "$pid"
    fi
done

echo "=== READY `date` PID $$"

