#ifndef DMUTILS_GRIDFTP_H
#define DMUTILS_GRIDFTP_H

#ifdef __cplusplus 
extern "C" {
#endif

#include "globus_gass_copy.h"
#include "globus_ftp_client.h"
#include "globus_ftp_client_restart_marker_plugin.h"
#include "globus_ftp_client_restart_plugin.h"
#include "globus_ftp_client_debug_plugin.h"

#ifndef LONG64LONG64
#if defined(__ia64__) || defined(__x86_64)
#define LONG64 long
#elif defined(_WIN32)
#define LONG64 __i64
#else
#define LONG64 long long
#endif
#endif

#define ERROR_BUFFER_SIZE 1024

    /*
    GridFTP Operation supported:
            -Make directory
            -Delete file
            -Get file size
            -Checksum
            -Third-party tranfer
            -Url-to-Url copy
     */

    /**
     * dmutils_gridftp_check_gsi_url
     * Utility function to check of the url is gsiftp
     * Required parameters: All
     * Optional paramaters: None
     * @return 0 or -1
     */

   
    /**
     * dmutils_gridftp_delete
     * Delete a file using gridftp. 
     * Required parameters: All
     * Optional paramaters: None
     * @return GLOBUS_SUCCESS or GLOBUS_FALSE
     */
    globus_result_t dmutils_gridftp_delete(
            const char* file,
            char* errbuf,
            int errbufsz,
            int timeout);

    /**
     * dmutils_gridftp_make_dir
     * Creates a directory  using gridftp. 
     * Required parameters: All
     * Optional paramaters: None
     * @return GLOBUS_SUCCESS or GLOBUS_FALSE
     */
    globus_result_t dmutils_gridftp_make_dir(
            char* dir,
            char *errbuf,
            int errbufsz,
            int timeout);


    /**
     * dmutils_gridftp_get_filesize
     * Retrieve the size of a file using gridftp. 
     * Required parameters: All
     * Optional paramaters: None
     * @return GLOBUS_SUCCESS or GLOBUS_FALSE
     */
    globus_result_t dmutils_gridftp_get_filesize(
            char const* file,
            globus_off_t* size,
            char* errbuf,
            int errbufsz,
            int timeout);

    /**
     * dmutils_gridftp_checksum
     * Checksum using GridFTP. 
     * Required parameters: All
     * Optional paramaters: None
     * @return GLOBUS_SUCCESS or GLOBUS_FALSE
     */
    globus_result_t dmutils_gridftp_checksum(
            char const* file,
            char* cksm,
            char const* cksm_alg,
            char* errbuf,
            int errbufsz,
            int timeout);

    /**
     * dmutils_gridftp_copy
     * Copy a file using GridFTP. 
     * Required parameters: All
     * Optional paramaters: none
     * @return GLOBUS_SUCCESS or GLOBUS_FALSE
     */
    globus_result_t dmutils_gridftp_copy(
            const char* source_url,
            const char* dest_url,
            char *errbuf,
            int errbufsz,
            int timeout,
            int const nbstreams,
            int const tcp_bs,
            int const block_size,
            int verbose,
            globus_gass_copy_handle_t *ggc_handle,
            void (*ggc_callback)(void *callback_arg, globus_gass_copy_handle_t *handle, globus_object_t *error),
            void * monitor_external,
            void (*globus_gass_copy_performance_cb_t_etx)(void *user_arg,
            globus_gass_copy_handle_t *handle,
            globus_off_t total_bytes,
            float instantaneous_throughput,
            float avg_throughput),
            void * check_external,
	    int (*gridftp_copy_wait)(void * monitor, void * check, globus_gass_copy_handle_t *gfhp, int const timeout, void * iupdater),
	    void * iupdater);


globus_result_t check_if_exists_delete(
        char const* file,
        char* errbuf,
        int errbufsz,
        int timeout);

    /**
     * dmutils_gridftp_error_to_string
     * Delete a file using gridftp. 
     * Required parameters: globus_object_t* errobj)
     * Optional paramaters: none
     * @return the string representation of globus_error
     */
    char* dmutils_gridftp_error_to_string(
            globus_object_t* errobj);


    void do_globus_activates(void);

    void do_globus_deactivates(void);

#ifdef __cplusplus
}
#endif

#endif
