#ifndef GLITE_LB_JOBSTAT_H
#define GLITE_LB_JOBSTAT_H

/*!
 * \file jobstat.h  
 * \brief edg_wll_JobStat definition and related stuff
 */

#ident "$Header: /cvs/glite/org.glite.lb.common/interface/jobstat.h.T,v 1.21 2013/01/25 15:17:22 valtri Exp $"
/*
Copyright (c) Members of the EGEE Collaboration. 2004-2010.
See http://www.eu-egee.org/partners for details on the copyright holders.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

/* 

  !! Automatically generated file
  !! Do not edit, your changes will be discarded upon build
  !! Change the corresponding template file ./interface/jobstat.h.T

*/

#include <sys/time.h>

#include "glite/jobid/cjobid.h"
#include "glite/lb/lb_types.h"

#ifdef __cplusplus
extern "C" {
#endif

/**
 * \defgroup jobstatus Job Status
 * \brief Job status structure definition and related definitions.
 *@{
 */

/**
 * Miscelaneous job status numeric codes
 */

enum edg_wll_StatJobtype {
	EDG_WLL_STAT_SIMPLE,		/**< simple job */
	EDG_WLL_STAT_DAG,		/**< composite job */
	EDG_WLL_STAT__PARTITIONABLE_UNUSED,		/**< placholder for unused code */
	EDG_WLL_STAT__PARTITIONED_UNUSED,		/**< placholder for unused code */
	EDG_WLL_STAT_COLLECTION,		/**< parent of collection of jobs */
	EDG_WLL_STAT_PBS,		/**< PBS job */
	EDG_WLL_STAT_CONDOR,		/**< Condor job */
	EDG_WLL_STAT_CREAM,		/**< CREAM job */
	EDG_WLL_STAT_FILE_TRANSFER_COLLECTION,		/**< job containing all file transfers (i.e. sandbox) */
	EDG_WLL_STAT_FILE_TRANSFER,		/**< subjob holding one file transfer */
	EDG_WLL_STAT_VIRTUAL_MACHINE,		/**< job representing virtual machine */
	EDG_WLL_NUMBER_OF_JOBTYPES	/**< Number of Jobtypes */
};

extern char     *edg_wll_StatusJobtypeNames[];
enum edg_wll_StatJobtype edg_wll_JobtypeStrToCode(const char *in);

enum edg_wll_StatDone_code {
	EDG_WLL_STAT_OK,		/**< Finished correctly */
	EDG_WLL_STAT_FAILED,		/**< Execution failed */
	EDG_WLL_STAT_CANCELLED,		/**< Cancelled by user */
	EDG_WLL_NUMBER_OF_DONE_CODES	/**< Number of Done_codes */
};

extern char     *edg_wll_StatusDone_codeNames[];
enum edg_wll_StatDone_code edg_wll_Done_codeStrToCode(const char *in);

enum edg_wll_StatSandbox_retrieved {
	EDG_WLL_STAT_NOTYET,		/**< Sandbox was not retrieved yet. */
	EDG_WLL_STAT_USER,		/**< User retrieved output sandbox. */
	EDG_WLL_STAT_TIMEOUT,		/**< Timed out, resource forced purge of the sandbox. */
	EDG_WLL_STAT_NOOUTPUT,		/**< No output was generated. */
	EDG_WLL_NUMBER_OF_SANDBOX_RETRIEVEDS	/**< Number of Sandbox_retrieveds */
};

extern char     *edg_wll_StatusSandbox_retrievedNames[];
enum edg_wll_StatSandbox_retrieved edg_wll_Sandbox_retrievedStrToCode(const char *in);

enum edg_wll_StatJw_status {
	EDG_WLL_STAT_UNKNOWN,		/**< Status of JW unknown */
	EDG_WLL_STAT_WRAPPER_RUNNING,		/**< Wrapper started */
	EDG_WLL_STAT_PAYLOAD_RUNNING,		/**< Payload running */
	EDG_WLL_STAT_DONE,		/**< JW finished */
	EDG_WLL_NUMBER_OF_JW_STATUSS	/**< Number of Jw_statuss */
};

extern char     *edg_wll_StatusJw_statusNames[];
enum edg_wll_StatJw_status edg_wll_Jw_statusStrToCode(const char *in);

enum edg_wll_StatCream_state {
	EDG_WLL_STAT_CREAM_REGISTERED,		/**< registered */
	EDG_WLL_STAT_CREAM_PENDING,		/**< pending */
	EDG_WLL_STAT_CREAM_IDLE,		/**< idle */
	EDG_WLL_STAT_CREAM_RUNNING,		/**< running */
	EDG_WLL_STAT_CREAM_REALLY_RUNNING,		/**< really-running */
	EDG_WLL_STAT_CREAM_HELD,		/**< held */
	EDG_WLL_STAT_CREAM_DONE_OK,		/**< done-ok */
	EDG_WLL_STAT_CREAM_DONE_FAILED,		/**< done-failed */
	EDG_WLL_STAT_CREAM_ABORTED,		/**< aborted */
	EDG_WLL_STAT_CREAM_CANCELLED,		/**< cancelled */
	EDG_WLL_STAT_CREAM_PURGED,		/**< purged */
	EDG_WLL_NUMBER_OF_CREAM_STATES	/**< Number of Cream_states */
};

extern char     *edg_wll_StatusCream_stateNames[];
enum edg_wll_StatCream_state edg_wll_Cream_stateStrToCode(const char *in);

enum edg_wll_StatFt_sandbox_type {
	EDG_WLL_STAT_INPUT,		/**< input */
	EDG_WLL_STAT_OUTPUT,		/**< output */
	EDG_WLL_NUMBER_OF_FT_SANDBOX_TYPES	/**< Number of Ft_sandbox_types */
};

extern char     *edg_wll_StatusFt_sandbox_typeNames[];
enum edg_wll_StatFt_sandbox_type edg_wll_Ft_sandbox_typeStrToCode(const char *in);

enum edg_wll_StatVm_state {
	EDG_WLL_STAT_VM_PENDING,		/**< pending */
	EDG_WLL_STAT_VM_BOOT,		/**< boot */
	EDG_WLL_STAT_VM_RUNNING,		/**< running */
	EDG_WLL_STAT_VM_REALLY_RUNNING,		/**< really running */
	EDG_WLL_STAT_VM_SHUTDOWN,		/**< shutdown */
	EDG_WLL_STAT_VM_STOPPED,		/**< stopped */
	EDG_WLL_STAT_VM_DONE,		/**< done */
	EDG_WLL_STAT_VM_FAILURE,		/**< failure */
	EDG_WLL_NUMBER_OF_VM_STATES	/**< Number of Vm_states */
};

extern char     *edg_wll_StatusVm_stateNames[];
enum edg_wll_StatVm_state edg_wll_Vm_stateStrToCode(const char *in);



/*!
 *
 * Job status numeric code
 */

typedef enum _edg_wll_JobStatCode {
/** Indicates invalid edg_wll_JobStat structure */
	EDG_WLL_JOB_UNDEF = 0,
	EDG_WLL_JOB_SUBMITTED,	/**< Entered by the user to the User Interface or registered by Job Partitioner. */
	EDG_WLL_JOB_WAITING,	/**< Accepted by WMS, waiting for resource allocation. */
	EDG_WLL_JOB_READY,	/**< Matching resources found. */
	EDG_WLL_JOB_SCHEDULED,	/**< Accepted by LRMS queue. */
	EDG_WLL_JOB_RUNNING,	/**< Executable is running. */
	EDG_WLL_JOB_DONE,	/**< Execution finished, output is available. */
	EDG_WLL_JOB_CLEARED,	/**< Output transfered back to user and freed. */
	EDG_WLL_JOB_ABORTED,	/**< Aborted by system (at any stage). */
	EDG_WLL_JOB_CANCELLED,	/**< Cancelled by user. */
	EDG_WLL_JOB_UNKNOWN,	/**< Status cannot be determined. */
	EDG_WLL_JOB_PURGED,	/**< Job has been purged from bookkeeping server (for LB-RGMA interface). */
	EDG_WLL_NUMBER_OF_STATCODES /**< Number of meaningful status codes */
} edg_wll_JobStatCode;

extern const int EDG_WLL_JOB_TERMINAL_STATE[EDG_WLL_NUMBER_OF_STATCODES];


/*!
 *
 * Description of the job status.
 * Returned by the edg_wll_JobStatus() function
 */

struct _pad_JobStatus_0_dont_use { edg_wll_JobStatCode state;glite_jobid_t jobId; char * owner; int jobtype; glite_jobid_t parent_job; char * seed; int children_num; char ** children; int * children_hist; struct _edg_wll_JobStat * children_states; char * condorId; char * globusId; char * localId; char * jdl; char * matched_jdl; char * destination; char * condor_jdl; char * rsl; char * reason; char * location; char * ce_node; char * network_server; int subjob_failed; int done_code; int exit_code; int resubmitted; int cancelling; char * cancelReason; int cpuTime; edg_wll_TagValue * user_tags; struct timeval stateEnterTime; struct timeval lastUpdateTime; int * stateEnterTimes; int expectUpdate; char * expectFrom; char * acl; int payload_running; char ** possible_destinations; char ** possible_ce_nodes; int suspended; char * suspend_reason; char * failure_reasons; int remove_from_proxy; char * ui_host; char ** user_fqans; int sandbox_retrieved; int jw_status; void * jdl_classad; glite_jobid_t isb_transfer; glite_jobid_t osb_transfer; char * payload_owner; char * access_rights; char * history;  };
struct _pad_JobStatus_1_dont_use { char * pbs_state; int pbs_substate; char * pbs_queue; char * pbs_owner; char * pbs_name; char * pbs_reason; char * pbs_scheduler; char * pbs_dest_host; int pbs_pid; edg_wll_TagValue * pbs_resource_requested; edg_wll_TagValue * pbs_resource_usage; int pbs_exit_status; char * pbs_error_desc;  };
struct _pad_JobStatus_2_dont_use { char * condor_status; char * condor_universe; char * condor_owner; char * condor_preempting; int condor_shadow_pid; int condor_shadow_exit_status; int condor_starter_pid; int condor_starter_exit_status; int condor_job_pid; int condor_job_exit_status; char * condor_dest_host; char * condor_reason; char * condor_error_desc;  };
struct _pad_JobStatus_3_dont_use { int cream_state; char * cream_id; char * cream_owner; char * cream_endpoint; char * cream_jdl; char * cream_reason; char * cream_failure_reason; char * cream_lrms_id; char * cream_node; int cream_done_code; int cream_exit_code; int cream_cancelling; int cream_cpu_time; int cream_jw_status;  };
struct _pad_JobStatus_4_dont_use { glite_jobid_t ft_compute_job; int ft_sandbox_type; char * ft_src; char * ft_dest;  };
struct _pad_JobStatus_5_dont_use { int vm_state; char * vm_image; char * vm_require; char * vm_usage; char * vm_hostname; char * vm_machine; char * vm_id; char * vm_name; char * vm_phy_hostname; int vm_system_halting; char * vm_manager;  };

typedef struct _edg_wll_JobStat {
	edg_wll_JobStatCode	state;	        /**< status code */
	glite_jobid_t	jobId;	/**< Id of the job */
	char *	owner;	/**< Job owner */
	enum edg_wll_StatJobtype	jobtype;	/**< Type of job */
	glite_jobid_t	parent_job;	/**< parent job of subjob */
	char *	seed;	/**< string used for generation of subjob IDs */
	int	children_num;	/**< number of subjobs */
	char **	children;	/**< list of subjob IDs */
	int *	children_hist;	/**< summary (histogram) of children job states */
	struct _edg_wll_JobStat *	children_states;	/**< full status information of the children */
	char *	condorId;	/**< Id within Condor-G */
	char *	globusId;	/**< Globus allocated Id */
	char *	localId;	/**< Id within LRMS */
	char *	jdl;	/**< User submitted job description */
	char *	matched_jdl;	/**< Full job description after matchmaking */
	char *	destination;	/**< ID of CE where the job is being sent */
	char *	condor_jdl;	/**< ClassAd passed to Condor-G for last job execution */
	char *	rsl;	/**< Job RSL sent to Globus */
	char *	reason;	/**< Reason of being in this status, if any */
	char *	location;	/**< Where the job is being processed */
	char *	ce_node;	/**< Worker node where the job is executed */
	char *	network_server;	/**< Network server handling the job */
	int	subjob_failed;	/**< Subjob failed (the parent job will fail too) */
	enum edg_wll_StatDone_code	done_code;	/**< Return code */
	int	exit_code;	/**< Unix exit code */
	int	resubmitted;	/**< The job was resubmitted */
	int	cancelling;	/**< Cancellation request in progress */
	char *	cancelReason;	/**< Reason of cancel */
	int	cpuTime;	/**< Consumed CPU time */
	edg_wll_TagValue *	user_tags;	/**< List of pairs (user_tag, user_value) */
	struct timeval	stateEnterTime;	/**< When entered this status */
	struct timeval	lastUpdateTime;	/**< Last known event of the job */
	int *	stateEnterTimes;	/**< When all previous states were entered */
	int	expectUpdate;	/**< Some logged information has not arrived yet */
	char *	expectFrom;	/**< Sources of the missing information */
	char *	acl;	/**< ACL of the job */
	int	payload_running;	/**< User payload started */
	char **	possible_destinations;	/**< Possible job destinations */
	char **	possible_ce_nodes;	/**< CE nodes matching to possible_destinations */
	int	suspended;	/**< Job is suspended */
	char *	suspend_reason;	/**< Reason for the suspend */
	char *	failure_reasons;	/**< Concatenated job failure reasons, possibly from deeper middleware layers */
	int	remove_from_proxy;	/**< Job reached final status and may be removed from proxy */
	char *	ui_host;	/**< Hostname or address of UI used to submit the job */
	char **	user_fqans;	/**< FQAN used to register the job */
	enum edg_wll_StatSandbox_retrieved	sandbox_retrieved;	/**< Flag is set on incomming Clear event */
	enum edg_wll_StatJw_status	jw_status;	/**< Status of Job wrapper */
	void *	jdl_classad;	/**< Unparsed JDL classad */
	glite_jobid_t	isb_transfer;	/**< Input sandbox corresponding to the job */
	glite_jobid_t	osb_transfer;	/**< Output sandbox corresponding to the job */
	char *	payload_owner;	/**< Owner of the actual job payload (e.g., for pilot jobs) */
	char *	access_rights;	/**< List of access rights (human readable variant of acl) */
	char *	history;	/**< Job history. */

	char	_pad_0[sizeof(void *) * 55 - sizeof(struct _pad_JobStatus_0_dont_use)];

	char *	pbs_state;	/**< Job state which would probably return PBS qstat (Q/R/C/....) */
	int	pbs_substate;	/**< Job substate */
	char *	pbs_queue;	/**< Name of queue in which is job queued */
	char *	pbs_owner;	/**< Owner of job */
	char *	pbs_name;	/**< Name of job */
	char *	pbs_reason;	/**< Glued reasons/errors leading to pending events */
	char *	pbs_scheduler;	/**< Name of pbs scheduler */
	char *	pbs_dest_host;	/**< Hostname of node where job is running */
	int	pbs_pid;	/**< PID of running job */
	edg_wll_TagValue *	pbs_resource_requested;	/**< Resources requested */
	edg_wll_TagValue *	pbs_resource_usage;	/**< Resource usage */
	int	pbs_exit_status;	/**< Job exit status */
	char *	pbs_error_desc;	/**< Glued error descriptions from error events */

	char	_pad_1[sizeof(void *) * 20 - sizeof(struct _pad_JobStatus_1_dont_use)];

	char *	condor_status;	/**< Condor job status  */
	char *	condor_universe;	/**< Condor job Universe (in job ClassAds) */
	char *	condor_owner;	/**< Job owner */
	char *	condor_preempting;	/**< Job preempting */
	int	condor_shadow_pid;	/**< PID of Shadow */
	int	condor_shadow_exit_status;	/**< Condor shadow exit status (see h/exit.h) */
	int	condor_starter_pid;	/**< PID of Starter */
	int	condor_starter_exit_status;	/**< Condor starter exit status */
	int	condor_job_pid;	/**< PID of running job */
	int	condor_job_exit_status;	/**< Job exit status */
	char *	condor_dest_host;	/**< Hostname of node where job is running */
	char *	condor_reason;	/**< Glued reasons/errors leading to pending events */
	char *	condor_error_desc;	/**< Glued error descriptions from error events */

	char	_pad_2[sizeof(void *) * 25 - sizeof(struct _pad_JobStatus_2_dont_use)];

	enum edg_wll_StatCream_state	cream_state;	/**< CREAM job state */
	char *	cream_id;	/**< CREAM local job id */
	char *	cream_owner;	/**< Job owner */
	char *	cream_endpoint;	/**< Address of the CREAM service */
	char *	cream_jdl;	/**< JDL passed to the CREAM */
	char *	cream_reason;	/**< Reason of the state or command */
	char *	cream_failure_reason;	/**< Reason of any failure */
	char *	cream_lrms_id;	/**< LRMS local id */
	char *	cream_node;	/**< Worker node where the job is executed */
	int	cream_done_code;	/**< Job done code, uses done_code enum */
	int	cream_exit_code;	/**< Job exit code */
	int	cream_cancelling;	/**< Cancellation request in process */
	int	cream_cpu_time;	/**< Consumed CPU time */
	int	cream_jw_status;	/**< Users jw_status enum */

	char	_pad_3[sizeof(void *) * 30 - sizeof(struct _pad_JobStatus_3_dont_use)];

	glite_jobid_t	ft_compute_job;	/**< Compute job corresponding to file transfer */
	enum edg_wll_StatFt_sandbox_type	ft_sandbox_type;	/**< Type of sandbox */
	char *	ft_src;	/**< File transfer source */
	char *	ft_dest;	/**< File transfer destination */

	char	_pad_4[sizeof(void *) * 20 - sizeof(struct _pad_JobStatus_4_dont_use)];

	enum edg_wll_StatVm_state	vm_state;	/**< VM job state */
	char *	vm_image;	/**< VM image */
	char *	vm_require;	/**< VM requirement on physical machine */
	char *	vm_usage;	/**< VM usage */
	char *	vm_hostname;	/**< VM hostname */
	char *	vm_machine;	/**< physical machine on which VM runs */
	char *	vm_id;	/**< VM id */
	char *	vm_name;	/**< VM name */
	char *	vm_phy_hostname;	/**< hostname of physical machine running VM */
	int	vm_system_halting;	/**< system is shooting down */
	char *	vm_manager;	/**< name of the VM manager */

	char	_pad_5[sizeof(void *) * 20 - sizeof(struct _pad_JobStatus_5_dont_use)];


} edg_wll_JobStat;

/**
 * \name edg_wll_JobStat manipulation
 */


/**
 * Bitmasks for edg_wll_JobStatus() flags argument.
 * Settings these flags causes the status calls to retrieve additional
 * information.
 */
#define EDG_WLL_STAT_CLASSADS	1	/**< various job description fields */
#define EDG_WLL_STAT_CHILDREN	2	/**< list of subjob JobId's */
#define EDG_WLL_STAT_CHILDSTAT	4	/**< apply the flags recursively to subjobs */
#define EDG_WLL_STAT_CHILDHIST_FAST 8		/**< partially complete histogram of child job states */
#define EDG_WLL_STAT_CHILDHIST_THOROUGH 16	/**< full and up-to date histogram of child job states */
#define EDG_WLL_NOTIF_ANONYMIZE	32	/**< Always return user identity anonymized */
#define EDG_WLL_NOTIF_TERMINAL_STATES 64	/**< Generate notifications on terminal states */
#define EDG_WLL_NOTIF_HISTORY 128	/**< Attach all job's events to the notification */
#define EDG_WLL_NOTIF_BOOTSTRAP 256	/**< send the state of the all already existing jobs too */
#define EDG_WLL_NOTIF_VOLATILE 512	/**< (not used yet) send the notifications directly, without reliability and persistency */
/* starting from bit 10 private flags begins - do not add 1024 and more! */

/**
 * Type (status) of an inter-job relationship
**/
typedef enum _edg_wll_JobConnectionType {
        EDG_WLL_JOBCONNECTION_UNDEFINED,
        EDG_WLL_JOBCONNECTION_ACTIVE,
        EDG_WLL_JOBCONNECTION_INACTIVE,
        EDG_WLL_JOBCONNECTION_CANCELLED
} edg_wll_JobConnectionType;

extern char *edg_wll_JobConnectionTypeNames[];

/**
 * Structured type for expressing inter-job relationships
**/
typedef struct _edg_wll_RelationshipRecord {
	glite_jobid_t			jobid;		/* JobID of the related job */
	enum edg_wll_StatJobtype	jobtype;	/* Type of the related job */
	edg_wll_JobConnectionType	reltype;	/* Type (status) of the relationship */
} edg_wll_RelationshipRecord;



/**
 * Initialize empty status structure.
 * Fills in the stucture with NULL's or values with no meaning
 */
 
extern int edg_wll_InitStatus(edg_wll_JobStat *);

/**
 * Initialize dest structure and copy source status to this destination
 */
 
extern edg_wll_JobStat *edg_wll_CpyStatus(const edg_wll_JobStat *,edg_wll_JobStat *);

/** 
 * Free status structure contents.
 * \warning The structure itself is not freed.
 */
extern void edg_wll_FreeStatus(edg_wll_JobStat *);

/**
 * Convert string job status to numeric code.
 */
extern edg_wll_JobStatCode edg_wll_StringToStat(const char *);

/** 
 * Convert numeric job status code to string representation
 */
extern char *edg_wll_StatToString(edg_wll_JobStatCode);

/**
 * Convert string Job Wrapper status to numeric code.
 */
extern enum edg_wll_StatJw_status edg_wll_StringToJWStat(const char *);

/** 
 * Convert numeric Job Wrapper status code to string representation
 */
extern char *edg_wll_JWStatToString(enum edg_wll_StatJw_status);

/**
 * Convert string CREAM status to numeric code.
 */
extern enum edg_wll_StatCream_state edg_wll_StringToCreamStat(const char *name);

/** 
 * Convert numeric CREAM status code to string representation
 */
extern char *edg_wll_CreamStatToString(enum edg_wll_StatCream_state);

/**
 * Convert numeric VM status code to string representation
 */
extern char *edg_wll_VMStatToString(enum edg_wll_StatVm_state);

/**
 * Convert string VM status to numeric code
 */
extern enum edg_wll_StatVm_state edg_wll_StringToVMStat(const char* name);

/** 
 * Extract a variable from the JDL attribute 
 */
extern char *edg_wll_JDLField(edg_wll_JobStat *stat, const char *field_name);

/*@}*/

/*
 *@} end of group
 */

#ifdef __cplusplus
}
#endif

#endif /* GLITE_LB_JOBSTAT_H */
