#ifndef GLITE_LB_EVENTS_H
#define GLITE_LB_EVENTS_H

/**
 * \file events.h
 * \brief contains definition of event types
 */

#ident "$Header: /cvs/glite/org.glite.lb.common/interface/events.h.T,v 1.24 2013/01/25 15:17:22 valtri Exp $"
/*
Copyright (c) Members of the EGEE Collaboration. 2004-2010.
See http://www.eu-egee.org/partners for details on the copyright holders.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

/*

  !! Automatically generated file
  !! Do not edit, your changes will be discarded upon build
  !! Change the corresponding template file ./interface/events.h.T

*/

#include <sys/time.h>
#include <inttypes.h>

#include "glite/jobid/cjobid.h"
#include "glite/lb/lb_types.h"


#ifdef BUILDING_LB_COMMON
#include "context.h"
#include "notifid.h"
#include "padstruct.h"
#else
#include "glite/lb/context.h"
#include "glite/lb/notifid.h"
#include "glite/lb/padstruct.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

/**
 * \defgroup events Events
 * \brief All L&B event types.
 *
 *@{
 */

/**
 * Predefined type for ULM string 
 */
typedef char *edg_wll_LogLine;

enum edg_wll_CREAMCommand {
	EDG_WLL_CREAM_CMD_UNDEFINED = 0,
	EDG_WLL_CREAM_CMD_START = 0,
	EDG_WLL_CREAM_CMD_CANCEL = 0,
	EDG_WLL_CREAM_CMD_PURGE = 0,
	EDG_WLL_CREAM_CMD_SUSPEND = 0,
	EDG_WLL_CREAM_CMD_RESUME = 0,
};

/**
 * \typedef edg_wll_EventCode
 * Predefined event types 
 */
typedef enum _edg_wll_EventCode {
/** invalid code, e.g. uninitialized variable */
        EDG_WLL_EVENT_UNDEF = 0,
	EDG_WLL_EVENT_TRANSFER = 1,	/**< Start, success, or failure of job transfer to another component. */
	EDG_WLL_EVENT_ACCEPTED = 2,	/**< Accepting job (successful counterpart to Transfer). */
	EDG_WLL_EVENT_REFUSED = 3,	/**< Refusing job (unsuccessful counterpart to Transfer). */
	EDG_WLL_EVENT_ENQUEUED = 4,	/**< The job has been enqueued in an inter-component queue. */
	EDG_WLL_EVENT_DEQUEUED = 5,	/**< The job has been dequeued from an inter-component queue. */
	EDG_WLL_EVENT_HELPERCALL = 6,	/**< Helper component is called. */
	EDG_WLL_EVENT_HELPERRETURN = 7,	/**< Helper component is returning the control. */
	EDG_WLL_EVENT_RUNNING = 8,	/**< Job wrapper started. */
	EDG_WLL_EVENT_RESUBMISSION = 9,	/**< Result of resubmission decision. */
	EDG_WLL_EVENT_DONE = 10,	/**< Execution terminated (normally or abnormally). */
	EDG_WLL_EVENT_CANCEL = 11,	/**< Cancel operation has been attempted on the job. */
	EDG_WLL_EVENT_ABORT = 12,	/**< Job aborted by system. */
	EDG_WLL_EVENT_CLEAR = 13,	/**< Job cleared, output sandbox removed */
	EDG_WLL_EVENT_PURGE = 14,	/**< Job is purged from bookkepping server. */
	EDG_WLL_EVENT_MATCH = 15,	/**< Matching CE found. */
	EDG_WLL_EVENT_PENDING = 16,	/**< No matching CE found yet. */
	EDG_WLL_EVENT_REGJOB = 17,	/**< New job registration. */
	EDG_WLL_EVENT_CHKPT = 18,	/**< Application-specific checkpoint record. */
	EDG_WLL_EVENT_LISTENER = 19,	/**< Listening network port for interactive control. */
	EDG_WLL_EVENT_CURDESCR = 20,	/**< Current state of job processing (optional event). */
	EDG_WLL_EVENT_USERTAG = 21,	/**< User tag -- arbitrary name=value pair. */
	EDG_WLL_EVENT_CHANGEACL = 22,	/**< Management of ACL stored on bookkepping server. */
	EDG_WLL_EVENT_NOTIFICATION = 23,	/**< Management of notification service. */
	EDG_WLL_EVENT_RESOURCEUSAGE = 24,	/**< Resource (CPU, memory etc.) consumption. */
	EDG_WLL_EVENT_REALLYRUNNING = 25,	/**< User payload started. */
	EDG_WLL_EVENT_SUSPEND = 26,	/**< Job execution (queuing) was suspended. */
	EDG_WLL_EVENT_RESUME = 27,	/**< Job execution (queuing) was resumed. */
	EDG_WLL_EVENT_COLLECTIONSTATE = 28,	/**< State of the collection. */
	EDG_WLL_EVENT_GRANTPAYLOADOWNERSHIP = 29,	/**< Hand over ownership of actual job payload (e.g. of a pilot job) */
	EDG_WLL_EVENT_TAKEPAYLOADOWNERSHIP = 30,	/**< Take over ownership of actual job payload */
	EDG_WLL_EVENT_CONNECTJOB = 31,	/**< Connect two jobs */
	EDG_WLL_EVENT_DISCONNECTJOB = 32,	/**< Disconnect two jobs */
/* new flesh PBS */
	EDG_WLL_EVENT_PBSINTERNALSTATECHANGE = 101,	/**< Change of internal PBS job state */
	EDG_WLL_EVENT_PBSTRANSFER = 102,	/**< Start, success, or failure of job transfer to another component. */
	EDG_WLL_EVENT_PBSACCEPTED = 103,	/**< Accepting job (successful counterpart to Transfer). */
	EDG_WLL_EVENT_PBSREFUSED = 104,	/**< Refusing job (unsuccessful counterpart to Transfer). */
	EDG_WLL_EVENT_PBSQUEUED = 105,	/**< Job enqued */
	EDG_WLL_EVENT_PBSDEQUEUED = 106,	/**< Job dequeued */
	EDG_WLL_EVENT_PBSMATCH = 107,	/**< Scheduler created exec host */
	EDG_WLL_EVENT_PBSPENDING = 108,	/**< Scheduler is not able to find exec host, or some error occured */
	EDG_WLL_EVENT_PBSWAITING = 109,	/**< Job is waiting for some condition */
	EDG_WLL_EVENT_PBSRUN = 110,	/**< Job attempted to be run by the logging component */
	EDG_WLL_EVENT_PBSRERUN = 111,	/**< Job rerun requested */
	EDG_WLL_EVENT_PBSABORT = 112,	/**< Job aborted */
	EDG_WLL_EVENT_PBSDONE = 113,	/**< Job terminated */
	EDG_WLL_EVENT_PBSRESOURCEUSAGE = 114,	/**< Resources requested/consumed */
	EDG_WLL_EVENT_PBSERROR = 115,	/**< Any error occured */
/* new flesh Condor */
	EDG_WLL_EVENT_CONDORMATCH = 201,	/**< Job MATCHed */
	EDG_WLL_EVENT_CONDORREJECT = 202,	/**< Job REJECTed */
	EDG_WLL_EVENT_CONDORSHADOWSTARTED = 203,	/**< Condor Shadow Started */
	EDG_WLL_EVENT_CONDORSHADOWEXITED = 204,	/**< Condor Shadow Exited */
	EDG_WLL_EVENT_CONDORSTARTERSTARTED = 205,	/**< Condor Starter Started */
	EDG_WLL_EVENT_CONDORSTARTEREXITED = 206,	/**< Condor Starter Exited */
	EDG_WLL_EVENT_CONDORRESOURCEUSAGE = 207,	/**< Resources requested/consumed */
	EDG_WLL_EVENT_CONDORERROR = 208,	/**< Any Error occured */
/* new flesh CREAM */
	EDG_WLL_EVENT_CREAMSTART = 301,	/**< Start processing registered job */
	EDG_WLL_EVENT_CREAMPURGE = 302,	/**< Purge request (by user) */
	EDG_WLL_EVENT_CREAMACCEPTED = 303,	/**< Accepting job (successful counterpart to Transfer). */
	EDG_WLL_EVENT_CREAMSTORE = 304,	/**<  */
	EDG_WLL_EVENT_CREAMCALL = 305,	/**< Processing command and calling BLAH or LRMS */
	EDG_WLL_EVENT_CREAMRUNNING = 306,	/**<  */
	EDG_WLL_EVENT_CREAMREALLYRUNNING = 307,	/**<  */
	EDG_WLL_EVENT_CREAMDONE = 308,	/**<  */
	EDG_WLL_EVENT_CREAMCANCEL = 309,	/**<  */
	EDG_WLL_EVENT_CREAMABORT = 310,	/**<  */
	EDG_WLL_EVENT_CREAMSTATUS = 311,	/**<  */
	EDG_WLL_EVENT_CREAMSUSPEND = 312,	/**< Job execution (queuing) was suspended. */
	EDG_WLL_EVENT_CREAMRESUME = 313,	/**< Job execution (queuing) was resumed. */
/* new flesh Transfer */
	EDG_WLL_EVENT_FILETRANSFERREGISTER = 401,	/**< register file transfer */
	EDG_WLL_EVENT_FILETRANSFER = 402,	/**< transfer job logs progress */
	EDG_WLL_EVENT_SANDBOX = 403,	/**< event for logging relationship between (compute) job and (file) transfer job */
/* new flesh VirtualMachine */
	EDG_WLL_EVENT_VMCREATE = 501,	/**< create (register) virtual machine */
	EDG_WLL_EVENT_VMHOST = 502,	/**<  */
	EDG_WLL_EVENT_VMIMAGE = 503,	/**<  */
	EDG_WLL_EVENT_VMRUNNING = 504,	/**< VM is running */
	EDG_WLL_EVENT_VMSHUTDOWN = 505,	/**<  */
	EDG_WLL_EVENT_VMSTOP = 506,	/**<  */
	EDG_WLL_EVENT_VMRESUME = 507,	/**<  */
	EDG_WLL_EVENT_VMDONE = 508,	/**<  */
        EDG_WLL_EVENT__LAST,	/**< last currently supported event code */
} edg_wll_EventCode;

/**
 * \fn edg_wll_EventCode edg_wll_StringToEvent(const char *name)
 * \param[in] name		a string event name (e.g. "JobTransfer")
 * \return corresponding numeric code (edg_wll_EventCode)
 * \brief convert a string event name to the corresponding numeric code
 */

extern edg_wll_EventCode edg_wll_StringToEvent(const char *name);

/**
 * \fn char *edg_wll_EventToString(edg_wll_EventCode event)
 * \param[in] event		an event numeric code (edg_wll_EventCode)
 * \return corresponding string (e.g. "JobTransfer")
 * \brief convert an event numeric code to the corresponding string
 */

extern char *edg_wll_EventToString(edg_wll_EventCode event);


/**
 * \typedef edg_wll_KeyNameCode
 * Predefined ULM key types
 */
typedef enum _edg_wll_KeyNameCode {
	UNDEFINED = 0,		/**< undefined */
	EDG_WLL_EVNT = 1,		/**< event type */
	ULM_DATE = 2,		/**< Time the event was generated. */
	ULM_ARR_DATE = 3,		/**< Time the event was stored into the bookkeeping server database. */
	ULM_HOST = 4,		/**< Hostname of the machine where the event was generated. */
	ULM_LVL = 5,		/**< Logging level (in the range from DEBUG to EMERGENCY). */
	EDG_WLL_COMMON_PRIORITY = 6,		/**< Message priority (yet 0 for asynchronous and 1 for synchronous transfers). */
	EDG_WLL_COMMON_JOBID = 7,		/**< Grid job id of the job the event belongs to. */
	EDG_WLL_COMMON_SEQCODE = 8,		/**< Sequence code assigned to the event. */
	EDG_WLL_COMMON_USER = 9,		/**< Identity (certificate subject) of the event sender. */
	EDG_WLL_COMMON_SOURCE = 10,		/**< Source (software component) which generated this event. */
	EDG_WLL_COMMON_SRC_INSTANCE = 11,		/**< Instance of source component (e.g. service communication endpoint). */
	EDG_WLL_TRANSFER_DESTINATION = 12,	/**< Destination where the job is being transfered to. */
	EDG_WLL_TRANSFER_DEST_HOST = 13,	/**< Hostname of server that takes over control of the job. */
	EDG_WLL_TRANSFER_DEST_INSTANCE = 14,	/**< Service (instance) that takes over control of the job. */
	EDG_WLL_TRANSFER_JOB = 15,	/**< Job description in receiver's language. */
	EDG_WLL_TRANSFER_RESULT = 16,	/**< Result code of the transfer attempt (START, OK, REFUSED or FAIL). */
	EDG_WLL_TRANSFER_REASON = 17,	/**< Detailed description of the transfer, especially reason of failure. */
	EDG_WLL_TRANSFER_DEST_JOBID = 18,	/**< Job id as assigned by the receiving software component. */
	EDG_WLL_ACCEPTED_FROM = 19,	/**< The software component  the job was received from. */
	EDG_WLL_ACCEPTED_FROM_HOST = 20,	/**< Hostname of the component the job was received from. */
	EDG_WLL_ACCEPTED_FROM_INSTANCE = 21,	/**< Instance of the component the job was received from. */
	EDG_WLL_ACCEPTED_LOCAL_JOBID = 22,	/**< New job id as assigned by the receiving component. */
	EDG_WLL_REFUSED_FROM = 23,	/**< The software component that tried to send the job. */
	EDG_WLL_REFUSED_FROM_HOST = 24,	/**< Hostname of the component that tried to send the job. */
	EDG_WLL_REFUSED_FROM_INSTANCE = 25,	/**< Instance of the component that tried to send the job. */
	EDG_WLL_REFUSED_REASON = 26,	/**< Description of the reason why the job was refused. */
	EDG_WLL_ENQUEUED_QUEUE = 27,	/**< Queue into which the job has been stored for retrieval by another component. */
	EDG_WLL_ENQUEUED_JOB = 28,	/**< Job description in the receiver's language. */
	EDG_WLL_ENQUEUED_RESULT = 29,	/**< Result code of the attempt to put job into the queue (START, OK, REFUSED or FAIL). */
	EDG_WLL_ENQUEUED_REASON = 30,	/**< Detailed description of the attempt to enqueue the job, especially the reason of failure. */
	EDG_WLL_DEQUEUED_QUEUE = 31,	/**< Name of the queue the job was obtained from. */
	EDG_WLL_DEQUEUED_LOCAL_JOBID = 32,	/**< New job id as assigned by the retreiving component. */
	EDG_WLL_HELPERCALL_HELPER_NAME = 33,	/**< Name of the called helper component. */
	EDG_WLL_HELPERCALL_HELPER_PARAMS = 34,	/**< Parameters of the call to the helper component. */
	EDG_WLL_HELPERCALL_SRC_ROLE = 35,	/**< The role the event sender is playing in the helper call (CALLING or CALLEE). */
	EDG_WLL_HELPERRETURN_HELPER_NAME = 36,	/**< Name of the called helper component. */
	EDG_WLL_HELPERRETURN_RETVAL = 37,	/**< Data returned by the call to the helper component. */
	EDG_WLL_HELPERRETURN_SRC_ROLE = 38,	/**< The role the event sender is playing in the helper call (CALLING or CALLEE). */
	EDG_WLL_RUNNING_NODE = 39,	/**< Worker node on which the job executable is being run. */
	EDG_WLL_RESUBMISSION_RESULT = 40,	/**< Result code of the resubmission decision (WILLRESUB or WONTRESUB or SHALLOW). */
	EDG_WLL_RESUBMISSION_REASON = 41,	/**< Reason why the job will or will not be resubmitted. */
	EDG_WLL_RESUBMISSION_TAG = 42,	/**< Value of the attribute on which the decision to resubmit the job was based. */
	EDG_WLL_DONE_STATUS_CODE = 43,	/**< Reason code for the termination of the job (OK, FAILED or CANCELLED). */
	EDG_WLL_DONE_REASON = 44,	/**< Detailed description why the job was terminated. */
	EDG_WLL_DONE_EXIT_CODE = 45,	/**< Exit code of the job's process. */
	EDG_WLL_CANCEL_STATUS_CODE = 46,	/**< Classification of the attempt to cancel the job (REQ, REFUSE, DONE or ABORT). */
	EDG_WLL_CANCEL_REASON = 47,	/**< Detailed description of the attempt to cancel the job, especially the reason of failure. */
	EDG_WLL_ABORT_REASON = 48,	/**< Reason why the job was aborted by the system. */
	EDG_WLL_CLEAR_REASON = 49,	/**< Description of the reason why the job was cleared and the output sandbox removed (USER, TIMEOUT or NOOUTPUT). */
	EDG_WLL_MATCH_DEST_ID = 50,	/**< Identification of the queue on the CE that the job could be send to. */
	EDG_WLL_PENDING_REASON = 51,	/**< Description why the matching CE for the job was not found (yet). */
	EDG_WLL_REGJOB_JDL = 52,	/**< Job description of the job being registered. */
	EDG_WLL_REGJOB_NS = 53,	/**< NetworkServer/CE endpoint etc. handling the newly registered job. */
	EDG_WLL_REGJOB_PARENT = 54,	/**< Grid job id of the parent job registering this new one. */
	EDG_WLL_REGJOB_JOBTYPE = 55,	/**< Type of the job being registered (SIMPLE, DAG, PARTITIONABLE etc.). */
	EDG_WLL_REGJOB_NSUBJOBS = 56,	/**< Number of subjobs this job plans to spawn. */
	EDG_WLL_REGJOB_SEED = 57,	/**< Seed for subjob id generation. */
	EDG_WLL_REGJOB_WMS_DN = 58,	/**< DN of WMS handling the job */
	EDG_WLL_CHKPT_TAG = 59,	/**< Application specific checkpoint tag. */
	EDG_WLL_CHKPT_CLASSAD = 60,	/**< Application specific checkpoint value. */
	EDG_WLL_LISTENER_SVC_NAME = 61,	/**< Name of the port instance for interactive job control. */
	EDG_WLL_LISTENER_SVC_HOST = 62,	/**< Hostname of the interactive job controller. */
	EDG_WLL_LISTENER_SVC_PORT = 63,	/**< Port number of the interactive job controller. */
	EDG_WLL_CURDESCR_DESCR = 64,	/**< Description of the current job transformation (output of the helper). */
	EDG_WLL_USERTAG_NAME = 65,	/**< Arbitrary user tag name. */
	EDG_WLL_USERTAG_VALUE = 66,	/**< Arbitrary user tag value. */
	EDG_WLL_CHANGEACL_USER_ID = 67,	/**< Certificate or VOMS parameter. */
	EDG_WLL_CHANGEACL_USER_ID_TYPE = 68,	/**< Type of information given in user_id. */
	EDG_WLL_CHANGEACL_PERMISSION = 69,	/**< ACL permission to change. */
	EDG_WLL_CHANGEACL_PERMISSION_TYPE = 70,	/**< Type of permission requested. */
	EDG_WLL_CHANGEACL_OPERATION = 71,	/**< Operation requested to perform with ACL. */
	EDG_WLL_NOTIFICATION_NOTIFID = 72,	/**< Notification id. */
	EDG_WLL_NOTIFICATION_OWNER = 73,	/**< Identification of the job owner (certificate subject). */
	EDG_WLL_NOTIFICATION_DEST_HOST = 74,	/**< Hostname the notification is sent to. */
	EDG_WLL_NOTIFICATION_DEST_PORT = 75,	/**< Port number the notification is sent to. */
	EDG_WLL_NOTIFICATION_EXPIRES = 76,	/**< When the notification expires */
	EDG_WLL_NOTIFICATION_JOBSTAT = 77,	/**< Status of the job (the notification content). */
	EDG_WLL_NOTIFICATION_DEST_URL = 78,	/**< Destination URL (preferred over host and port). */
	EDG_WLL_RESOURCEUSAGE_RESOURCE = 79,	/**< Resource's name. */
	EDG_WLL_RESOURCEUSAGE_QUANTITY = 80,	/**< Resources's quantity (how much). */
	EDG_WLL_RESOURCEUSAGE_UNIT = 81,	/**< Units (sec, kB, etc.). */
	EDG_WLL_REALLYRUNNING_WN_SEQ = 82,	/**< Sequence code on the worker node. */
	EDG_WLL_SUSPEND_REASON = 83,	/**< Reason for the suspend. */
	EDG_WLL_RESUME_REASON = 84,	/**< Reason for the resume. */
	EDG_WLL_COLLECTIONSTATE_STATE = 85,	/**< New collection state. */
	EDG_WLL_COLLECTIONSTATE_DONE_CODE = 86,	/**< In case of (state == Done) contains done code  */
	EDG_WLL_COLLECTIONSTATE_HISTOGRAM = 87,	/**< User readable histogram; useful for debugging. */
	EDG_WLL_COLLECTIONSTATE_CHILD = 88,	/**< JobId of subjob, which triggered the state change.	 */
	EDG_WLL_COLLECTIONSTATE_CHILD_EVENT = 89,	/**< Event which triggered the state change.	 */
	EDG_WLL_GRANTPAYLOADOWNERSHIP_PAYLOAD_OWNER = 90,	/**< Identity (certificate subject) of the payload owner. */
	EDG_WLL_CONNECTJOB_DEST_JOBID = 91,	/**< ID of connected job */
	EDG_WLL_CONNECTJOB_JOBTYPE = 92,	/**< Type of the job being connected (SIMPLE, DAG, PARTITIONABLE etc.). */
	EDG_WLL_DISCONNECTJOB_DEST_JOBID = 93,	/**< ID of connected job */
	EDG_WLL_PBSINTERNALSTATECHANGE_OLDSTATE = 94,	/**<  */
	EDG_WLL_PBSINTERNALSTATECHANGE_OLDSUBSTATE = 95,	/**<  */
	EDG_WLL_PBSINTERNALSTATECHANGE_NEWSTATE = 96,	/**<  */
	EDG_WLL_PBSINTERNALSTATECHANGE_NEWSUBSTATE = 97,	/**<  */
	EDG_WLL_PBSTRANSFER_DESTINATION = 98,	/**< Destination where the job is being transfered to. */
	EDG_WLL_PBSTRANSFER_DEST_INSTANCE = 99,	/**< Service (instance) that takes over control of the job. */
	EDG_WLL_PBSTRANSFER_RESULT = 100,	/**< Result code of the transfer attempt (START, OK, REFUSED or FAIL). */
	EDG_WLL_PBSTRANSFER_REASON = 101,	/**< Detailed description of the transfer, especially reason of failure. */
	EDG_WLL_PBSTRANSFER_DEST_JOBID = 102,	/**< Job id as assigned by the receiving software component. */
	EDG_WLL_PBSACCEPTED_FROM = 103,	/**< The software component  the job was received from. */
	EDG_WLL_PBSACCEPTED_FROM_INSTANCE = 104,	/**< Instance of the component the job was received from. */
	EDG_WLL_PBSACCEPTED_LOCAL_JOBID = 105,	/**< New job id as assigned by the receiving component. */
	EDG_WLL_PBSREFUSED_FROM = 106,	/**< The software component that tried to send the job. */
	EDG_WLL_PBSREFUSED_FROM_INSTANCE = 107,	/**< Instance of the component that tried to send the job. */
	EDG_WLL_PBSREFUSED_REASON = 108,	/**< Description of the reason why the job was refused. */
	EDG_WLL_PBSQUEUED_QUEUE = 109,	/**< Queue name */
	EDG_WLL_PBSQUEUED_NAME = 110,	/**< Job name */
	EDG_WLL_PBSQUEUED_OWNER = 111,	/**< Job owner */
	EDG_WLL_PBSMATCH_DEST_HOST = 112,	/**< Aka exec host */
	EDG_WLL_PBSPENDING_REASON = 113,	/**< Reasons of job pendation or errors */
	EDG_WLL_PBSRUN_SCHEDULER = 114,	/**< Scheduler ID */
	EDG_WLL_PBSRUN_DEST_HOST = 115,	/**< Where to run the job */
	EDG_WLL_PBSRUN_PID = 116,	/**< Actual process ID */
	EDG_WLL_PBSDONE_EXIT_STATUS = 117,	/**< Exit status */
	EDG_WLL_PBSRESOURCEUSAGE_USAGE = 118,	/**< Type of record */
	EDG_WLL_PBSRESOURCEUSAGE_RESOURCES = 119,	/**< List of resources */
	EDG_WLL_PBSERROR_ERROR_DESC = 120,	/**< Error reason */
	EDG_WLL_CONDORMATCH_OWNER = 121,	/**< Owner */
	EDG_WLL_CONDORMATCH_DEST_HOST = 122,	/**< Matched host */
	EDG_WLL_CONDORMATCH_PREEMPTING = 123,	/**< Preempting */
	EDG_WLL_CONDORREJECT_OWNER = 124,	/**< Owner */
	EDG_WLL_CONDORREJECT_STATUS_CODE = 125,	/**< Reason code for the rejection of the job */
	EDG_WLL_CONDORSHADOWSTARTED_SHADOW_HOST = 126,	/**< Shadow host */
	EDG_WLL_CONDORSHADOWSTARTED_SHADOW_PORT = 127,	/**< Shadow port */
	EDG_WLL_CONDORSHADOWSTARTED_SHADOW_PID = 128,	/**< PID of shadow process */
	EDG_WLL_CONDORSHADOWSTARTED_SHADOW_STATUS = 129,	/**< Shadow status */
	EDG_WLL_CONDORSHADOWEXITED_SHADOW_PID = 130,	/**< PID of shadow process */
	EDG_WLL_CONDORSHADOWEXITED_SHADOW_EXIT_STATUS = 131,	/**< Exit status of shadow process */
	EDG_WLL_CONDORSTARTERSTARTED_STARTER_PID = 132,	/**< PID of starter process */
	EDG_WLL_CONDORSTARTERSTARTED_UNIVERSE = 133,	/**< Condor Universe */
	EDG_WLL_CONDORSTARTEREXITED_STARTER_PID = 134,	/**< PID of starter process */
	EDG_WLL_CONDORSTARTEREXITED_STARTER_EXIT_STATUS = 135,	/**< Exit status of starter process */
	EDG_WLL_CONDORSTARTEREXITED_JOB_PID = 136,	/**< PID of running job */
	EDG_WLL_CONDORSTARTEREXITED_JOB_EXIT_STATUS = 137,	/**< Job exit status */
	EDG_WLL_CONDORRESOURCEUSAGE_USAGE = 138,	/**< Type of record */
	EDG_WLL_CONDORRESOURCEUSAGE_NAME = 139,	/**< Name of resource */
	EDG_WLL_CONDORRESOURCEUSAGE_QUANTITY = 140,	/**< The quantity */
	EDG_WLL_CONDORRESOURCEUSAGE_UNIT = 141,	/**< Units (sec, kB, etc.) */
	EDG_WLL_CONDORERROR_ERROR_DESC = 142,	/**< Error reason */
	EDG_WLL_CREAMACCEPTED_LOCAL_JOBID = 143,	/**< New job id as assigned by the receiving component. */
	EDG_WLL_CREAMSTORE_COMMAND = 144,	/**< Command to store */
	EDG_WLL_CREAMSTORE_CMDID = 145,	/**< Id of the command in store */
	EDG_WLL_CREAMSTORE_RESULT = 146,	/**< store phase/result */
	EDG_WLL_CREAMSTORE_REASON = 147,	/**< failure_reason */
	EDG_WLL_CREAMCALL_COMMAND = 148,	/**< Command to store */
	EDG_WLL_CREAMCALL_CALLEE = 149,	/**< Called component */
	EDG_WLL_CREAMCALL_CMDID = 150,	/**< Id of the command, as stored previously */
	EDG_WLL_CREAMCALL_DESTID = 151,	/**< Destination ID */
	EDG_WLL_CREAMCALL_RESULT = 152,	/**< Result code of the CREAM call (START, OK, REFUSED or FAIL) */
	EDG_WLL_CREAMCALL_REASON = 153,	/**< Reason for the possible CREAM call failure */
	EDG_WLL_CREAMRUNNING_NODE = 154,	/**< Node where CREAM job is running */
	EDG_WLL_CREAMDONE_STATUS_CODE = 155,	/**< Status code of the CREAM Done */
	EDG_WLL_CREAMDONE_REASON = 156,	/**< Reason for the status */
	EDG_WLL_CREAMDONE_EXIT_CODE = 157,	/**< Exit code */
	EDG_WLL_CREAMCANCEL_STATUS_CODE = 158,	/**< Status code of CREAM Cancel */
	EDG_WLL_CREAMCANCEL_REASON = 159,	/**< Reason for cancelling the job */
	EDG_WLL_CREAMABORT_REASON = 160,	/**< Reason for aborting the job */
	EDG_WLL_CREAMSTATUS_OLD_STATE = 161,	/**< Old status */
	EDG_WLL_CREAMSTATUS_NEW_STATE = 162,	/**< New status */
	EDG_WLL_CREAMSTATUS_ORIG_TIMESTAMP = 163,	/**< Original timestamp of the job state change */
	EDG_WLL_CREAMSTATUS_RESULT = 164,	/**< Result of the job state change */
	EDG_WLL_CREAMSTATUS_DESCR = 165,	/**< More detailed description */
	EDG_WLL_CREAMSTATUS_EXIT_CODE = 166,	/**< Exit code */
	EDG_WLL_CREAMSTATUS_FAILURE_REASON = 167,	/**< Reason for the failure */
	EDG_WLL_CREAMSTATUS_WORKER_NODE = 168,	/**< Worker node */
	EDG_WLL_CREAMSTATUS_LRMS_JOBID = 169,	/**< jobId from the LRMS */
	EDG_WLL_CREAMSUSPEND_STATUS_CODE = 170,	/**< Classification of the attempt to suspend the job (REQ, REFUSE, DONE or ABORT). */
	EDG_WLL_CREAMSUSPEND_REASON = 171,	/**< Reason for the suspend. */
	EDG_WLL_CREAMRESUME_STATUS_CODE = 172,	/**< Classification of the attempt to resume the job (REQ, REFUSE, DONE or ABORT). */
	EDG_WLL_CREAMRESUME_REASON = 173,	/**< Reason for the resume. */
	EDG_WLL_FILETRANSFERREGISTER_SRC = 174,	/**< Source of file transfer. */
	EDG_WLL_FILETRANSFERREGISTER_DEST = 175,	/**< Destination of file transfer. */
	EDG_WLL_FILETRANSFER_RESULT = 176,	/**< Result code of the file transfer attemp. */
	EDG_WLL_FILETRANSFER_REASON = 177,	/**< The reason of file transfer failure. */
	EDG_WLL_SANDBOX_SANDBOX_TYPE = 178,	/**< Type of sandbox. */
	EDG_WLL_SANDBOX_TRANSFER_JOB = 179,	/**< Jobid of transfer job (collection) containing set of file transfers (subjobs). */
	EDG_WLL_SANDBOX_COMPUTE_JOB = 180,	/**< Jobid of (compute) job the sandbox belongs. Exclusive with transfer_job. */
	EDG_WLL_VMCREATE_REQUIRE = 181,	/**< machine requirements */
	EDG_WLL_VMCREATE_ID = 182,	/**< machine id */
	EDG_WLL_VMCREATE_NAME = 183,	/**< machine name */
	EDG_WLL_VMCREATE_OWNER = 184,	/**< machine owner */
	EDG_WLL_VMCREATE_HOSTNAME = 185,	/**< hostname of VM */
	EDG_WLL_VMCREATE_MANAGER = 186,	/**< VM manager */
	EDG_WLL_VMCREATE_IMAGE = 187,	/**< machine image */
	EDG_WLL_VMHOST_HOSTNAME = 188,	/**< hostname of physical machine of VM */
	EDG_WLL_VMIMAGE_IMAGE = 189,	/**< machine image */
	EDG_WLL_VMSHUTDOWN_USAGE = 190,	/**<  */
	EDG_WLL_VMDONE_STATUS_CODE = 191,	/**<  */
	EDG_WLL_VMDONE_USAGE = 192,	/**<  */
	EDG_WLL_INTERNAL_TYPE,		/**< internal message type */
} edg_wll_KeyNameCode;

/**
 * \fn edg_wll_KeyNameCode edg_wll_StringToKeyName(const char *name)
 * \param[in] name		a string ULM key name (e.g. "DG.JOB.TRANSFER.DEST")
 * \return corresponding numeric code (edg_wll_KeyNameCode)
 * \brief convert a string ULM key name to the corresponding numeric code
 */

extern edg_wll_KeyNameCode edg_wll_StringToKeyName(const char *name);

/**
 * \fn char *edg_wll_KeyNameToString(edg_wll_KeyNameCode key)
 * \param[in] key		a ULM key name numeric code (edg_wll_KeyNameCode)
 * \return corresponding string (e.g. "DG.JOB.TRANSFER.DEST")
 * \brief convert a ULM key name numeric code to the corresponding string
 */

extern char *edg_wll_KeyNameToString(edg_wll_KeyNameCode key);


/**
 * Predefined _code_ types and
 * related StringTo_code and _code_ToString function prototypes
 */

/**
 * \enum edg_wll_Level
 * Level codes 
 */
enum edg_wll_Level {
	EDG_WLL_LEVEL_UNDEFINED,	/**< undefined code */ 
	EDG_WLL_LEVEL_EMERGENCY,	/**< emergency */ 
	EDG_WLL_LEVEL_ALERT,	/**< alert */ 
	EDG_WLL_LEVEL_ERROR,	/**< error */ 
	EDG_WLL_LEVEL_WARNING,	/**< warning */ 
	EDG_WLL_LEVEL_AUTH,	/**< authentication */ 
	EDG_WLL_LEVEL_SECURITY,	/**< security */ 
	EDG_WLL_LEVEL_USAGE,	/**< usage */ 
	EDG_WLL_LEVEL_SYSTEM,	/**< system */ 
	EDG_WLL_LEVEL_IMPORTANT,	/**< important */ 
	EDG_WLL_LEVEL_DEBUG,	/**< debug */ 
};

/**
 * \fn enum edg_wll_Level edg_wll_StringToLevel(const char *name);
 * \param[in] name		a string representing Level code (e.g. "ALERT")
 * \return corresponding numeric code (enum edg_wll_Level)
 * \brief converts a string Level code to corresponding numeric code
 */
extern enum edg_wll_Level edg_wll_StringToLevel(const char *name);

/**
 * \fn char *edg_wll_LevelToString(enum edg_wll_Level code);
 * \param[in] code		a Level numeric code (enum edg_wll_Level)
 * \return corresponding string (e.g. "ALERT")
 * \brief converts a Level numeric code to corresponding string
 */
extern char *edg_wll_LevelToString(enum edg_wll_Level code);


/**
 * \enum edg_wll_TransferResult
 * Result codes of the Transfer event
 */
enum edg_wll_TransferResult {
	EDG_WLL_TRANSFER_RESULT_UNDEFINED = 0,	/**< undefined code */ 
/* backward compatibility */
#define EDG_WLL_TRANSFER_UNDEFINED EDG_WLL_TRANSFER_RESULT_UNDEFINED

	EDG_WLL_TRANSFER_START,	/**< The sending component has started or is about to start the transfer. */ 
	EDG_WLL_TRANSFER_OK,	/**< The job was sent successfully. */ 
	EDG_WLL_TRANSFER_REFUSED,	/**< The job was refused by the other component. */ 
	EDG_WLL_TRANSFER_FAIL,	/**< The transfer failed for other reason than explicit refusal (eg. network timeout). */ 
};

/**
 * \fn enum edg_wll_TransferResult edg_wll_StringToTransferResult(const char *name);
 * \param[in] name		a string representing Transfer Result code (e.g. "OK")
 * \return corresponding numeric code (enum edg_wll_TransferResult)
 * \brief converts a string Transfer Result code to corresponding numeric code
 */
extern enum edg_wll_TransferResult edg_wll_StringToTransferResult(const char *name);

/**
 * \fn char *edg_wll_TransferResultToString(enum edg_wll_TransferResult code);
 * \param[in] code		a Transfer Result numeric code (enum edg_wll_TransferResult)
 * \return corresponding string (e.g. "OK")
 * \brief converts a Transfer Result numeric code to corresponding string
 */
extern char *edg_wll_TransferResultToString(enum edg_wll_TransferResult code);


/**
 * \enum edg_wll_EnQueuedResult
 * Result codes of the EnQueued event
 */
enum edg_wll_EnQueuedResult {
	EDG_WLL_ENQUEUED_RESULT_UNDEFINED = 0,	/**< undefined code */ 
/* backward compatibility */
#define EDG_WLL_ENQUEUED_UNDEFINED EDG_WLL_ENQUEUED_RESULT_UNDEFINED

	EDG_WLL_ENQUEUED_START,	/**< The sending component has started or is about to start enqueuing the job. */ 
	EDG_WLL_ENQUEUED_OK,	/**< The job was enqueued successfully. */ 
	EDG_WLL_ENQUEUED_REFUSED,	/**< The job was refused by the other component. */ 
	EDG_WLL_ENQUEUED_FAIL,	/**< The transfer failed for other reason than explicit refusal. */ 
};

/**
 * \fn enum edg_wll_EnQueuedResult edg_wll_StringToEnQueuedResult(const char *name);
 * \param[in] name		a string representing EnQueued Result code (e.g. "OK")
 * \return corresponding numeric code (enum edg_wll_EnQueuedResult)
 * \brief converts a string EnQueued Result code to corresponding numeric code
 */
extern enum edg_wll_EnQueuedResult edg_wll_StringToEnQueuedResult(const char *name);

/**
 * \fn char *edg_wll_EnQueuedResultToString(enum edg_wll_EnQueuedResult code);
 * \param[in] code		a EnQueued Result numeric code (enum edg_wll_EnQueuedResult)
 * \return corresponding string (e.g. "OK")
 * \brief converts a EnQueued Result numeric code to corresponding string
 */
extern char *edg_wll_EnQueuedResultToString(enum edg_wll_EnQueuedResult code);


/**
 * \enum edg_wll_HelperCallSrc_role
 * Src_role codes of the HelperCall event
 */
enum edg_wll_HelperCallSrc_role {
	EDG_WLL_HELPERCALL_SRC_ROLE_UNDEFINED = 0,	/**< undefined code */ 
/* backward compatibility */
#define EDG_WLL_HELPERCALL_UNDEFINED EDG_WLL_HELPERCALL_SRC_ROLE_UNDEFINED

	EDG_WLL_HELPERCALL_CALLING,	/**< The logging component is caller. */ 
	EDG_WLL_HELPERCALL_CALLED,	/**< The logging component is callee. */ 
};

/**
 * \fn enum edg_wll_HelperCallSrc_role edg_wll_StringToHelperCallSrc_role(const char *name);
 * \param[in] name		a string representing HelperCall Src_role code (e.g. "CALLED")
 * \return corresponding numeric code (enum edg_wll_HelperCallSrc_role)
 * \brief converts a string HelperCall Src_role code to corresponding numeric code
 */
extern enum edg_wll_HelperCallSrc_role edg_wll_StringToHelperCallSrc_role(const char *name);

/**
 * \fn char *edg_wll_HelperCallSrc_roleToString(enum edg_wll_HelperCallSrc_role code);
 * \param[in] code		a HelperCall Src_role numeric code (enum edg_wll_HelperCallSrc_role)
 * \return corresponding string (e.g. "CALLED")
 * \brief converts a HelperCall Src_role numeric code to corresponding string
 */
extern char *edg_wll_HelperCallSrc_roleToString(enum edg_wll_HelperCallSrc_role code);


/**
 * \enum edg_wll_HelperReturnSrc_role
 * Src_role codes of the HelperReturn event
 */
enum edg_wll_HelperReturnSrc_role {
	EDG_WLL_HELPERRETURN_SRC_ROLE_UNDEFINED = 0,	/**< undefined code */ 
/* backward compatibility */
#define EDG_WLL_HELPERRETURN_UNDEFINED EDG_WLL_HELPERRETURN_SRC_ROLE_UNDEFINED

	EDG_WLL_HELPERRETURN_CALLING,	/**< The logging component is caller. */ 
	EDG_WLL_HELPERRETURN_CALLED,	/**< The logging component is callee. */ 
};

/**
 * \fn enum edg_wll_HelperReturnSrc_role edg_wll_StringToHelperReturnSrc_role(const char *name);
 * \param[in] name		a string representing HelperReturn Src_role code (e.g. "CALLED")
 * \return corresponding numeric code (enum edg_wll_HelperReturnSrc_role)
 * \brief converts a string HelperReturn Src_role code to corresponding numeric code
 */
extern enum edg_wll_HelperReturnSrc_role edg_wll_StringToHelperReturnSrc_role(const char *name);

/**
 * \fn char *edg_wll_HelperReturnSrc_roleToString(enum edg_wll_HelperReturnSrc_role code);
 * \param[in] code		a HelperReturn Src_role numeric code (enum edg_wll_HelperReturnSrc_role)
 * \return corresponding string (e.g. "CALLED")
 * \brief converts a HelperReturn Src_role numeric code to corresponding string
 */
extern char *edg_wll_HelperReturnSrc_roleToString(enum edg_wll_HelperReturnSrc_role code);


/**
 * \enum edg_wll_ResubmissionResult
 * Result codes of the Resubmission event
 */
enum edg_wll_ResubmissionResult {
	EDG_WLL_RESUBMISSION_RESULT_UNDEFINED = 0,	/**< undefined code */ 
/* backward compatibility */
#define EDG_WLL_RESUBMISSION_UNDEFINED EDG_WLL_RESUBMISSION_RESULT_UNDEFINED

	EDG_WLL_RESUBMISSION_WILLRESUB,	/**< The job will be resubmitted (deep resubmission). */ 
	EDG_WLL_RESUBMISSION_WONTRESUB,	/**< The job will not be resubmitted. */ 
	EDG_WLL_RESUBMISSION_SHALLOW,	/**< Shallow resubmission (user payload has not started yet) */ 
};

/**
 * \fn enum edg_wll_ResubmissionResult edg_wll_StringToResubmissionResult(const char *name);
 * \param[in] name		a string representing Resubmission Result code (e.g. "WONTRESUB")
 * \return corresponding numeric code (enum edg_wll_ResubmissionResult)
 * \brief converts a string Resubmission Result code to corresponding numeric code
 */
extern enum edg_wll_ResubmissionResult edg_wll_StringToResubmissionResult(const char *name);

/**
 * \fn char *edg_wll_ResubmissionResultToString(enum edg_wll_ResubmissionResult code);
 * \param[in] code		a Resubmission Result numeric code (enum edg_wll_ResubmissionResult)
 * \return corresponding string (e.g. "WONTRESUB")
 * \brief converts a Resubmission Result numeric code to corresponding string
 */
extern char *edg_wll_ResubmissionResultToString(enum edg_wll_ResubmissionResult code);


/**
 * \enum edg_wll_DoneStatus_code
 * Status_code codes of the Done event
 */
enum edg_wll_DoneStatus_code {
	EDG_WLL_DONE_STATUS_CODE_UNDEFINED = 0,	/**< undefined code */ 
/* backward compatibility */
#define EDG_WLL_DONE_UNDEFINED EDG_WLL_DONE_STATUS_CODE_UNDEFINED

	EDG_WLL_DONE_OK,	/**< The job terminated by itself. */ 
	EDG_WLL_DONE_FAILED,	/**< The job disappeared from LRMS. */ 
	EDG_WLL_DONE_CANCELLED,	/**< The job was cancelled by user request. */ 
	EDG_WLL_DONE_KILLED,	/**< The job was killed (in Job Wrapper). */ 
};

/**
 * \fn enum edg_wll_DoneStatus_code edg_wll_StringToDoneStatus_code(const char *name);
 * \param[in] name		a string representing Done Status_code code (e.g. "FAILED")
 * \return corresponding numeric code (enum edg_wll_DoneStatus_code)
 * \brief converts a string Done Status_code code to corresponding numeric code
 */
extern enum edg_wll_DoneStatus_code edg_wll_StringToDoneStatus_code(const char *name);

/**
 * \fn char *edg_wll_DoneStatus_codeToString(enum edg_wll_DoneStatus_code code);
 * \param[in] code		a Done Status_code numeric code (enum edg_wll_DoneStatus_code)
 * \return corresponding string (e.g. "FAILED")
 * \brief converts a Done Status_code numeric code to corresponding string
 */
extern char *edg_wll_DoneStatus_codeToString(enum edg_wll_DoneStatus_code code);


/**
 * \enum edg_wll_CancelStatus_code
 * Status_code codes of the Cancel event
 */
enum edg_wll_CancelStatus_code {
	EDG_WLL_CANCEL_STATUS_CODE_UNDEFINED = 0,	/**< undefined code */ 
/* backward compatibility */
#define EDG_WLL_CANCEL_UNDEFINED EDG_WLL_CANCEL_STATUS_CODE_UNDEFINED

	EDG_WLL_CANCEL_REQ,	/**< The request was acknowledged. */ 
	EDG_WLL_CANCEL_REFUSE,	/**< The request was declined by this component. */ 
	EDG_WLL_CANCEL_DONE,	/**< The request was completed by whole WMS. */ 
	EDG_WLL_CANCEL_ABORT,	/**< The request was refused by whole WMS. */ 
};

/**
 * \fn enum edg_wll_CancelStatus_code edg_wll_StringToCancelStatus_code(const char *name);
 * \param[in] name		a string representing Cancel Status_code code (e.g. "REFUSE")
 * \return corresponding numeric code (enum edg_wll_CancelStatus_code)
 * \brief converts a string Cancel Status_code code to corresponding numeric code
 */
extern enum edg_wll_CancelStatus_code edg_wll_StringToCancelStatus_code(const char *name);

/**
 * \fn char *edg_wll_CancelStatus_codeToString(enum edg_wll_CancelStatus_code code);
 * \param[in] code		a Cancel Status_code numeric code (enum edg_wll_CancelStatus_code)
 * \return corresponding string (e.g. "REFUSE")
 * \brief converts a Cancel Status_code numeric code to corresponding string
 */
extern char *edg_wll_CancelStatus_codeToString(enum edg_wll_CancelStatus_code code);


/**
 * \enum edg_wll_ClearReason
 * Reason codes of the Clear event
 */
enum edg_wll_ClearReason {
	EDG_WLL_CLEAR_REASON_UNDEFINED = 0,	/**< undefined code */ 
/* backward compatibility */
#define EDG_WLL_CLEAR_UNDEFINED EDG_WLL_CLEAR_REASON_UNDEFINED

	EDG_WLL_CLEAR_USER,	/**< User retrieved output sandbox. */ 
	EDG_WLL_CLEAR_TIMEOUT,	/**< Timed out, resource forced purge of the sandbox. */ 
	EDG_WLL_CLEAR_NOOUTPUT,	/**< No output was generated. */ 
};

/**
 * \fn enum edg_wll_ClearReason edg_wll_StringToClearReason(const char *name);
 * \param[in] name		a string representing Clear Reason code (e.g. "TIMEOUT")
 * \return corresponding numeric code (enum edg_wll_ClearReason)
 * \brief converts a string Clear Reason code to corresponding numeric code
 */
extern enum edg_wll_ClearReason edg_wll_StringToClearReason(const char *name);

/**
 * \fn char *edg_wll_ClearReasonToString(enum edg_wll_ClearReason code);
 * \param[in] code		a Clear Reason numeric code (enum edg_wll_ClearReason)
 * \return corresponding string (e.g. "TIMEOUT")
 * \brief converts a Clear Reason numeric code to corresponding string
 */
extern char *edg_wll_ClearReasonToString(enum edg_wll_ClearReason code);


/**
 * \enum edg_wll_RegJobJobtype
 * Jobtype codes of the RegJob event
 */
enum edg_wll_RegJobJobtype {
	EDG_WLL_REGJOB_JOBTYPE_UNDEFINED = 0,	/**< undefined code */ 
/* backward compatibility */
#define EDG_WLL_REGJOB_UNDEFINED EDG_WLL_REGJOB_JOBTYPE_UNDEFINED

	EDG_WLL_REGJOB_SIMPLE,	/**< The job is simple job. */ 
	EDG_WLL_REGJOB_DAG,	/**< The job is dag (containing static set of subjobs). */ 
	EDG_WLL_REGJOB_PARTITIONABLE,	/**< The job is partitionable (may become partitioned). */ 
	EDG_WLL_REGJOB_PARTITIONED,	/**< The job is partitioned (dynamically created dag). */ 
	EDG_WLL_REGJOB_COLLECTION,	/**< The job is collection (containing static set of subjobs). */ 
	EDG_WLL_REGJOB_PBS,	/**< PBS job */ 
	EDG_WLL_REGJOB_CONDOR,	/**< Condor job */ 
	EDG_WLL_REGJOB_CREAM,	/**< CREAM job */ 
	EDG_WLL_REGJOB_FILE_TRANSFER_COLLECTION,	/**< File transfer collection */ 
	EDG_WLL_REGJOB_FILE_TRANSFER,	/**< File transfer */ 
	EDG_WLL_REGJOB_VIRTUAL_MACHINE,	/**< Virtual machine  */ 
};

/**
 * \fn enum edg_wll_RegJobJobtype edg_wll_StringToRegJobJobtype(const char *name);
 * \param[in] name		a string representing RegJob Jobtype code (e.g. "DAG")
 * \return corresponding numeric code (enum edg_wll_RegJobJobtype)
 * \brief converts a string RegJob Jobtype code to corresponding numeric code
 */
extern enum edg_wll_RegJobJobtype edg_wll_StringToRegJobJobtype(const char *name);

/**
 * \fn char *edg_wll_RegJobJobtypeToString(enum edg_wll_RegJobJobtype code);
 * \param[in] code		a RegJob Jobtype numeric code (enum edg_wll_RegJobJobtype)
 * \return corresponding string (e.g. "DAG")
 * \brief converts a RegJob Jobtype numeric code to corresponding string
 */
extern char *edg_wll_RegJobJobtypeToString(enum edg_wll_RegJobJobtype code);


/**
 * \enum edg_wll_ChangeACLUser_id_type
 * User_id_type codes of the ChangeACL event
 */
enum edg_wll_ChangeACLUser_id_type {
	EDG_WLL_CHANGEACL_USER_ID_TYPE_UNDEFINED = -1,	/**< undefined code */ 
/* backward compatibility */
#define EDG_WLL_CHANGEACL_UNDEFINED EDG_WLL_CHANGEACL_USER_ID_TYPE_UNDEFINED

	EDG_WLL_CHANGEACL_DN,	/**< Certificate subject name */ 
	EDG_WLL_CHANGEACL_GROUP,	/**< VO group (must be specified as "vo":"group") */ 
	EDG_WLL_CHANGEACL_FQAN,	/**< Standard Full Qualified Attribute Name (FQAN) */ 
};

/**
 * \fn enum edg_wll_ChangeACLUser_id_type edg_wll_StringToChangeACLUser_id_type(const char *name);
 * \param[in] name		a string representing ChangeACL User_id_type code (e.g. "GROUP")
 * \return corresponding numeric code (enum edg_wll_ChangeACLUser_id_type)
 * \brief converts a string ChangeACL User_id_type code to corresponding numeric code
 */
extern enum edg_wll_ChangeACLUser_id_type edg_wll_StringToChangeACLUser_id_type(const char *name);

/**
 * \fn char *edg_wll_ChangeACLUser_id_typeToString(enum edg_wll_ChangeACLUser_id_type code);
 * \param[in] code		a ChangeACL User_id_type numeric code (enum edg_wll_ChangeACLUser_id_type)
 * \return corresponding string (e.g. "GROUP")
 * \brief converts a ChangeACL User_id_type numeric code to corresponding string
 */
extern char *edg_wll_ChangeACLUser_id_typeToString(enum edg_wll_ChangeACLUser_id_type code);


/**
 * \enum edg_wll_ChangeACLPermission
 * Permission codes of the ChangeACL event
 */
enum edg_wll_ChangeACLPermission {
	EDG_WLL_CHANGEACL_PERMISSION_UNDEFINED = 0,	/**< undefined code */ 
	EDG_WLL_CHANGEACL_READ,	/**< Get job information */ 
	EDG_WLL_CHANGEACL_TAG,	/**< Add a user tag */ 
};

/**
 * \fn enum edg_wll_ChangeACLPermission edg_wll_StringToChangeACLPermission(const char *name);
 * \param[in] name		a string representing ChangeACL Permission code (e.g. "TAG")
 * \return corresponding numeric code (enum edg_wll_ChangeACLPermission)
 * \brief converts a string ChangeACL Permission code to corresponding numeric code
 */
extern enum edg_wll_ChangeACLPermission edg_wll_StringToChangeACLPermission(const char *name);

/**
 * \fn char *edg_wll_ChangeACLPermissionToString(enum edg_wll_ChangeACLPermission code);
 * \param[in] code		a ChangeACL Permission numeric code (enum edg_wll_ChangeACLPermission)
 * \return corresponding string (e.g. "TAG")
 * \brief converts a ChangeACL Permission numeric code to corresponding string
 */
extern char *edg_wll_ChangeACLPermissionToString(enum edg_wll_ChangeACLPermission code);


/**
 * \enum edg_wll_ChangeACLPermission_type
 * Permission_type codes of the ChangeACL event
 */
enum edg_wll_ChangeACLPermission_type {
	EDG_WLL_CHANGEACL_PERMISSION_TYPE_UNDEFINED = -1,	/**< undefined code */ 
	EDG_WLL_CHANGEACL_ALLOW,	/**< Grant the permission specified */ 
	EDG_WLL_CHANGEACL_DENY,	/**< Deny the permission specified */ 
};

/**
 * \fn enum edg_wll_ChangeACLPermission_type edg_wll_StringToChangeACLPermission_type(const char *name);
 * \param[in] name		a string representing ChangeACL Permission_type code (e.g. "DENY")
 * \return corresponding numeric code (enum edg_wll_ChangeACLPermission_type)
 * \brief converts a string ChangeACL Permission_type code to corresponding numeric code
 */
extern enum edg_wll_ChangeACLPermission_type edg_wll_StringToChangeACLPermission_type(const char *name);

/**
 * \fn char *edg_wll_ChangeACLPermission_typeToString(enum edg_wll_ChangeACLPermission_type code);
 * \param[in] code		a ChangeACL Permission_type numeric code (enum edg_wll_ChangeACLPermission_type)
 * \return corresponding string (e.g. "DENY")
 * \brief converts a ChangeACL Permission_type numeric code to corresponding string
 */
extern char *edg_wll_ChangeACLPermission_typeToString(enum edg_wll_ChangeACLPermission_type code);


/**
 * \enum edg_wll_ChangeACLOperation
 * Operation codes of the ChangeACL event
 */
enum edg_wll_ChangeACLOperation {
	EDG_WLL_CHANGEACL_OPERATION_UNDEFINED = -1,	/**< undefined code */ 
	EDG_WLL_CHANGEACL_ADD,	/**< Add the record to the ACL */ 
	EDG_WLL_CHANGEACL_REMOVE,	/**< Remove the record from the ACL */ 
};

/**
 * \fn enum edg_wll_ChangeACLOperation edg_wll_StringToChangeACLOperation(const char *name);
 * \param[in] name		a string representing ChangeACL Operation code (e.g. "REMOVE")
 * \return corresponding numeric code (enum edg_wll_ChangeACLOperation)
 * \brief converts a string ChangeACL Operation code to corresponding numeric code
 */
extern enum edg_wll_ChangeACLOperation edg_wll_StringToChangeACLOperation(const char *name);

/**
 * \fn char *edg_wll_ChangeACLOperationToString(enum edg_wll_ChangeACLOperation code);
 * \param[in] code		a ChangeACL Operation numeric code (enum edg_wll_ChangeACLOperation)
 * \return corresponding string (e.g. "REMOVE")
 * \brief converts a ChangeACL Operation numeric code to corresponding string
 */
extern char *edg_wll_ChangeACLOperationToString(enum edg_wll_ChangeACLOperation code);


/**
 * \enum edg_wll_ConnectJobJobtype
 * Jobtype codes of the ConnectJob event
 */
enum edg_wll_ConnectJobJobtype {
	EDG_WLL_CONNECTJOB_JOBTYPE_UNDEFINED = 0,	/**< undefined code */ 
/* backward compatibility */
#define EDG_WLL_CONNECTJOB_UNDEFINED EDG_WLL_CONNECTJOB_JOBTYPE_UNDEFINED

	EDG_WLL_CONNECTJOB_SIMPLE,	/**< The job is simple job. */ 
	EDG_WLL_CONNECTJOB_DAG,	/**< The job is dag (containing static set of subjobs). */ 
	EDG_WLL_CONNECTJOB_PARTITIONABLE,	/**< The job is partitionable (may become partitioned). */ 
	EDG_WLL_CONNECTJOB_PARTITIONED,	/**< The job is partitioned (dynamically created dag). */ 
	EDG_WLL_CONNECTJOB_COLLECTION,	/**< The job is collection (containing static set of subjobs). */ 
	EDG_WLL_CONNECTJOB_PBS,	/**< PBS job */ 
	EDG_WLL_CONNECTJOB_CONDOR,	/**< Condor job */ 
	EDG_WLL_CONNECTJOB_CREAM,	/**< CREAM job */ 
	EDG_WLL_CONNECTJOB_FILE_TRANSFER_COLLECTION,	/**< File transfer collection */ 
	EDG_WLL_CONNECTJOB_FILE_TRANSFER,	/**< File transfer */ 
	EDG_WLL_CONNECTJOB_VIRTUAL_MACHINE,	/**< Virtual machine */ 
};

/**
 * \fn enum edg_wll_ConnectJobJobtype edg_wll_StringToConnectJobJobtype(const char *name);
 * \param[in] name		a string representing ConnectJob Jobtype code (e.g. "DAG")
 * \return corresponding numeric code (enum edg_wll_ConnectJobJobtype)
 * \brief converts a string ConnectJob Jobtype code to corresponding numeric code
 */
extern enum edg_wll_ConnectJobJobtype edg_wll_StringToConnectJobJobtype(const char *name);

/**
 * \fn char *edg_wll_ConnectJobJobtypeToString(enum edg_wll_ConnectJobJobtype code);
 * \param[in] code		a ConnectJob Jobtype numeric code (enum edg_wll_ConnectJobJobtype)
 * \return corresponding string (e.g. "DAG")
 * \brief converts a ConnectJob Jobtype numeric code to corresponding string
 */
extern char *edg_wll_ConnectJobJobtypeToString(enum edg_wll_ConnectJobJobtype code);


/**
 * \enum edg_wll_PBSTransferResult
 * Result codes of the PBSTransfer event
 */
enum edg_wll_PBSTransferResult {
	EDG_WLL_PBSTRANSFER_RESULT_UNDEFINED = 0,	/**< undefined code */ 
/* backward compatibility */
#define EDG_WLL_PBSTRANSFER_UNDEFINED EDG_WLL_PBSTRANSFER_RESULT_UNDEFINED

	EDG_WLL_PBSTRANSFER_START,	/**< The sending component has started or is about to start the transfer. */ 
	EDG_WLL_PBSTRANSFER_OK,	/**< The job was sent successfully. */ 
	EDG_WLL_PBSTRANSFER_REFUSED,	/**< The job was refused by the other component. */ 
	EDG_WLL_PBSTRANSFER_FAIL,	/**< The transfer failed for other reason than explicit refusal (eg. network timeout). */ 
};

/**
 * \fn enum edg_wll_PBSTransferResult edg_wll_StringToPBSTransferResult(const char *name);
 * \param[in] name		a string representing PBSTransfer Result code (e.g. "OK")
 * \return corresponding numeric code (enum edg_wll_PBSTransferResult)
 * \brief converts a string PBSTransfer Result code to corresponding numeric code
 */
extern enum edg_wll_PBSTransferResult edg_wll_StringToPBSTransferResult(const char *name);

/**
 * \fn char *edg_wll_PBSTransferResultToString(enum edg_wll_PBSTransferResult code);
 * \param[in] code		a PBSTransfer Result numeric code (enum edg_wll_PBSTransferResult)
 * \return corresponding string (e.g. "OK")
 * \brief converts a PBSTransfer Result numeric code to corresponding string
 */
extern char *edg_wll_PBSTransferResultToString(enum edg_wll_PBSTransferResult code);


/**
 * \enum edg_wll_PBSResourceUsageUsage
 * Usage codes of the PBSResourceUsage event
 */
enum edg_wll_PBSResourceUsageUsage {
	EDG_WLL_PBSRESOURCEUSAGE_USAGE_UNDEFINED = 0,	/**< undefined code */ 
/* backward compatibility */
#define EDG_WLL_PBSRESOURCEUSAGE_UNDEFINED EDG_WLL_PBSRESOURCEUSAGE_USAGE_UNDEFINED

	EDG_WLL_PBSRESOURCEUSAGE_REQUESTED,	/**< Requested value */ 
	EDG_WLL_PBSRESOURCEUSAGE_USED,	/**< Consumed quantity */ 
};

/**
 * \fn enum edg_wll_PBSResourceUsageUsage edg_wll_StringToPBSResourceUsageUsage(const char *name);
 * \param[in] name		a string representing PBSResourceUsage Usage code (e.g. "USED")
 * \return corresponding numeric code (enum edg_wll_PBSResourceUsageUsage)
 * \brief converts a string PBSResourceUsage Usage code to corresponding numeric code
 */
extern enum edg_wll_PBSResourceUsageUsage edg_wll_StringToPBSResourceUsageUsage(const char *name);

/**
 * \fn char *edg_wll_PBSResourceUsageUsageToString(enum edg_wll_PBSResourceUsageUsage code);
 * \param[in] code		a PBSResourceUsage Usage numeric code (enum edg_wll_PBSResourceUsageUsage)
 * \return corresponding string (e.g. "USED")
 * \brief converts a PBSResourceUsage Usage numeric code to corresponding string
 */
extern char *edg_wll_PBSResourceUsageUsageToString(enum edg_wll_PBSResourceUsageUsage code);


/**
 * \enum edg_wll_CondorRejectStatus_code
 * Status_code codes of the CondorReject event
 */
enum edg_wll_CondorRejectStatus_code {
	EDG_WLL_CONDORREJECT_STATUS_CODE_UNDEFINED = 0,	/**< undefined code */ 
/* backward compatibility */
#define EDG_WLL_CONDORREJECT_UNDEFINED EDG_WLL_CONDORREJECT_STATUS_CODE_UNDEFINED

	EDG_WLL_CONDORREJECT_NOMATCH,	/**< No match found */ 
	EDG_WLL_CONDORREJECT_OTHER,	/**< Other reason */ 
};

/**
 * \fn enum edg_wll_CondorRejectStatus_code edg_wll_StringToCondorRejectStatus_code(const char *name);
 * \param[in] name		a string representing CondorReject Status_code code (e.g. "OTHER")
 * \return corresponding numeric code (enum edg_wll_CondorRejectStatus_code)
 * \brief converts a string CondorReject Status_code code to corresponding numeric code
 */
extern enum edg_wll_CondorRejectStatus_code edg_wll_StringToCondorRejectStatus_code(const char *name);

/**
 * \fn char *edg_wll_CondorRejectStatus_codeToString(enum edg_wll_CondorRejectStatus_code code);
 * \param[in] code		a CondorReject Status_code numeric code (enum edg_wll_CondorRejectStatus_code)
 * \return corresponding string (e.g. "OTHER")
 * \brief converts a CondorReject Status_code numeric code to corresponding string
 */
extern char *edg_wll_CondorRejectStatus_codeToString(enum edg_wll_CondorRejectStatus_code code);


/**
 * \enum edg_wll_CondorResourceUsageUsage
 * Usage codes of the CondorResourceUsage event
 */
enum edg_wll_CondorResourceUsageUsage {
	EDG_WLL_CONDORRESOURCEUSAGE_USAGE_UNDEFINED = 0,	/**< undefined code */ 
/* backward compatibility */
#define EDG_WLL_CONDORRESOURCEUSAGE_UNDEFINED EDG_WLL_CONDORRESOURCEUSAGE_USAGE_UNDEFINED

	EDG_WLL_CONDORRESOURCEUSAGE_REQUESTED,	/**< Requested value */ 
	EDG_WLL_CONDORRESOURCEUSAGE_USED,	/**< Consumed quantity */ 
};

/**
 * \fn enum edg_wll_CondorResourceUsageUsage edg_wll_StringToCondorResourceUsageUsage(const char *name);
 * \param[in] name		a string representing CondorResourceUsage Usage code (e.g. "USED")
 * \return corresponding numeric code (enum edg_wll_CondorResourceUsageUsage)
 * \brief converts a string CondorResourceUsage Usage code to corresponding numeric code
 */
extern enum edg_wll_CondorResourceUsageUsage edg_wll_StringToCondorResourceUsageUsage(const char *name);

/**
 * \fn char *edg_wll_CondorResourceUsageUsageToString(enum edg_wll_CondorResourceUsageUsage code);
 * \param[in] code		a CondorResourceUsage Usage numeric code (enum edg_wll_CondorResourceUsageUsage)
 * \return corresponding string (e.g. "USED")
 * \brief converts a CondorResourceUsage Usage numeric code to corresponding string
 */
extern char *edg_wll_CondorResourceUsageUsageToString(enum edg_wll_CondorResourceUsageUsage code);


/**
 * \enum edg_wll_CREAMStoreCommand
 * Command codes of the CREAMStore event
 */
enum edg_wll_CREAMStoreCommand {
	EDG_WLL_CREAMSTORE_COMMAND_UNDEFINED = 0,	/**< undefined code */ 
/* backward compatibility */
#define EDG_WLL_CREAMSTORE_UNDEFINED EDG_WLL_CREAMSTORE_COMMAND_UNDEFINED

	EDG_WLL_CREAMSTORE_CMDSTART,	/**< Start registered job */ 
	EDG_WLL_CREAMSTORE_CMDCANCEL,	/**< Cancel job */ 
	EDG_WLL_CREAMSTORE_CMDPURGE,	/**< Purge request */ 
	EDG_WLL_CREAMSTORE_CMDSUSPEND,	/**< Suspend running job */ 
	EDG_WLL_CREAMSTORE_CMDRESUME,	/**< Resume suspended job */ 
};

/**
 * \fn enum edg_wll_CREAMStoreCommand edg_wll_StringToCREAMStoreCommand(const char *name);
 * \param[in] name		a string representing CREAMStore Command code (e.g. "CMDCANCEL")
 * \return corresponding numeric code (enum edg_wll_CREAMStoreCommand)
 * \brief converts a string CREAMStore Command code to corresponding numeric code
 */
extern enum edg_wll_CREAMStoreCommand edg_wll_StringToCREAMStoreCommand(const char *name);

/**
 * \fn char *edg_wll_CREAMStoreCommandToString(enum edg_wll_CREAMStoreCommand code);
 * \param[in] code		a CREAMStore Command numeric code (enum edg_wll_CREAMStoreCommand)
 * \return corresponding string (e.g. "CMDCANCEL")
 * \brief converts a CREAMStore Command numeric code to corresponding string
 */
extern char *edg_wll_CREAMStoreCommandToString(enum edg_wll_CREAMStoreCommand code);


/**
 * \enum edg_wll_CREAMStoreResult
 * Result codes of the CREAMStore event
 */
enum edg_wll_CREAMStoreResult {
	EDG_WLL_CREAMSTORE_RESULT_UNDEFINED = 0,	/**< undefined code */ 
	EDG_WLL_CREAMSTORE_START,	/**< start */ 
	EDG_WLL_CREAMSTORE_OK,	/**< ok */ 
	EDG_WLL_CREAMSTORE_FAILED,	/**< failed */ 
};

/**
 * \fn enum edg_wll_CREAMStoreResult edg_wll_StringToCREAMStoreResult(const char *name);
 * \param[in] name		a string representing CREAMStore Result code (e.g. "OK")
 * \return corresponding numeric code (enum edg_wll_CREAMStoreResult)
 * \brief converts a string CREAMStore Result code to corresponding numeric code
 */
extern enum edg_wll_CREAMStoreResult edg_wll_StringToCREAMStoreResult(const char *name);

/**
 * \fn char *edg_wll_CREAMStoreResultToString(enum edg_wll_CREAMStoreResult code);
 * \param[in] code		a CREAMStore Result numeric code (enum edg_wll_CREAMStoreResult)
 * \return corresponding string (e.g. "OK")
 * \brief converts a CREAMStore Result numeric code to corresponding string
 */
extern char *edg_wll_CREAMStoreResultToString(enum edg_wll_CREAMStoreResult code);


/**
 * \enum edg_wll_CREAMCallCommand
 * Command codes of the CREAMCall event
 */
enum edg_wll_CREAMCallCommand {
	EDG_WLL_CREAMCALL_COMMAND_UNDEFINED = 0,	/**< undefined code */ 
/* backward compatibility */
#define EDG_WLL_CREAMCALL_UNDEFINED EDG_WLL_CREAMCALL_COMMAND_UNDEFINED

	EDG_WLL_CREAMCALL_CMDSTART = EDG_WLL_CREAMSTORE_CMDSTART,	/**< Start registered job */ 
	EDG_WLL_CREAMCALL_CMDCANCEL = EDG_WLL_CREAMSTORE_CMDCANCEL,	/**< Cancel job */ 
	EDG_WLL_CREAMCALL_CMDPURGE = EDG_WLL_CREAMSTORE_CMDPURGE,	/**< Purge request */ 
	EDG_WLL_CREAMCALL_CMDSUSPEND = EDG_WLL_CREAMSTORE_CMDSUSPEND,	/**< Suspend running job */ 
	EDG_WLL_CREAMCALL_CMDRESUME = EDG_WLL_CREAMSTORE_CMDRESUME,	/**< Resume suspended job */ 
};

/**
 * \fn enum edg_wll_CREAMCallCommand edg_wll_StringToCREAMCallCommand(const char *name);
 * \param[in] name		a string representing CREAMCall Command code (e.g. "CMDCANCEL")
 * \return corresponding numeric code (enum edg_wll_CREAMCallCommand)
 * \brief converts a string CREAMCall Command code to corresponding numeric code
 */
extern enum edg_wll_CREAMCallCommand edg_wll_StringToCREAMCallCommand(const char *name);

/**
 * \fn char *edg_wll_CREAMCallCommandToString(enum edg_wll_CREAMCallCommand code);
 * \param[in] code		a CREAMCall Command numeric code (enum edg_wll_CREAMCallCommand)
 * \return corresponding string (e.g. "CMDCANCEL")
 * \brief converts a CREAMCall Command numeric code to corresponding string
 */
extern char *edg_wll_CREAMCallCommandToString(enum edg_wll_CREAMCallCommand code);


/**
 * \enum edg_wll_CREAMCallResult
 * Result codes of the CREAMCall event
 */
enum edg_wll_CREAMCallResult {
	EDG_WLL_CREAMCALL_RESULT_UNDEFINED = 0,	/**< undefined code */ 
	EDG_WLL_CREAMCALL_START,	/**< start */ 
	EDG_WLL_CREAMCALL_OK,	/**< ok */ 
	EDG_WLL_CREAMCALL_FAILED,	/**< failed */ 
};

/**
 * \fn enum edg_wll_CREAMCallResult edg_wll_StringToCREAMCallResult(const char *name);
 * \param[in] name		a string representing CREAMCall Result code (e.g. "OK")
 * \return corresponding numeric code (enum edg_wll_CREAMCallResult)
 * \brief converts a string CREAMCall Result code to corresponding numeric code
 */
extern enum edg_wll_CREAMCallResult edg_wll_StringToCREAMCallResult(const char *name);

/**
 * \fn char *edg_wll_CREAMCallResultToString(enum edg_wll_CREAMCallResult code);
 * \param[in] code		a CREAMCall Result numeric code (enum edg_wll_CREAMCallResult)
 * \return corresponding string (e.g. "OK")
 * \brief converts a CREAMCall Result numeric code to corresponding string
 */
extern char *edg_wll_CREAMCallResultToString(enum edg_wll_CREAMCallResult code);


/**
 * \enum edg_wll_CREAMDoneStatus_code
 * Status_code codes of the CREAMDone event
 */
enum edg_wll_CREAMDoneStatus_code {
	EDG_WLL_CREAMDONE_STATUS_CODE_UNDEFINED = 0,	/**< undefined code */ 
/* backward compatibility */
#define EDG_WLL_CREAMDONE_UNDEFINED EDG_WLL_CREAMDONE_STATUS_CODE_UNDEFINED

	EDG_WLL_CREAMDONE_OK,	/**< ok */ 
	EDG_WLL_CREAMDONE_FAILED,	/**< failed */ 
	EDG_WLL_CREAMDONE_CANCELLED,	/**< cancelled */ 
	EDG_WLL_CREAMDONE_KILLED,	/**< killed */ 
};

/**
 * \fn enum edg_wll_CREAMDoneStatus_code edg_wll_StringToCREAMDoneStatus_code(const char *name);
 * \param[in] name		a string representing CREAMDone Status_code code (e.g. "FAILED")
 * \return corresponding numeric code (enum edg_wll_CREAMDoneStatus_code)
 * \brief converts a string CREAMDone Status_code code to corresponding numeric code
 */
extern enum edg_wll_CREAMDoneStatus_code edg_wll_StringToCREAMDoneStatus_code(const char *name);

/**
 * \fn char *edg_wll_CREAMDoneStatus_codeToString(enum edg_wll_CREAMDoneStatus_code code);
 * \param[in] code		a CREAMDone Status_code numeric code (enum edg_wll_CREAMDoneStatus_code)
 * \return corresponding string (e.g. "FAILED")
 * \brief converts a CREAMDone Status_code numeric code to corresponding string
 */
extern char *edg_wll_CREAMDoneStatus_codeToString(enum edg_wll_CREAMDoneStatus_code code);


/**
 * \enum edg_wll_CREAMCancelStatus_code
 * Status_code codes of the CREAMCancel event
 */
enum edg_wll_CREAMCancelStatus_code {
	EDG_WLL_CREAMCANCEL_STATUS_CODE_UNDEFINED = 0,	/**< undefined code */ 
/* backward compatibility */
#define EDG_WLL_CREAMCANCEL_UNDEFINED EDG_WLL_CREAMCANCEL_STATUS_CODE_UNDEFINED

	EDG_WLL_CREAMCANCEL_REQ,	/**< req */ 
	EDG_WLL_CREAMCANCEL_REFUSE,	/**< refuse */ 
	EDG_WLL_CREAMCANCEL_DONE,	/**< done */ 
	EDG_WLL_CREAMCANCEL_ABORT,	/**< abort */ 
};

/**
 * \fn enum edg_wll_CREAMCancelStatus_code edg_wll_StringToCREAMCancelStatus_code(const char *name);
 * \param[in] name		a string representing CREAMCancel Status_code code (e.g. "REFUSE")
 * \return corresponding numeric code (enum edg_wll_CREAMCancelStatus_code)
 * \brief converts a string CREAMCancel Status_code code to corresponding numeric code
 */
extern enum edg_wll_CREAMCancelStatus_code edg_wll_StringToCREAMCancelStatus_code(const char *name);

/**
 * \fn char *edg_wll_CREAMCancelStatus_codeToString(enum edg_wll_CREAMCancelStatus_code code);
 * \param[in] code		a CREAMCancel Status_code numeric code (enum edg_wll_CREAMCancelStatus_code)
 * \return corresponding string (e.g. "REFUSE")
 * \brief converts a CREAMCancel Status_code numeric code to corresponding string
 */
extern char *edg_wll_CREAMCancelStatus_codeToString(enum edg_wll_CREAMCancelStatus_code code);


/**
 * \enum edg_wll_CREAMStatusResult
 * Result codes of the CREAMStatus event
 */
enum edg_wll_CREAMStatusResult {
	EDG_WLL_CREAMSTATUS_RESULT_UNDEFINED = 0,	/**< undefined code */ 
/* backward compatibility */
#define EDG_WLL_CREAMSTATUS_UNDEFINED EDG_WLL_CREAMSTATUS_RESULT_UNDEFINED

	EDG_WLL_CREAMSTATUS_ARRIVED,	/**< arrived */ 
	EDG_WLL_CREAMSTATUS_DONE,	/**< done */ 
};

/**
 * \fn enum edg_wll_CREAMStatusResult edg_wll_StringToCREAMStatusResult(const char *name);
 * \param[in] name		a string representing CREAMStatus Result code (e.g. "DONE")
 * \return corresponding numeric code (enum edg_wll_CREAMStatusResult)
 * \brief converts a string CREAMStatus Result code to corresponding numeric code
 */
extern enum edg_wll_CREAMStatusResult edg_wll_StringToCREAMStatusResult(const char *name);

/**
 * \fn char *edg_wll_CREAMStatusResultToString(enum edg_wll_CREAMStatusResult code);
 * \param[in] code		a CREAMStatus Result numeric code (enum edg_wll_CREAMStatusResult)
 * \return corresponding string (e.g. "DONE")
 * \brief converts a CREAMStatus Result numeric code to corresponding string
 */
extern char *edg_wll_CREAMStatusResultToString(enum edg_wll_CREAMStatusResult code);


/**
 * \enum edg_wll_CREAMSuspendStatus_code
 * Status_code codes of the CREAMSuspend event
 */
enum edg_wll_CREAMSuspendStatus_code {
	EDG_WLL_CREAMSUSPEND_STATUS_CODE_UNDEFINED = 0,	/**< undefined code */ 
/* backward compatibility */
#define EDG_WLL_CREAMSUSPEND_UNDEFINED EDG_WLL_CREAMSUSPEND_STATUS_CODE_UNDEFINED

	EDG_WLL_CREAMSUSPEND_REQ,	/**< The request was acknowledged. */ 
	EDG_WLL_CREAMSUSPEND_REFUSE,	/**< The request was declined by this component. */ 
	EDG_WLL_CREAMSUSPEND_DONE,	/**< The request was completed by whole system. */ 
	EDG_WLL_CREAMSUSPEND_ABORT,	/**< The request was refused by whole system. */ 
};

/**
 * \fn enum edg_wll_CREAMSuspendStatus_code edg_wll_StringToCREAMSuspendStatus_code(const char *name);
 * \param[in] name		a string representing CREAMSuspend Status_code code (e.g. "REFUSE")
 * \return corresponding numeric code (enum edg_wll_CREAMSuspendStatus_code)
 * \brief converts a string CREAMSuspend Status_code code to corresponding numeric code
 */
extern enum edg_wll_CREAMSuspendStatus_code edg_wll_StringToCREAMSuspendStatus_code(const char *name);

/**
 * \fn char *edg_wll_CREAMSuspendStatus_codeToString(enum edg_wll_CREAMSuspendStatus_code code);
 * \param[in] code		a CREAMSuspend Status_code numeric code (enum edg_wll_CREAMSuspendStatus_code)
 * \return corresponding string (e.g. "REFUSE")
 * \brief converts a CREAMSuspend Status_code numeric code to corresponding string
 */
extern char *edg_wll_CREAMSuspendStatus_codeToString(enum edg_wll_CREAMSuspendStatus_code code);


/**
 * \enum edg_wll_CREAMResumeStatus_code
 * Status_code codes of the CREAMResume event
 */
enum edg_wll_CREAMResumeStatus_code {
	EDG_WLL_CREAMRESUME_STATUS_CODE_UNDEFINED = 0,	/**< undefined code */ 
/* backward compatibility */
#define EDG_WLL_CREAMRESUME_UNDEFINED EDG_WLL_CREAMRESUME_STATUS_CODE_UNDEFINED

	EDG_WLL_CREAMRESUME_REQ,	/**< The request was acknowledged. */ 
	EDG_WLL_CREAMRESUME_REFUSE,	/**< The request was declined by this component. */ 
	EDG_WLL_CREAMRESUME_DONE,	/**< The request was completed by whole system. */ 
	EDG_WLL_CREAMRESUME_ABORT,	/**< The request was refused by whole system. */ 
};

/**
 * \fn enum edg_wll_CREAMResumeStatus_code edg_wll_StringToCREAMResumeStatus_code(const char *name);
 * \param[in] name		a string representing CREAMResume Status_code code (e.g. "REFUSE")
 * \return corresponding numeric code (enum edg_wll_CREAMResumeStatus_code)
 * \brief converts a string CREAMResume Status_code code to corresponding numeric code
 */
extern enum edg_wll_CREAMResumeStatus_code edg_wll_StringToCREAMResumeStatus_code(const char *name);

/**
 * \fn char *edg_wll_CREAMResumeStatus_codeToString(enum edg_wll_CREAMResumeStatus_code code);
 * \param[in] code		a CREAMResume Status_code numeric code (enum edg_wll_CREAMResumeStatus_code)
 * \return corresponding string (e.g. "REFUSE")
 * \brief converts a CREAMResume Status_code numeric code to corresponding string
 */
extern char *edg_wll_CREAMResumeStatus_codeToString(enum edg_wll_CREAMResumeStatus_code code);


/**
 * \enum edg_wll_FileTransferResult
 * Result codes of the FileTransfer event
 */
enum edg_wll_FileTransferResult {
	EDG_WLL_FILETRANSFER_RESULT_UNDEFINED = 0,	/**< undefined code */ 
/* backward compatibility */
#define EDG_WLL_FILETRANSFER_UNDEFINED EDG_WLL_FILETRANSFER_RESULT_UNDEFINED

	EDG_WLL_FILETRANSFER_START,	/**< The sending component has started or is about to start the file transfer. */ 
	EDG_WLL_FILETRANSFER_OK,	/**< The file was transfered successfully. */ 
	EDG_WLL_FILETRANSFER_FAIL,	/**< The file transfer failed (see reason) */ 
};

/**
 * \fn enum edg_wll_FileTransferResult edg_wll_StringToFileTransferResult(const char *name);
 * \param[in] name		a string representing FileTransfer Result code (e.g. "OK")
 * \return corresponding numeric code (enum edg_wll_FileTransferResult)
 * \brief converts a string FileTransfer Result code to corresponding numeric code
 */
extern enum edg_wll_FileTransferResult edg_wll_StringToFileTransferResult(const char *name);

/**
 * \fn char *edg_wll_FileTransferResultToString(enum edg_wll_FileTransferResult code);
 * \param[in] code		a FileTransfer Result numeric code (enum edg_wll_FileTransferResult)
 * \return corresponding string (e.g. "OK")
 * \brief converts a FileTransfer Result numeric code to corresponding string
 */
extern char *edg_wll_FileTransferResultToString(enum edg_wll_FileTransferResult code);


/**
 * \enum edg_wll_SandboxSandbox_type
 * Sandbox_type codes of the Sandbox event
 */
enum edg_wll_SandboxSandbox_type {
	EDG_WLL_SANDBOX_SANDBOX_TYPE_UNDEFINED = 0,	/**< undefined code */ 
/* backward compatibility */
#define EDG_WLL_SANDBOX_UNDEFINED EDG_WLL_SANDBOX_SANDBOX_TYPE_UNDEFINED

	EDG_WLL_SANDBOX_INPUT,	/**< input */ 
	EDG_WLL_SANDBOX_OUTPUT,	/**< output */ 
};

/**
 * \fn enum edg_wll_SandboxSandbox_type edg_wll_StringToSandboxSandbox_type(const char *name);
 * \param[in] name		a string representing Sandbox Sandbox_type code (e.g. "OUTPUT")
 * \return corresponding numeric code (enum edg_wll_SandboxSandbox_type)
 * \brief converts a string Sandbox Sandbox_type code to corresponding numeric code
 */
extern enum edg_wll_SandboxSandbox_type edg_wll_StringToSandboxSandbox_type(const char *name);

/**
 * \fn char *edg_wll_SandboxSandbox_typeToString(enum edg_wll_SandboxSandbox_type code);
 * \param[in] code		a Sandbox Sandbox_type numeric code (enum edg_wll_SandboxSandbox_type)
 * \return corresponding string (e.g. "OUTPUT")
 * \brief converts a Sandbox Sandbox_type numeric code to corresponding string
 */
extern char *edg_wll_SandboxSandbox_typeToString(enum edg_wll_SandboxSandbox_type code);


/**
 * \enum edg_wll_VMDoneStatus_code
 * Status_code codes of the VMDone event
 */
enum edg_wll_VMDoneStatus_code {
	EDG_WLL_VMDONE_STATUS_CODE_UNDEFINED = 0,	/**< undefined code */ 
/* backward compatibility */
#define EDG_WLL_VMDONE_UNDEFINED EDG_WLL_VMDONE_STATUS_CODE_UNDEFINED

	EDG_WLL_VMDONE_OK,	/**<  */ 
	EDG_WLL_VMDONE_DELETE,	/**<  */ 
	EDG_WLL_VMDONE_FAILURE,	/**<  */ 
};

/**
 * \fn enum edg_wll_VMDoneStatus_code edg_wll_StringToVMDoneStatus_code(const char *name);
 * \param[in] name		a string representing VMDone Status_code code (e.g. "DELETE")
 * \return corresponding numeric code (enum edg_wll_VMDoneStatus_code)
 * \brief converts a string VMDone Status_code code to corresponding numeric code
 */
extern enum edg_wll_VMDoneStatus_code edg_wll_StringToVMDoneStatus_code(const char *name);

/**
 * \fn char *edg_wll_VMDoneStatus_codeToString(enum edg_wll_VMDoneStatus_code code);
 * \param[in] code		a VMDone Status_code numeric code (enum edg_wll_VMDoneStatus_code)
 * \return corresponding string (e.g. "DELETE")
 * \brief converts a VMDone Status_code numeric code to corresponding string
 */
extern char *edg_wll_VMDoneStatus_codeToString(enum edg_wll_VMDoneStatus_code code);



/**
 * common fields of all event types: 
 */

#define _EDG_WLL_EVENT_COMMON \
	edg_wll_EventCode		type;\
	struct timeval		timestamp /**<< Time the event was generated. */;	\
	struct timeval		arrived /**<< Time the event was stored into the bookkeeping server database. */;	\
	char *		host /**<< Hostname of the machine where the event was generated. */;	\
	int		level /**<< Logging level (in the range from DEBUG to EMERGENCY). */;	\
	int		priority /**<< Message priority (yet 0 for asynchronous and 1 for synchronous transfers). */;	\
	glite_jobid_t		jobId /**<< Grid job id of the job the event belongs to. */;	\
	char *		seqcode /**<< Sequence code assigned to the event. */;	\
	char *		user /**<< Identity (certificate subject) of the event sender. */;	\
	edg_wll_Source		source /**<< Source (software component) which generated this event. */;	\
	char *		src_instance /**<< Instance of source component (e.g. service communication endpoint). */;	\


/**
 * \typedef edg_wll_AnyEvent
 * common structure definition contained in all types of the events
 */
typedef struct _edg_wll_AnyEvent {
_EDG_WLL_EVENT_COMMON
} edg_wll_AnyEvent;


/**
 *  Event types specific structures: 
 */

/**
* \typedef edg_wll_TransferEvent
* structure definition for Transfer event 
*/
typedef struct _edg_wll_TransferEvent {
_EDG_WLL_EVENT_COMMON
	edg_wll_Source	destination;	/**< Destination where the job is being transfered to. */
	char *	dest_host;	/**< Hostname of server that takes over control of the job. */
	char *	dest_instance;	/**< Service (instance) that takes over control of the job. */
	char *	job;	/**< Job description in receiver's language. */
	enum edg_wll_TransferResult	result;	/**< Result code of the transfer attempt (START, OK, REFUSED or FAIL). */
	char *	reason;	/**< Detailed description of the transfer, especially reason of failure. */
	char *	dest_jobid;	/**< Job id as assigned by the receiving software component. */
} edg_wll_TransferEvent;

/**
* \typedef edg_wll_AcceptedEvent
* structure definition for Accepted event 
*/
typedef struct _edg_wll_AcceptedEvent {
_EDG_WLL_EVENT_COMMON
	edg_wll_Source	from;	/**< The software component  the job was received from. */
	char *	from_host;	/**< Hostname of the component the job was received from. */
	char *	from_instance;	/**< Instance of the component the job was received from. */
	char *	local_jobid;	/**< New job id as assigned by the receiving component. */
} edg_wll_AcceptedEvent;

/**
* \typedef edg_wll_RefusedEvent
* structure definition for Refused event 
*/
typedef struct _edg_wll_RefusedEvent {
_EDG_WLL_EVENT_COMMON
	edg_wll_Source	from;	/**< The software component that tried to send the job. */
	char *	from_host;	/**< Hostname of the component that tried to send the job. */
	char *	from_instance;	/**< Instance of the component that tried to send the job. */
	char *	reason;	/**< Description of the reason why the job was refused. */
} edg_wll_RefusedEvent;

/**
* \typedef edg_wll_EnQueuedEvent
* structure definition for EnQueued event 
*/
typedef struct _edg_wll_EnQueuedEvent {
_EDG_WLL_EVENT_COMMON
	char *	queue;	/**< Queue into which the job has been stored for retrieval by another component. */
	char *	job;	/**< Job description in the receiver's language. */
	enum edg_wll_EnQueuedResult	result;	/**< Result code of the attempt to put job into the queue (START, OK, REFUSED or FAIL). */
	char *	reason;	/**< Detailed description of the attempt to enqueue the job, especially the reason of failure. */
} edg_wll_EnQueuedEvent;

/**
* \typedef edg_wll_DeQueuedEvent
* structure definition for DeQueued event 
*/
typedef struct _edg_wll_DeQueuedEvent {
_EDG_WLL_EVENT_COMMON
	char *	queue;	/**< Name of the queue the job was obtained from. */
	char *	local_jobid;	/**< New job id as assigned by the retreiving component. */
} edg_wll_DeQueuedEvent;

/**
* \typedef edg_wll_HelperCallEvent
* structure definition for HelperCall event 
*/
typedef struct _edg_wll_HelperCallEvent {
_EDG_WLL_EVENT_COMMON
	char *	helper_name;	/**< Name of the called helper component. */
	char *	helper_params;	/**< Parameters of the call to the helper component. */
	enum edg_wll_HelperCallSrc_role	src_role;	/**< The role the event sender is playing in the helper call (CALLING or CALLEE). */
} edg_wll_HelperCallEvent;

/**
* \typedef edg_wll_HelperReturnEvent
* structure definition for HelperReturn event 
*/
typedef struct _edg_wll_HelperReturnEvent {
_EDG_WLL_EVENT_COMMON
	char *	helper_name;	/**< Name of the called helper component. */
	char *	retval;	/**< Data returned by the call to the helper component. */
	enum edg_wll_HelperReturnSrc_role	src_role;	/**< The role the event sender is playing in the helper call (CALLING or CALLEE). */
} edg_wll_HelperReturnEvent;

/**
* \typedef edg_wll_RunningEvent
* structure definition for Running event 
*/
typedef struct _edg_wll_RunningEvent {
_EDG_WLL_EVENT_COMMON
	char *	node;	/**< Worker node on which the job executable is being run. */
} edg_wll_RunningEvent;

/**
* \typedef edg_wll_ResubmissionEvent
* structure definition for Resubmission event 
*/
typedef struct _edg_wll_ResubmissionEvent {
_EDG_WLL_EVENT_COMMON
	enum edg_wll_ResubmissionResult	result;	/**< Result code of the resubmission decision (WILLRESUB or WONTRESUB or SHALLOW). */
	char *	reason;	/**< Reason why the job will or will not be resubmitted. */
	char *	tag;	/**< Value of the attribute on which the decision to resubmit the job was based. */
} edg_wll_ResubmissionEvent;

/**
* \typedef edg_wll_DoneEvent
* structure definition for Done event 
*/
typedef struct _edg_wll_DoneEvent {
_EDG_WLL_EVENT_COMMON
	enum edg_wll_DoneStatus_code	status_code;	/**< Reason code for the termination of the job (OK, FAILED or CANCELLED). */
	char *	reason;	/**< Detailed description why the job was terminated. */
	int	exit_code;	/**< Exit code of the job's process. */
} edg_wll_DoneEvent;

/**
* \typedef edg_wll_CancelEvent
* structure definition for Cancel event 
*/
typedef struct _edg_wll_CancelEvent {
_EDG_WLL_EVENT_COMMON
	enum edg_wll_CancelStatus_code	status_code;	/**< Classification of the attempt to cancel the job (REQ, REFUSE, DONE or ABORT). */
	char *	reason;	/**< Detailed description of the attempt to cancel the job, especially the reason of failure. */
} edg_wll_CancelEvent;

/**
* \typedef edg_wll_AbortEvent
* structure definition for Abort event 
*/
typedef struct _edg_wll_AbortEvent {
_EDG_WLL_EVENT_COMMON
	char *	reason;	/**< Reason why the job was aborted by the system. */
} edg_wll_AbortEvent;

/**
* \typedef edg_wll_ClearEvent
* structure definition for Clear event 
*/
typedef struct _edg_wll_ClearEvent {
_EDG_WLL_EVENT_COMMON
	enum edg_wll_ClearReason	reason;	/**< Description of the reason why the job was cleared and the output sandbox removed (USER, TIMEOUT or NOOUTPUT). */
} edg_wll_ClearEvent;

/**
* \typedef edg_wll_PurgeEvent
* structure definition for Purge event 
*/
typedef struct _edg_wll_PurgeEvent {
_EDG_WLL_EVENT_COMMON
} edg_wll_PurgeEvent;

/**
* \typedef edg_wll_MatchEvent
* structure definition for Match event 
*/
typedef struct _edg_wll_MatchEvent {
_EDG_WLL_EVENT_COMMON
	char *	dest_id;	/**< Identification of the queue on the CE that the job could be send to. */
} edg_wll_MatchEvent;

/**
* \typedef edg_wll_PendingEvent
* structure definition for Pending event 
*/
typedef struct _edg_wll_PendingEvent {
_EDG_WLL_EVENT_COMMON
	char *	reason;	/**< Description why the matching CE for the job was not found (yet). */
} edg_wll_PendingEvent;

/**
* \typedef edg_wll_RegJobEvent
* structure definition for RegJob event 
*/
typedef struct _edg_wll_RegJobEvent {
_EDG_WLL_EVENT_COMMON
	char *	jdl;	/**< Job description of the job being registered. */
	char *	ns;	/**< NetworkServer/CE endpoint etc. handling the newly registered job. */
	glite_jobid_t	parent;	/**< Grid job id of the parent job registering this new one. */
	enum edg_wll_RegJobJobtype	jobtype;	/**< Type of the job being registered (SIMPLE, DAG, PARTITIONABLE etc.). */
	int	nsubjobs;	/**< Number of subjobs this job plans to spawn. */
	char *	seed;	/**< Seed for subjob id generation. */
	char *	wms_dn;	/**< DN of WMS handling the job */
} edg_wll_RegJobEvent;

/**
* \typedef edg_wll_ChkptEvent
* structure definition for Chkpt event 
*/
typedef struct _edg_wll_ChkptEvent {
_EDG_WLL_EVENT_COMMON
	char *	tag;	/**< Application specific checkpoint tag. */
	char *	classad;	/**< Application specific checkpoint value. */
} edg_wll_ChkptEvent;

/**
* \typedef edg_wll_ListenerEvent
* structure definition for Listener event 
*/
typedef struct _edg_wll_ListenerEvent {
_EDG_WLL_EVENT_COMMON
	char *	svc_name;	/**< Name of the port instance for interactive job control. */
	char *	svc_host;	/**< Hostname of the interactive job controller. */
	uint16_t	svc_port;	/**< Port number of the interactive job controller. */
} edg_wll_ListenerEvent;

/**
* \typedef edg_wll_CurDescrEvent
* structure definition for CurDescr event 
*/
typedef struct _edg_wll_CurDescrEvent {
_EDG_WLL_EVENT_COMMON
	char *	descr;	/**< Description of the current job transformation (output of the helper). */
} edg_wll_CurDescrEvent;

/**
* \typedef edg_wll_UserTagEvent
* structure definition for UserTag event 
*/
typedef struct _edg_wll_UserTagEvent {
_EDG_WLL_EVENT_COMMON
	char *	name;	/**< Arbitrary user tag name. */
	char *	value;	/**< Arbitrary user tag value. */
} edg_wll_UserTagEvent;

/**
* \typedef edg_wll_ChangeACLEvent
* structure definition for ChangeACL event 
*/
typedef struct _edg_wll_ChangeACLEvent {
_EDG_WLL_EVENT_COMMON
	char *	user_id;	/**< Certificate or VOMS parameter. */
	enum edg_wll_ChangeACLUser_id_type	user_id_type;	/**< Type of information given in user_id. */
	enum edg_wll_ChangeACLPermission	permission;	/**< ACL permission to change. */
	enum edg_wll_ChangeACLPermission_type	permission_type;	/**< Type of permission requested. */
	enum edg_wll_ChangeACLOperation	operation;	/**< Operation requested to perform with ACL. */
} edg_wll_ChangeACLEvent;

/**
* \typedef edg_wll_NotificationEvent
* structure definition for Notification event 
*/
typedef struct _edg_wll_NotificationEvent {
_EDG_WLL_EVENT_COMMON
	edg_wll_NotifId	notifId;	/**< Notification id. */
	char *	owner;	/**< Identification of the job owner (certificate subject). */
	char *	dest_host;	/**< Hostname the notification is sent to. */
	uint16_t	dest_port;	/**< Port number the notification is sent to. */
	int	expires;	/**< When the notification expires */
	char *	jobstat;	/**< Status of the job (the notification content). */
	char *	dest_url;	/**< Destination URL (preferred over host and port). */
} edg_wll_NotificationEvent;

/**
* \typedef edg_wll_ResourceUsageEvent
* structure definition for ResourceUsage event 
*/
typedef struct _edg_wll_ResourceUsageEvent {
_EDG_WLL_EVENT_COMMON
	char *	resource;	/**< Resource's name. */
	double	quantity;	/**< Resources's quantity (how much). */
	char *	unit;	/**< Units (sec, kB, etc.). */
} edg_wll_ResourceUsageEvent;

/**
* \typedef edg_wll_ReallyRunningEvent
* structure definition for ReallyRunning event 
*/
typedef struct _edg_wll_ReallyRunningEvent {
_EDG_WLL_EVENT_COMMON
	char *	wn_seq;	/**< Sequence code on the worker node. */
} edg_wll_ReallyRunningEvent;

/**
* \typedef edg_wll_SuspendEvent
* structure definition for Suspend event 
*/
typedef struct _edg_wll_SuspendEvent {
_EDG_WLL_EVENT_COMMON
	char *	reason;	/**< Reason for the suspend. */
} edg_wll_SuspendEvent;

/**
* \typedef edg_wll_ResumeEvent
* structure definition for Resume event 
*/
typedef struct _edg_wll_ResumeEvent {
_EDG_WLL_EVENT_COMMON
	char *	reason;	/**< Reason for the resume. */
} edg_wll_ResumeEvent;

/**
* \typedef edg_wll_CollectionStateEvent
* structure definition for CollectionState event 
*/
typedef struct _edg_wll_CollectionStateEvent {
_EDG_WLL_EVENT_COMMON
	char *	state;	/**< New collection state. */
	int	done_code;	/**< In case of (state == Done) contains done code  */
	char *	histogram;	/**< User readable histogram; useful for debugging. */
	glite_jobid_t	child;	/**< JobId of subjob, which triggered the state change.	 */
	char *	child_event;	/**< Event which triggered the state change.	 */
} edg_wll_CollectionStateEvent;

/**
* \typedef edg_wll_GrantPayloadOwnershipEvent
* structure definition for GrantPayloadOwnership event 
*/
typedef struct _edg_wll_GrantPayloadOwnershipEvent {
_EDG_WLL_EVENT_COMMON
	char *	payload_owner;	/**< Identity (certificate subject) of the payload owner. */
} edg_wll_GrantPayloadOwnershipEvent;

/**
* \typedef edg_wll_TakePayloadOwnershipEvent
* structure definition for TakePayloadOwnership event 
*/
typedef struct _edg_wll_TakePayloadOwnershipEvent {
_EDG_WLL_EVENT_COMMON
} edg_wll_TakePayloadOwnershipEvent;

/**
* \typedef edg_wll_ConnectJobEvent
* structure definition for ConnectJob event 
*/
typedef struct _edg_wll_ConnectJobEvent {
_EDG_WLL_EVENT_COMMON
	char *	dest_jobid;	/**< ID of connected job */
	enum edg_wll_ConnectJobJobtype	jobtype;	/**< Type of the job being connected (SIMPLE, DAG, PARTITIONABLE etc.). */
} edg_wll_ConnectJobEvent;

/**
* \typedef edg_wll_DisconnectJobEvent
* structure definition for DisconnectJob event 
*/
typedef struct _edg_wll_DisconnectJobEvent {
_EDG_WLL_EVENT_COMMON
	char *	dest_jobid;	/**< ID of connected job */
} edg_wll_DisconnectJobEvent;

/**
* \typedef edg_wll_PBSInternalStateChangeEvent
* structure definition for PBSInternalStateChange event 
*/
typedef struct _edg_wll_PBSInternalStateChangeEvent {
_EDG_WLL_EVENT_COMMON
	int	oldstate;	/**<  */
	int	oldsubstate;	/**<  */
	int	newstate;	/**<  */
	int	newsubstate;	/**<  */
} edg_wll_PBSInternalStateChangeEvent;

/**
* \typedef edg_wll_PBSTransferEvent
* structure definition for PBSTransfer event 
*/
typedef struct _edg_wll_PBSTransferEvent {
_EDG_WLL_EVENT_COMMON
	edg_wll_Source	destination;	/**< Destination where the job is being transfered to. */
	char *	dest_instance;	/**< Service (instance) that takes over control of the job. */
	enum edg_wll_PBSTransferResult	result;	/**< Result code of the transfer attempt (START, OK, REFUSED or FAIL). */
	char *	reason;	/**< Detailed description of the transfer, especially reason of failure. */
	char *	dest_jobid;	/**< Job id as assigned by the receiving software component. */
} edg_wll_PBSTransferEvent;

/**
* \typedef edg_wll_PBSAcceptedEvent
* structure definition for PBSAccepted event 
*/
typedef struct _edg_wll_PBSAcceptedEvent {
_EDG_WLL_EVENT_COMMON
	edg_wll_Source	from;	/**< The software component  the job was received from. */
	char *	from_instance;	/**< Instance of the component the job was received from. */
	char *	local_jobid;	/**< New job id as assigned by the receiving component. */
} edg_wll_PBSAcceptedEvent;

/**
* \typedef edg_wll_PBSRefusedEvent
* structure definition for PBSRefused event 
*/
typedef struct _edg_wll_PBSRefusedEvent {
_EDG_WLL_EVENT_COMMON
	edg_wll_Source	from;	/**< The software component that tried to send the job. */
	char *	from_instance;	/**< Instance of the component that tried to send the job. */
	char *	reason;	/**< Description of the reason why the job was refused. */
} edg_wll_PBSRefusedEvent;

/**
* \typedef edg_wll_PBSQueuedEvent
* structure definition for PBSQueued event 
*/
typedef struct _edg_wll_PBSQueuedEvent {
_EDG_WLL_EVENT_COMMON
	char *	queue;	/**< Queue name */
	char *	name;	/**< Job name */
	char *	owner;	/**< Job owner */
} edg_wll_PBSQueuedEvent;

/**
* \typedef edg_wll_PBSDequeuedEvent
* structure definition for PBSDequeued event 
*/
typedef struct _edg_wll_PBSDequeuedEvent {
_EDG_WLL_EVENT_COMMON
} edg_wll_PBSDequeuedEvent;

/**
* \typedef edg_wll_PBSMatchEvent
* structure definition for PBSMatch event 
*/
typedef struct _edg_wll_PBSMatchEvent {
_EDG_WLL_EVENT_COMMON
	char *	dest_host;	/**< Aka exec host */
} edg_wll_PBSMatchEvent;

/**
* \typedef edg_wll_PBSPendingEvent
* structure definition for PBSPending event 
*/
typedef struct _edg_wll_PBSPendingEvent {
_EDG_WLL_EVENT_COMMON
	char *	reason;	/**< Reasons of job pendation or errors */
} edg_wll_PBSPendingEvent;

/**
* \typedef edg_wll_PBSWaitingEvent
* structure definition for PBSWaiting event 
*/
typedef struct _edg_wll_PBSWaitingEvent {
_EDG_WLL_EVENT_COMMON
} edg_wll_PBSWaitingEvent;

/**
* \typedef edg_wll_PBSRunEvent
* structure definition for PBSRun event 
*/
typedef struct _edg_wll_PBSRunEvent {
_EDG_WLL_EVENT_COMMON
	char *	scheduler;	/**< Scheduler ID */
	char *	dest_host;	/**< Where to run the job */
	int	pid;	/**< Actual process ID */
} edg_wll_PBSRunEvent;

/**
* \typedef edg_wll_PBSRerunEvent
* structure definition for PBSRerun event 
*/
typedef struct _edg_wll_PBSRerunEvent {
_EDG_WLL_EVENT_COMMON
} edg_wll_PBSRerunEvent;

/**
* \typedef edg_wll_PBSAbortEvent
* structure definition for PBSAbort event 
*/
typedef struct _edg_wll_PBSAbortEvent {
_EDG_WLL_EVENT_COMMON
} edg_wll_PBSAbortEvent;

/**
* \typedef edg_wll_PBSDoneEvent
* structure definition for PBSDone event 
*/
typedef struct _edg_wll_PBSDoneEvent {
_EDG_WLL_EVENT_COMMON
	int	exit_status;	/**< Exit status */
} edg_wll_PBSDoneEvent;

/**
* \typedef edg_wll_PBSResourceUsageEvent
* structure definition for PBSResourceUsage event 
*/
typedef struct _edg_wll_PBSResourceUsageEvent {
_EDG_WLL_EVENT_COMMON
	enum edg_wll_PBSResourceUsageUsage	usage;	/**< Type of record */
	edg_wll_TagValue *	resources;	/**< List of resources */
} edg_wll_PBSResourceUsageEvent;

/**
* \typedef edg_wll_PBSErrorEvent
* structure definition for PBSError event 
*/
typedef struct _edg_wll_PBSErrorEvent {
_EDG_WLL_EVENT_COMMON
	char *	error_desc;	/**< Error reason */
} edg_wll_PBSErrorEvent;

/**
* \typedef edg_wll_CondorMatchEvent
* structure definition for CondorMatch event 
*/
typedef struct _edg_wll_CondorMatchEvent {
_EDG_WLL_EVENT_COMMON
	char *	owner;	/**< Owner */
	char *	dest_host;	/**< Matched host */
	char *	preempting;	/**< Preempting */
} edg_wll_CondorMatchEvent;

/**
* \typedef edg_wll_CondorRejectEvent
* structure definition for CondorReject event 
*/
typedef struct _edg_wll_CondorRejectEvent {
_EDG_WLL_EVENT_COMMON
	char *	owner;	/**< Owner */
	enum edg_wll_CondorRejectStatus_code	status_code;	/**< Reason code for the rejection of the job */
} edg_wll_CondorRejectEvent;

/**
* \typedef edg_wll_CondorShadowStartedEvent
* structure definition for CondorShadowStarted event 
*/
typedef struct _edg_wll_CondorShadowStartedEvent {
_EDG_WLL_EVENT_COMMON
	char *	shadow_host;	/**< Shadow host */
	uint16_t	shadow_port;	/**< Shadow port */
	int	shadow_pid;	/**< PID of shadow process */
	char *	shadow_status;	/**< Shadow status */
} edg_wll_CondorShadowStartedEvent;

/**
* \typedef edg_wll_CondorShadowExitedEvent
* structure definition for CondorShadowExited event 
*/
typedef struct _edg_wll_CondorShadowExitedEvent {
_EDG_WLL_EVENT_COMMON
	int	shadow_pid;	/**< PID of shadow process */
	int	shadow_exit_status;	/**< Exit status of shadow process */
} edg_wll_CondorShadowExitedEvent;

/**
* \typedef edg_wll_CondorStarterStartedEvent
* structure definition for CondorStarterStarted event 
*/
typedef struct _edg_wll_CondorStarterStartedEvent {
_EDG_WLL_EVENT_COMMON
	int	starter_pid;	/**< PID of starter process */
	char *	universe;	/**< Condor Universe */
} edg_wll_CondorStarterStartedEvent;

/**
* \typedef edg_wll_CondorStarterExitedEvent
* structure definition for CondorStarterExited event 
*/
typedef struct _edg_wll_CondorStarterExitedEvent {
_EDG_WLL_EVENT_COMMON
	int	starter_pid;	/**< PID of starter process */
	int	starter_exit_status;	/**< Exit status of starter process */
	int	job_pid;	/**< PID of running job */
	int	job_exit_status;	/**< Job exit status */
} edg_wll_CondorStarterExitedEvent;

/**
* \typedef edg_wll_CondorResourceUsageEvent
* structure definition for CondorResourceUsage event 
*/
typedef struct _edg_wll_CondorResourceUsageEvent {
_EDG_WLL_EVENT_COMMON
	enum edg_wll_CondorResourceUsageUsage	usage;	/**< Type of record */
	char *	name;	/**< Name of resource */
	double	quantity;	/**< The quantity */
	char *	unit;	/**< Units (sec, kB, etc.) */
} edg_wll_CondorResourceUsageEvent;

/**
* \typedef edg_wll_CondorErrorEvent
* structure definition for CondorError event 
*/
typedef struct _edg_wll_CondorErrorEvent {
_EDG_WLL_EVENT_COMMON
	char *	error_desc;	/**< Error reason */
} edg_wll_CondorErrorEvent;

/**
* \typedef edg_wll_CREAMStartEvent
* structure definition for CREAMStart event 
*/
typedef struct _edg_wll_CREAMStartEvent {
_EDG_WLL_EVENT_COMMON
} edg_wll_CREAMStartEvent;

/**
* \typedef edg_wll_CREAMPurgeEvent
* structure definition for CREAMPurge event 
*/
typedef struct _edg_wll_CREAMPurgeEvent {
_EDG_WLL_EVENT_COMMON
} edg_wll_CREAMPurgeEvent;

/**
* \typedef edg_wll_CREAMAcceptedEvent
* structure definition for CREAMAccepted event 
*/
typedef struct _edg_wll_CREAMAcceptedEvent {
_EDG_WLL_EVENT_COMMON
	char *	local_jobid;	/**< New job id as assigned by the receiving component. */
} edg_wll_CREAMAcceptedEvent;

/**
* \typedef edg_wll_CREAMStoreEvent
* structure definition for CREAMStore event 
*/
typedef struct _edg_wll_CREAMStoreEvent {
_EDG_WLL_EVENT_COMMON
	enum edg_wll_CREAMStoreCommand	command;	/**< Command to store */
	char *	cmdid;	/**< Id of the command in store */
	enum edg_wll_CREAMStoreResult	result;	/**< store phase/result */
	char *	reason;	/**< failure_reason */
} edg_wll_CREAMStoreEvent;

/**
* \typedef edg_wll_CREAMCallEvent
* structure definition for CREAMCall event 
*/
typedef struct _edg_wll_CREAMCallEvent {
_EDG_WLL_EVENT_COMMON
	enum edg_wll_CREAMCallCommand	command;	/**< Command to store */
	edg_wll_Source	callee;	/**< Called component */
	char *	cmdid;	/**< Id of the command, as stored previously */
	char *	destid;	/**< Destination ID */
	enum edg_wll_CREAMCallResult	result;	/**< Result code of the CREAM call (START, OK, REFUSED or FAIL) */
	char *	reason;	/**< Reason for the possible CREAM call failure */
} edg_wll_CREAMCallEvent;

/**
* \typedef edg_wll_CREAMRunningEvent
* structure definition for CREAMRunning event 
*/
typedef struct _edg_wll_CREAMRunningEvent {
_EDG_WLL_EVENT_COMMON
	char *	node;	/**< Node where CREAM job is running */
} edg_wll_CREAMRunningEvent;

/**
* \typedef edg_wll_CREAMReallyRunningEvent
* structure definition for CREAMReallyRunning event 
*/
typedef struct _edg_wll_CREAMReallyRunningEvent {
_EDG_WLL_EVENT_COMMON
} edg_wll_CREAMReallyRunningEvent;

/**
* \typedef edg_wll_CREAMDoneEvent
* structure definition for CREAMDone event 
*/
typedef struct _edg_wll_CREAMDoneEvent {
_EDG_WLL_EVENT_COMMON
	enum edg_wll_CREAMDoneStatus_code	status_code;	/**< Status code of the CREAM Done */
	char *	reason;	/**< Reason for the status */
	char *	exit_code;	/**< Exit code */
} edg_wll_CREAMDoneEvent;

/**
* \typedef edg_wll_CREAMCancelEvent
* structure definition for CREAMCancel event 
*/
typedef struct _edg_wll_CREAMCancelEvent {
_EDG_WLL_EVENT_COMMON
	enum edg_wll_CREAMCancelStatus_code	status_code;	/**< Status code of CREAM Cancel */
	char *	reason;	/**< Reason for cancelling the job */
} edg_wll_CREAMCancelEvent;

/**
* \typedef edg_wll_CREAMAbortEvent
* structure definition for CREAMAbort event 
*/
typedef struct _edg_wll_CREAMAbortEvent {
_EDG_WLL_EVENT_COMMON
	char *	reason;	/**< Reason for aborting the job */
} edg_wll_CREAMAbortEvent;

/**
* \typedef edg_wll_CREAMStatusEvent
* structure definition for CREAMStatus event 
*/
typedef struct _edg_wll_CREAMStatusEvent {
_EDG_WLL_EVENT_COMMON
	char *	old_state;	/**< Old status */
	char *	new_state;	/**< New status */
	struct timeval	orig_timestamp;	/**< Original timestamp of the job state change */
	enum edg_wll_CREAMStatusResult	result;	/**< Result of the job state change */
	char *	descr;	/**< More detailed description */
	char *	exit_code;	/**< Exit code */
	char *	failure_reason;	/**< Reason for the failure */
	char *	worker_node;	/**< Worker node */
	char *	LRMS_jobid;	/**< jobId from the LRMS */
} edg_wll_CREAMStatusEvent;

/**
* \typedef edg_wll_CREAMSuspendEvent
* structure definition for CREAMSuspend event 
*/
typedef struct _edg_wll_CREAMSuspendEvent {
_EDG_WLL_EVENT_COMMON
	enum edg_wll_CREAMSuspendStatus_code	status_code;	/**< Classification of the attempt to suspend the job (REQ, REFUSE, DONE or ABORT). */
	char *	reason;	/**< Reason for the suspend. */
} edg_wll_CREAMSuspendEvent;

/**
* \typedef edg_wll_CREAMResumeEvent
* structure definition for CREAMResume event 
*/
typedef struct _edg_wll_CREAMResumeEvent {
_EDG_WLL_EVENT_COMMON
	enum edg_wll_CREAMResumeStatus_code	status_code;	/**< Classification of the attempt to resume the job (REQ, REFUSE, DONE or ABORT). */
	char *	reason;	/**< Reason for the resume. */
} edg_wll_CREAMResumeEvent;

/**
* \typedef edg_wll_FileTransferRegisterEvent
* structure definition for FileTransferRegister event 
*/
typedef struct _edg_wll_FileTransferRegisterEvent {
_EDG_WLL_EVENT_COMMON
	char *	src;	/**< Source of file transfer. */
	char *	dest;	/**< Destination of file transfer. */
} edg_wll_FileTransferRegisterEvent;

/**
* \typedef edg_wll_FileTransferEvent
* structure definition for FileTransfer event 
*/
typedef struct _edg_wll_FileTransferEvent {
_EDG_WLL_EVENT_COMMON
	enum edg_wll_FileTransferResult	result;	/**< Result code of the file transfer attemp. */
	char *	reason;	/**< The reason of file transfer failure. */
} edg_wll_FileTransferEvent;

/**
* \typedef edg_wll_SandboxEvent
* structure definition for Sandbox event 
*/
typedef struct _edg_wll_SandboxEvent {
_EDG_WLL_EVENT_COMMON
	enum edg_wll_SandboxSandbox_type	sandbox_type;	/**< Type of sandbox. */
	char *	transfer_job;	/**< Jobid of transfer job (collection) containing set of file transfers (subjobs). */
	char *	compute_job;	/**< Jobid of (compute) job the sandbox belongs. Exclusive with transfer_job. */
} edg_wll_SandboxEvent;

/**
* \typedef edg_wll_VMCreateEvent
* structure definition for VMCreate event 
*/
typedef struct _edg_wll_VMCreateEvent {
_EDG_WLL_EVENT_COMMON
	char *	require;	/**< machine requirements */
	char *	id;	/**< machine id */
	char *	name;	/**< machine name */
	char *	owner;	/**< machine owner */
	char *	hostname;	/**< hostname of VM */
	char *	manager;	/**< VM manager */
	char *	image;	/**< machine image */
} edg_wll_VMCreateEvent;

/**
* \typedef edg_wll_VMHostEvent
* structure definition for VMHost event 
*/
typedef struct _edg_wll_VMHostEvent {
_EDG_WLL_EVENT_COMMON
	char *	hostname;	/**< hostname of physical machine of VM */
} edg_wll_VMHostEvent;

/**
* \typedef edg_wll_VMImageEvent
* structure definition for VMImage event 
*/
typedef struct _edg_wll_VMImageEvent {
_EDG_WLL_EVENT_COMMON
	char *	image;	/**< machine image */
} edg_wll_VMImageEvent;

/**
* \typedef edg_wll_VMRunningEvent
* structure definition for VMRunning event 
*/
typedef struct _edg_wll_VMRunningEvent {
_EDG_WLL_EVENT_COMMON
} edg_wll_VMRunningEvent;

/**
* \typedef edg_wll_VMShutdownEvent
* structure definition for VMShutdown event 
*/
typedef struct _edg_wll_VMShutdownEvent {
_EDG_WLL_EVENT_COMMON
	char *	usage;	/**<  */
} edg_wll_VMShutdownEvent;

/**
* \typedef edg_wll_VMStopEvent
* structure definition for VMStop event 
*/
typedef struct _edg_wll_VMStopEvent {
_EDG_WLL_EVENT_COMMON
} edg_wll_VMStopEvent;

/**
* \typedef edg_wll_VMResumeEvent
* structure definition for VMResume event 
*/
typedef struct _edg_wll_VMResumeEvent {
_EDG_WLL_EVENT_COMMON
} edg_wll_VMResumeEvent;

/**
* \typedef edg_wll_VMDoneEvent
* structure definition for VMDone event 
*/
typedef struct _edg_wll_VMDoneEvent {
_EDG_WLL_EVENT_COMMON
	enum edg_wll_VMDoneStatus_code	status_code;	/**<  */
	char *	usage;	/**<  */
} edg_wll_VMDoneEvent;

#undef _EDG_WLL_EVENT_COMMON


/**
 * \union edg_wll_Event
 * \brief All event types union
 */
glite_lb_padded_union(_edg_wll_Event,32,
        edg_wll_EventCode           type; /* it is probably never used */
        edg_wll_AnyEvent            any;
	edg_wll_TransferEvent	transfer;
	edg_wll_AcceptedEvent	accepted;
	edg_wll_RefusedEvent	refused;
	edg_wll_EnQueuedEvent	enQueued;
	edg_wll_DeQueuedEvent	deQueued;
	edg_wll_HelperCallEvent	helperCall;
	edg_wll_HelperReturnEvent	helperReturn;
	edg_wll_RunningEvent	running;
	edg_wll_ResubmissionEvent	resubmission;
	edg_wll_DoneEvent	done;
	edg_wll_CancelEvent	cancel;
	edg_wll_AbortEvent	abort;
	edg_wll_ClearEvent	clear;
	edg_wll_PurgeEvent	purge;
	edg_wll_MatchEvent	match;
	edg_wll_PendingEvent	pending;
	edg_wll_RegJobEvent	regJob;
	edg_wll_ChkptEvent	chkpt;
	edg_wll_ListenerEvent	listener;
	edg_wll_CurDescrEvent	curDescr;
	edg_wll_UserTagEvent	userTag;
	edg_wll_ChangeACLEvent	changeACL;
	edg_wll_NotificationEvent	notification;
	edg_wll_ResourceUsageEvent	resourceUsage;
	edg_wll_ReallyRunningEvent	reallyRunning;
	edg_wll_SuspendEvent	suspend;
	edg_wll_ResumeEvent	resume;
	edg_wll_CollectionStateEvent	collectionState;
	edg_wll_GrantPayloadOwnershipEvent	grantPayloadOwnership;
	edg_wll_TakePayloadOwnershipEvent	takePayloadOwnership;
	edg_wll_ConnectJobEvent	connectJob;
	edg_wll_DisconnectJobEvent	disconnectJob;
	edg_wll_PBSInternalStateChangeEvent	PBSInternalStateChange;
	edg_wll_PBSTransferEvent	PBSTransfer;
	edg_wll_PBSAcceptedEvent	PBSAccepted;
	edg_wll_PBSRefusedEvent	PBSRefused;
	edg_wll_PBSQueuedEvent	PBSQueued;
	edg_wll_PBSDequeuedEvent	PBSDequeued;
	edg_wll_PBSMatchEvent	PBSMatch;
	edg_wll_PBSPendingEvent	PBSPending;
	edg_wll_PBSWaitingEvent	PBSWaiting;
	edg_wll_PBSRunEvent	PBSRun;
	edg_wll_PBSRerunEvent	PBSRerun;
	edg_wll_PBSAbortEvent	PBSAbort;
	edg_wll_PBSDoneEvent	PBSDone;
	edg_wll_PBSResourceUsageEvent	PBSResourceUsage;
	edg_wll_PBSErrorEvent	PBSError;
	edg_wll_CondorMatchEvent	CondorMatch;
	edg_wll_CondorRejectEvent	CondorReject;
	edg_wll_CondorShadowStartedEvent	CondorShadowStarted;
	edg_wll_CondorShadowExitedEvent	CondorShadowExited;
	edg_wll_CondorStarterStartedEvent	CondorStarterStarted;
	edg_wll_CondorStarterExitedEvent	CondorStarterExited;
	edg_wll_CondorResourceUsageEvent	CondorResourceUsage;
	edg_wll_CondorErrorEvent	CondorError;
	edg_wll_CREAMStartEvent	CREAMStart;
	edg_wll_CREAMPurgeEvent	CREAMPurge;
	edg_wll_CREAMAcceptedEvent	CREAMAccepted;
	edg_wll_CREAMStoreEvent	CREAMStore;
	edg_wll_CREAMCallEvent	CREAMCall;
	edg_wll_CREAMRunningEvent	CREAMRunning;
	edg_wll_CREAMReallyRunningEvent	CREAMReallyRunning;
	edg_wll_CREAMDoneEvent	CREAMDone;
	edg_wll_CREAMCancelEvent	CREAMCancel;
	edg_wll_CREAMAbortEvent	CREAMAbort;
	edg_wll_CREAMStatusEvent	CREAMStatus;
	edg_wll_CREAMSuspendEvent	CREAMSuspend;
	edg_wll_CREAMResumeEvent	CREAMResume;
	edg_wll_FileTransferRegisterEvent	fileTransferRegister;
	edg_wll_FileTransferEvent	fileTransfer;
	edg_wll_SandboxEvent	sandbox;
	edg_wll_VMCreateEvent	vMCreate;
	edg_wll_VMHostEvent	vMHost;
	edg_wll_VMImageEvent	vMImage;
	edg_wll_VMRunningEvent	vMRunning;
	edg_wll_VMShutdownEvent	vMShutdown;
	edg_wll_VMStopEvent	vMStop;
	edg_wll_VMResumeEvent	vMResume;
	edg_wll_VMDoneEvent	vMDone;
)
typedef union _edg_wll_Event edg_wll_Event;


/**
 * Initialise an event structure
 * \return pointer to initialised event structure
 */
extern edg_wll_Event *edg_wll_InitEvent(edg_wll_EventCode eventcode);


/**
 * Free the contents of event structure
 * \param[in] event 		structure to be freed
 * \warning As event structures are likely to be allocated in arrays,
 *      the structure itself is not freed.
 *      Its the responsibility of the caller to call free(event)
 *      if appropriate.
 */
void edg_wll_FreeEvent(
	edg_wll_Event * event
);


/* Event formats: */

#define EDG_WLL_FORMAT_COMMON	"DATE=%s HOST=\"%|Us\" PROG=edg-wms LVL=%s DG.PRIORITY=%d DG.SOURCE=\"%|Us\" DG.SRC_INSTANCE=\"%|Us\" DG.EVNT=\"%s\" DG.JOBID=\"%s\" DG.SEQCODE=\"%|Us\" "
#define EDG_WLL_FORMAT_USER	"DG.USER=\"%|Us\" "
#define EDG_WLL_FORMAT_TRANSFER	"DG.TRANSFER.DESTINATION=\"%s\" DG.TRANSFER.DEST_HOST=\"%|Us\" DG.TRANSFER.DEST_INSTANCE=\"%|Us\" DG.TRANSFER.JOB=\"%|Us\" DG.TRANSFER.RESULT=\"%s\" DG.TRANSFER.REASON=\"%|Us\" DG.TRANSFER.DEST_JOBID=\"%|Us\" "
#define EDG_WLL_FORMAT_ACCEPTED	"DG.ACCEPTED.FROM=\"%s\" DG.ACCEPTED.FROM_HOST=\"%|Us\" DG.ACCEPTED.FROM_INSTANCE=\"%|Us\" DG.ACCEPTED.LOCAL_JOBID=\"%|Us\" "
#define EDG_WLL_FORMAT_REFUSED	"DG.REFUSED.FROM=\"%s\" DG.REFUSED.FROM_HOST=\"%|Us\" DG.REFUSED.FROM_INSTANCE=\"%|Us\" DG.REFUSED.REASON=\"%|Us\" "
#define EDG_WLL_FORMAT_ENQUEUED	"DG.ENQUEUED.QUEUE=\"%|Us\" DG.ENQUEUED.JOB=\"%|Us\" DG.ENQUEUED.RESULT=\"%s\" DG.ENQUEUED.REASON=\"%|Us\" "
#define EDG_WLL_FORMAT_DEQUEUED	"DG.DEQUEUED.QUEUE=\"%|Us\" DG.DEQUEUED.LOCAL_JOBID=\"%|Us\" "
#define EDG_WLL_FORMAT_HELPERCALL	"DG.HELPERCALL.HELPER_NAME=\"%|Us\" DG.HELPERCALL.HELPER_PARAMS=\"%|Us\" DG.HELPERCALL.SRC_ROLE=\"%s\" "
#define EDG_WLL_FORMAT_HELPERRETURN	"DG.HELPERRETURN.HELPER_NAME=\"%|Us\" DG.HELPERRETURN.RETVAL=\"%|Us\" DG.HELPERRETURN.SRC_ROLE=\"%s\" "
#define EDG_WLL_FORMAT_RUNNING	"DG.RUNNING.NODE=\"%|Us\" "
#define EDG_WLL_FORMAT_RESUBMISSION	"DG.RESUBMISSION.RESULT=\"%s\" DG.RESUBMISSION.REASON=\"%|Us\" DG.RESUBMISSION.TAG=\"%|Us\" "
#define EDG_WLL_FORMAT_DONE	"DG.DONE.STATUS_CODE=\"%s\" DG.DONE.REASON=\"%|Us\" DG.DONE.EXIT_CODE=\"%d\" "
#define EDG_WLL_FORMAT_CANCEL	"DG.CANCEL.STATUS_CODE=\"%s\" DG.CANCEL.REASON=\"%|Us\" "
#define EDG_WLL_FORMAT_ABORT	"DG.ABORT.REASON=\"%|Us\" "
#define EDG_WLL_FORMAT_CLEAR	"DG.CLEAR.REASON=\"%s\" "
#define EDG_WLL_FORMAT_PURGE	""
#define EDG_WLL_FORMAT_MATCH	"DG.MATCH.DEST_ID=\"%|Us\" "
#define EDG_WLL_FORMAT_PENDING	"DG.PENDING.REASON=\"%|Us\" "
#define EDG_WLL_FORMAT_REGJOB	"DG.REGJOB.JDL=\"%|Us\" DG.REGJOB.NS=\"%|Us\" DG.REGJOB.PARENT=\"%s\" DG.REGJOB.JOBTYPE=\"%s\" DG.REGJOB.NSUBJOBS=\"%d\" DG.REGJOB.SEED=\"%|Us\" DG.REGJOB.WMS_DN=\"%|Us\" "
#define EDG_WLL_FORMAT_CHKPT	"DG.CHKPT.TAG=\"%|Us\" DG.CHKPT.CLASSAD=\"%|Us\" "
#define EDG_WLL_FORMAT_LISTENER	"DG.LISTENER.SVC_NAME=\"%|Us\" DG.LISTENER.SVC_HOST=\"%|Us\" DG.LISTENER.SVC_PORT=\"%d\" "
#define EDG_WLL_FORMAT_CURDESCR	"DG.CURDESCR.DESCR=\"%|Us\" "
#define EDG_WLL_FORMAT_USERTAG	"DG.USERTAG.NAME=\"%|Us\" DG.USERTAG.VALUE=\"%|Us\" "
#define EDG_WLL_FORMAT_CHANGEACL	"DG.CHANGEACL.USER_ID=\"%|Us\" DG.CHANGEACL.USER_ID_TYPE=\"%s\" DG.CHANGEACL.PERMISSION=\"%s\" DG.CHANGEACL.PERMISSION_TYPE=\"%s\" DG.CHANGEACL.OPERATION=\"%s\" "
#define EDG_WLL_FORMAT_NOTIFICATION	"DG.NOTIFICATION.NOTIFID=\"%s\" DG.NOTIFICATION.OWNER=\"%|Us\" DG.NOTIFICATION.DEST_HOST=\"%|Us\" DG.NOTIFICATION.DEST_PORT=\"%d\" DG.NOTIFICATION.EXPIRES=\"%d\" DG.NOTIFICATION.JOBSTAT=\"%|Us\" DG.NOTIFICATION.DEST_URL=\"%|Us\" "
#define EDG_WLL_FORMAT_RESOURCEUSAGE	"DG.RESOURCEUSAGE.RESOURCE=\"%|Us\" DG.RESOURCEUSAGE.QUANTITY=\"%f\" DG.RESOURCEUSAGE.UNIT=\"%|Us\" "
#define EDG_WLL_FORMAT_REALLYRUNNING	"DG.REALLYRUNNING.WN_SEQ=\"%|Us\" "
#define EDG_WLL_FORMAT_SUSPEND	"DG.SUSPEND.REASON=\"%|Us\" "
#define EDG_WLL_FORMAT_RESUME	"DG.RESUME.REASON=\"%|Us\" "
#define EDG_WLL_FORMAT_COLLECTIONSTATE	"DG.COLLECTIONSTATE.STATE=\"%|Us\" DG.COLLECTIONSTATE.DONE_CODE=\"%d\" DG.COLLECTIONSTATE.HISTOGRAM=\"%|Us\" DG.COLLECTIONSTATE.CHILD=\"%s\" DG.COLLECTIONSTATE.CHILD_EVENT=\"%|Us\" "
#define EDG_WLL_FORMAT_GRANTPAYLOADOWNERSHIP	"DG.GRANTPAYLOADOWNERSHIP.PAYLOAD_OWNER=\"%|Us\" "
#define EDG_WLL_FORMAT_TAKEPAYLOADOWNERSHIP	""
#define EDG_WLL_FORMAT_CONNECTJOB	"DG.CONNECTJOB.DEST_JOBID=\"%|Us\" DG.CONNECTJOB.JOBTYPE=\"%s\" "
#define EDG_WLL_FORMAT_DISCONNECTJOB	"DG.DISCONNECTJOB.DEST_JOBID=\"%|Us\" "
#define EDG_WLL_FORMAT_PBSINTERNALSTATECHANGE	"DG.PBSINTERNALSTATECHANGE.OLDSTATE=\"%d\" DG.PBSINTERNALSTATECHANGE.OLDSUBSTATE=\"%d\" DG.PBSINTERNALSTATECHANGE.NEWSTATE=\"%d\" DG.PBSINTERNALSTATECHANGE.NEWSUBSTATE=\"%d\" "
#define EDG_WLL_FORMAT_PBSTRANSFER	"DG.PBSTRANSFER.DESTINATION=\"%s\" DG.PBSTRANSFER.DEST_INSTANCE=\"%|Us\" DG.PBSTRANSFER.RESULT=\"%s\" DG.PBSTRANSFER.REASON=\"%|Us\" DG.PBSTRANSFER.DEST_JOBID=\"%|Us\" "
#define EDG_WLL_FORMAT_PBSACCEPTED	"DG.PBSACCEPTED.FROM=\"%s\" DG.PBSACCEPTED.FROM_INSTANCE=\"%|Us\" DG.PBSACCEPTED.LOCAL_JOBID=\"%|Us\" "
#define EDG_WLL_FORMAT_PBSREFUSED	"DG.PBSREFUSED.FROM=\"%s\" DG.PBSREFUSED.FROM_INSTANCE=\"%|Us\" DG.PBSREFUSED.REASON=\"%|Us\" "
#define EDG_WLL_FORMAT_PBSQUEUED	"DG.PBSQUEUED.QUEUE=\"%|Us\" DG.PBSQUEUED.NAME=\"%|Us\" DG.PBSQUEUED.OWNER=\"%|Us\" "
#define EDG_WLL_FORMAT_PBSDEQUEUED	""
#define EDG_WLL_FORMAT_PBSMATCH	"DG.PBSMATCH.DEST_HOST=\"%|Us\" "
#define EDG_WLL_FORMAT_PBSPENDING	"DG.PBSPENDING.REASON=\"%|Us\" "
#define EDG_WLL_FORMAT_PBSWAITING	""
#define EDG_WLL_FORMAT_PBSRUN	"DG.PBSRUN.SCHEDULER=\"%|Us\" DG.PBSRUN.DEST_HOST=\"%|Us\" DG.PBSRUN.PID=\"%d\" "
#define EDG_WLL_FORMAT_PBSRERUN	""
#define EDG_WLL_FORMAT_PBSABORT	""
#define EDG_WLL_FORMAT_PBSDONE	"DG.PBSDONE.EXIT_STATUS=\"%d\" "
#define EDG_WLL_FORMAT_PBSRESOURCEUSAGE	"DG.PBSRESOURCEUSAGE.USAGE=\"%s\" DG.PBSRESOURCEUSAGE.RESOURCES=\"%s\" "
#define EDG_WLL_FORMAT_PBSERROR	"DG.PBSERROR.ERROR_DESC=\"%|Us\" "
#define EDG_WLL_FORMAT_CONDORMATCH	"DG.CONDORMATCH.OWNER=\"%|Us\" DG.CONDORMATCH.DEST_HOST=\"%|Us\" DG.CONDORMATCH.PREEMPTING=\"%|Us\" "
#define EDG_WLL_FORMAT_CONDORREJECT	"DG.CONDORREJECT.OWNER=\"%|Us\" DG.CONDORREJECT.STATUS_CODE=\"%s\" "
#define EDG_WLL_FORMAT_CONDORSHADOWSTARTED	"DG.CONDORSHADOWSTARTED.SHADOW_HOST=\"%|Us\" DG.CONDORSHADOWSTARTED.SHADOW_PORT=\"%d\" DG.CONDORSHADOWSTARTED.SHADOW_PID=\"%d\" DG.CONDORSHADOWSTARTED.SHADOW_STATUS=\"%|Us\" "
#define EDG_WLL_FORMAT_CONDORSHADOWEXITED	"DG.CONDORSHADOWEXITED.SHADOW_PID=\"%d\" DG.CONDORSHADOWEXITED.SHADOW_EXIT_STATUS=\"%d\" "
#define EDG_WLL_FORMAT_CONDORSTARTERSTARTED	"DG.CONDORSTARTERSTARTED.STARTER_PID=\"%d\" DG.CONDORSTARTERSTARTED.UNIVERSE=\"%|Us\" "
#define EDG_WLL_FORMAT_CONDORSTARTEREXITED	"DG.CONDORSTARTEREXITED.STARTER_PID=\"%d\" DG.CONDORSTARTEREXITED.STARTER_EXIT_STATUS=\"%d\" DG.CONDORSTARTEREXITED.JOB_PID=\"%d\" DG.CONDORSTARTEREXITED.JOB_EXIT_STATUS=\"%d\" "
#define EDG_WLL_FORMAT_CONDORRESOURCEUSAGE	"DG.CONDORRESOURCEUSAGE.USAGE=\"%s\" DG.CONDORRESOURCEUSAGE.NAME=\"%|Us\" DG.CONDORRESOURCEUSAGE.QUANTITY=\"%f\" DG.CONDORRESOURCEUSAGE.UNIT=\"%|Us\" "
#define EDG_WLL_FORMAT_CONDORERROR	"DG.CONDORERROR.ERROR_DESC=\"%|Us\" "
#define EDG_WLL_FORMAT_CREAMSTART	""
#define EDG_WLL_FORMAT_CREAMPURGE	""
#define EDG_WLL_FORMAT_CREAMACCEPTED	"DG.CREAMACCEPTED.LOCAL_JOBID=\"%|Us\" "
#define EDG_WLL_FORMAT_CREAMSTORE	"DG.CREAMSTORE.COMMAND=\"%s\" DG.CREAMSTORE.CMDID=\"%|Us\" DG.CREAMSTORE.RESULT=\"%s\" DG.CREAMSTORE.REASON=\"%|Us\" "
#define EDG_WLL_FORMAT_CREAMCALL	"DG.CREAMCALL.COMMAND=\"%s\" DG.CREAMCALL.CALLEE=\"%s\" DG.CREAMCALL.CMDID=\"%|Us\" DG.CREAMCALL.DESTID=\"%|Us\" DG.CREAMCALL.RESULT=\"%s\" DG.CREAMCALL.REASON=\"%|Us\" "
#define EDG_WLL_FORMAT_CREAMRUNNING	"DG.CREAMRUNNING.NODE=\"%|Us\" "
#define EDG_WLL_FORMAT_CREAMREALLYRUNNING	""
#define EDG_WLL_FORMAT_CREAMDONE	"DG.CREAMDONE.STATUS_CODE=\"%s\" DG.CREAMDONE.REASON=\"%|Us\" DG.CREAMDONE.EXIT_CODE=\"%|Us\" "
#define EDG_WLL_FORMAT_CREAMCANCEL	"DG.CREAMCANCEL.STATUS_CODE=\"%s\" DG.CREAMCANCEL.REASON=\"%|Us\" "
#define EDG_WLL_FORMAT_CREAMABORT	"DG.CREAMABORT.REASON=\"%|Us\" "
#define EDG_WLL_FORMAT_CREAMSTATUS	"DG.CREAMSTATUS.OLD_STATE=\"%|Us\" DG.CREAMSTATUS.NEW_STATE=\"%|Us\" DG.CREAMSTATUS.ORIG_TIMESTAMP=\"%s\" DG.CREAMSTATUS.RESULT=\"%s\" DG.CREAMSTATUS.DESCR=\"%|Us\" DG.CREAMSTATUS.EXIT_CODE=\"%|Us\" DG.CREAMSTATUS.FAILURE_REASON=\"%|Us\" DG.CREAMSTATUS.WORKER_NODE=\"%|Us\" DG.CREAMSTATUS.LRMS_JOBID=\"%|Us\" "
#define EDG_WLL_FORMAT_CREAMSUSPEND	"DG.CREAMSUSPEND.STATUS_CODE=\"%s\" DG.CREAMSUSPEND.REASON=\"%|Us\" "
#define EDG_WLL_FORMAT_CREAMRESUME	"DG.CREAMRESUME.STATUS_CODE=\"%s\" DG.CREAMRESUME.REASON=\"%|Us\" "
#define EDG_WLL_FORMAT_FILETRANSFERREGISTER	"DG.FILETRANSFERREGISTER.SRC=\"%|Us\" DG.FILETRANSFERREGISTER.DEST=\"%|Us\" "
#define EDG_WLL_FORMAT_FILETRANSFER	"DG.FILETRANSFER.RESULT=\"%s\" DG.FILETRANSFER.REASON=\"%|Us\" "
#define EDG_WLL_FORMAT_SANDBOX	"DG.SANDBOX.SANDBOX_TYPE=\"%s\" DG.SANDBOX.TRANSFER_JOB=\"%|Us\" DG.SANDBOX.COMPUTE_JOB=\"%|Us\" "
#define EDG_WLL_FORMAT_VMCREATE	"DG.VMCREATE.REQUIRE=\"%|Us\" DG.VMCREATE.ID=\"%|Us\" DG.VMCREATE.NAME=\"%|Us\" DG.VMCREATE.OWNER=\"%|Us\" DG.VMCREATE.HOSTNAME=\"%|Us\" DG.VMCREATE.MANAGER=\"%|Us\" DG.VMCREATE.IMAGE=\"%|Us\" "
#define EDG_WLL_FORMAT_VMHOST	"DG.VMHOST.HOSTNAME=\"%|Us\" "
#define EDG_WLL_FORMAT_VMIMAGE	"DG.VMIMAGE.IMAGE=\"%|Us\" "
#define EDG_WLL_FORMAT_VMRUNNING	""
#define EDG_WLL_FORMAT_VMSHUTDOWN	"DG.VMSHUTDOWN.USAGE=\"%|Us\" "
#define EDG_WLL_FORMAT_VMSTOP	""
#define EDG_WLL_FORMAT_VMRESUME	""
#define EDG_WLL_FORMAT_VMDONE	"DG.VMDONE.STATUS_CODE=\"%s\" DG.VMDONE.USAGE=\"%|Us\" "
#define EDG_WLL_FORMAT_NOTIFICATION_COMMON	"DATE=%s HOST=\"%|Us\" PROG=edg-wms LVL=%s DG.SOURCE=\"%|Us\" DG.SRC_INSTANCE=\"%|Us\" DG.TYPE=\"notification\" "
#define EDG_WLL_FORMAT_SYSCMPSTAT	"DG.SCHED.STATUS=\"%|Us\" "
#define EDG_WLL_FORMAT_SYSCLSTAT	"DG.SCHED.NODE=\"%|Us\" DG.SCHED.STATUS=\"%|Us\" "


/* Flags (priority bits) defining the type of logging */

#define EDG_WLL_LOGFLAG_ASYNC		0 /**< asynchronous logging */
#define EDG_WLL_LOGFLAG_SYNC_COMPAT	1 /**< synchronous logging in previous versions*/
#define EDG_WLL_LOGFLAG_SYNC		2 /**< synchronous logging */
#define EDG_WLL_LOGFLAG_LOCAL		4 /**< logging to local logger */
#define EDG_WLL_LOGFLAG_PROXY		8 /**< logging to L&B Proxy */
#define EDG_WLL_LOGFLAG_DIRECT		16 /**< logging directly to bkserver */
#define EDG_WLL_LOGFLAG_INTERNAL	32 /**< internally generated event, don't forward */
#define EDG_WLL_LOGLFLAG_EXCL		64 /**< exclusive flag, to be used with RegisterJob only (if job already exists, than registration fails) */
#define EDG_WLL_LOGFLAG_FILE		128 /**< logging to local file to be consumed by IL (IL must be running on the same node, which is not a typical setup) */

/*
 *@} end of group
 */

#ifdef __cplusplus
}
#endif

#endif /* GLITE_LB_EVENTS_H */
