/*
 * Decompiled with CFR 0.152.
 */
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import org.apache.axis.AxisFault;
import org.glite.jobid.Jobid;
import org.glite.lb.Event;
import org.glite.lb.Job;
import org.glite.lb.LBCredentials;
import org.glite.lb.ServerConnection;
import org.glite.wsdl.types.lb.JobStatus;
import org.glite.wsdl.types.lb.QueryAttr;
import org.glite.wsdl.types.lb.QueryConditions;
import org.glite.wsdl.types.lb.QueryOp;
import org.glite.wsdl.types.lb.QueryRecValue;
import org.glite.wsdl.types.lb.QueryRecord;
import org.glite.wsdl.types.lb.StatName;
import org.glite.wsdl.types.lb.Timeval;

public class QueryDemo {
    private static String jobStatusToString(JobStatus jobStatus) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("State:      " + jobStatus.getState() + "\n");
        stringBuilder.append("Job ID:     " + jobStatus.getJobId() + "\n");
        stringBuilder.append("Owner:      " + jobStatus.getOwner() + "\n");
        stringBuilder.append("Job type:   " + jobStatus.getJobtype() + "\n");
        stringBuilder.append("Destination:   " + jobStatus.getLocation() + "\n");
        stringBuilder.append("Done code:  " + jobStatus.getDoneCode() + "\n");
        stringBuilder.append("User tags:  ");
        if (jobStatus.getUserTags() != null) {
            for (int i = 0; i < jobStatus.getUserTags().length; ++i) {
                if (i == 0) {
                    stringBuilder.append(jobStatus.getUserTags()[i].getTag() + " = " + jobStatus.getUserTags()[i].getValue() + "\n");
                    continue;
                }
                stringBuilder.append("            " + jobStatus.getUserTags()[i].getTag() + " = " + jobStatus.getUserTags()[i].getValue() + "\n");
            }
        } else {
            stringBuilder.append("\n");
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        gregorianCalendar.setTimeInMillis(jobStatus.getStateEnterTime().getTvSec() * 1000L);
        stringBuilder.append("Enter time: " + simpleDateFormat.format(gregorianCalendar.getTime()) + "\n");
        gregorianCalendar.setTimeInMillis(jobStatus.getLastUpdateTime().getTvSec() * 1000L);
        stringBuilder.append("Last update time: " + simpleDateFormat.format(gregorianCalendar.getTime()) + "\n");
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) throws RemoteException {
        if (stringArray.length != 7) {
            System.out.println("To use this class you have to run it with these arguments,in this order: \n LB server addres in format \"https://somehost:port\"\n path to the trusted CA's files, default is /etc/grid-security/certificates/\n -p for proxy based authentication\n   -c for certificate based authentication\n proxy certificate or user certificate\n user key\n user password\n jobid for queries in format \"https://somehost:port/uniquePart\"\nEnter \"\" for empty option.");
        } else {
            try {
                Object object;
                LBCredentials lBCredentials;
                if (stringArray[2].equals("-p")) {
                    lBCredentials = new LBCredentials(stringArray[3], stringArray[1]);
                } else if (stringArray[2].equals("-c")) {
                    lBCredentials = new LBCredentials(stringArray[3], stringArray[4], null, stringArray[1]);
                } else {
                    System.err.println("Wrong option: " + stringArray[2] + ". Only -p and -c is allowed.");
                    return;
                }
                ServerConnection serverConnection = new ServerConnection(stringArray[0], lBCredentials);
                System.out.println("Limit: " + serverConnection.getServerLimit());
                System.out.println();
                System.out.println("Indexed attributes:");
                List list = serverConnection.getIndexedAttrs();
                for (int i = 0; i < list.size(); ++i) {
                    object = ((QueryConditions)list.get(i)).getAttr().getValue();
                    System.out.print(((QueryConditions)list.get(i)).getAttr().getValue());
                    if (((String)object).equals("USERTAG")) {
                        System.out.print(" " + ((QueryConditions)list.get(0)).getTagName());
                    }
                    if (((String)object).equals("TIME")) {
                        System.out.print(" " + ((QueryConditions)list.get(0)).getStatName());
                    }
                    System.out.println();
                }
                System.out.println();
                System.out.println("-----ALL USER's JOBS and STATES----");
                List list2 = serverConnection.userJobs();
                object = serverConnection.userJobStates();
                Iterator iterator = list2.iterator();
                Iterator iterator2 = object.iterator();
                while (iterator.hasNext()) {
                    System.out.println(iterator.next());
                    System.out.println(QueryDemo.jobStatusToString((JobStatus)iterator2.next()));
                }
                System.out.println();
                System.out.println("----------------JOB----------------");
                Job job = new Job(stringArray[6], serverConnection);
                System.out.println();
                System.out.println("Status: " + QueryDemo.jobStatusToString(job.getStatus(null)));
                System.out.println();
                List list3 = job.getEvents();
                System.out.println("Found " + list3.size() + " events:");
                for (int i = 0; i < list3.size(); ++i) {
                    System.out.println("Event: " + ((Event)list3.get(i)).ulm());
                }
                if (!list2.isEmpty()) {
                    QueryRecValue queryRecValue;
                    System.out.println();
                    System.out.println("-------------CONDITIONS------------");
                    ArrayList<QueryRecord> arrayList = new ArrayList<QueryRecord>();
                    for (int i = 0; i < list2.size(); ++i) {
                        queryRecValue = new QueryRecValue(null, ((Jobid)list2.get(i)).toString(), null);
                        arrayList.add(new QueryRecord(QueryOp.EQUAL, queryRecValue, null));
                        System.out.println(queryRecValue.getC());
                    }
                    QueryRecord[] queryRecordArray = new QueryRecord[]{};
                    queryRecordArray = arrayList.toArray(queryRecordArray);
                    queryRecValue = new QueryConditions(QueryAttr.JOBID, null, null, queryRecordArray);
                    long l = System.currentTimeMillis() / 1000L;
                    QueryRecValue queryRecValue2 = new QueryRecValue(null, null, new Timeval(l - 259200L, 0L));
                    QueryRecValue queryRecValue3 = new QueryRecValue(null, null, new Timeval(System.currentTimeMillis() / 1000L, 0L));
                    QueryRecord[] queryRecordArray2 = new QueryRecord[]{new QueryRecord(QueryOp.WITHIN, queryRecValue2, queryRecValue3)};
                    QueryConditions queryConditions = new QueryConditions(QueryAttr.TIME, null, StatName.SUBMITTED, queryRecordArray2);
                    ArrayList<Object> arrayList2 = new ArrayList<Object>();
                    arrayList2.add(queryRecValue);
                    arrayList2.add(queryConditions);
                    List list4 = serverConnection.queryJobs(arrayList2);
                    List list5 = serverConnection.queryJobStates(arrayList2, null);
                    GregorianCalendar gregorianCalendar = new GregorianCalendar();
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                    System.out.println();
                    System.out.print("Jobs registered ");
                    gregorianCalendar.setTimeInMillis(queryRecValue2.getT().getTvSec() * 1000L);
                    System.out.print("from " + simpleDateFormat.format(gregorianCalendar.getTime()) + " ");
                    gregorianCalendar.setTimeInMillis(queryRecValue3.getT().getTvSec() * 1000L);
                    System.out.print("to " + simpleDateFormat.format(gregorianCalendar.getTime()) + "\n");
                    Iterator iterator3 = list4.iterator();
                    Iterator iterator4 = list5.iterator();
                    while (iterator3.hasNext()) {
                        System.out.println(iterator3.next());
                        System.out.println(QueryDemo.jobStatusToString((JobStatus)iterator4.next()));
                    }
                }
            }
            catch (Exception exception) {
                Throwable throwable = exception.getCause();
                if (throwable != null && throwable instanceof AxisFault) {
                    throwable.printStackTrace();
                }
                System.err.println("Oops");
                exception.printStackTrace();
            }
        }
    }
}

