/*
 * Decompiled with CFR 0.152.
 */
package org.glite.lb;

import holders.StringArrayHolder;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import org.apache.axis.client.Stub;
import org.glite.jobid.Jobid;
import org.glite.lb.Event;
import org.glite.lb.EventConvertor;
import org.glite.lb.LBCredentials;
import org.glite.lb.LBException;
import org.glite.lb.Level;
import org.glite.wsdl.services.lb.LoggingAndBookkeepingPortType;
import org.glite.wsdl.types.lb.JobFlagsValue;
import org.glite.wsdl.types.lb.JobStatus;
import org.glite.wsdl.types.lb.QueryConditions;
import org.glite.wsdl.types.lb.holders.JobStatusArrayHolder;

public class ServerConnection {
    private String queryServerAddress;
    private int queryJobsLimit = 0;
    private int queryEventsLimit = 0;
    private QueryResultsFlag queryResultsFlag = QueryResultsFlag.NONE;
    private Level eventLogLevel = Level.LEVEL_SYSTEM;
    private LoggingAndBookkeepingPortType queryServer;
    private LBCredentials lbCredent;

    public ServerConnection(String string, LBCredentials lBCredentials) throws LBException {
        if (string == null) {
            throw new IllegalArgumentException("Server cannot be null");
        }
        if (lBCredentials == null) {
            throw new IllegalArgumentException("Credentials cannot be null");
        }
        this.lbCredent = lBCredentials;
        this.setQueryServerAddress(string);
        this.setQueryTimeout(120);
    }

    public void setQueryServerAddress(String string) throws LBException {
        if (string == null) {
            throw new IllegalArgumentException("Server cannot be null");
        }
        this.queryServer = this.lbCredent.getStub(string);
        this.queryServerAddress = string;
    }

    public String getQueryServerAddress() {
        return this.queryServerAddress;
    }

    public void setQueryTimeout(int n) {
        if (n < 0 || n > 1800) {
            throw new IllegalArgumentException("timeout must be between 0 and 1800");
        }
        ((Stub)this.queryServer).setTimeout(n * 1000);
    }

    public int getQueryTimeout() {
        return ((Stub)this.queryServer).getTimeout() / 1000;
    }

    public void setEventLoggingLevel(Level level) {
        if (level == null) {
            throw new IllegalArgumentException("loggingLevel");
        }
        this.eventLogLevel = level;
    }

    public Level getEventLoggingLevel() {
        return this.eventLogLevel;
    }

    public List<QueryConditions> getIndexedAttrs() throws LBException {
        try {
            QueryConditions[] queryConditionsArray = this.queryServer.getIndexedAttrs("");
            ArrayList<QueryConditions> arrayList = new ArrayList<QueryConditions>();
            for (int i = 0; i < queryConditionsArray.length; ++i) {
                arrayList.add(queryConditionsArray[i]);
            }
            return arrayList;
        }
        catch (RemoteException remoteException) {
            throw new LBException(remoteException);
        }
    }

    public int getServerLimit() throws LBException {
        try {
            return this.queryServer.getServerLimit("");
        }
        catch (RemoteException remoteException) {
            throw new LBException(remoteException);
        }
    }

    public void setQueryJobsLimit(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("jobsLimit");
        }
        this.queryJobsLimit = n;
    }

    public int getQueryJobsLimit() {
        return this.queryJobsLimit;
    }

    public void setQueryEventsLimit(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("eventsLimit");
        }
        this.queryEventsLimit = n;
    }

    public int getQueryEventsLimit() {
        return this.queryEventsLimit;
    }

    public void setQueryResultsFlag(QueryResultsFlag queryResultsFlag) {
        if (queryResultsFlag == null) {
            throw new IllegalArgumentException("flag");
        }
        this.queryResultsFlag = queryResultsFlag;
    }

    public QueryResultsFlag getQueryResultsFlag() {
        return this.queryResultsFlag;
    }

    public List<Event> queryEvents(List<QueryConditions> list, List<QueryConditions> list2) throws LBException {
        if (list == null) {
            throw new IllegalArgumentException("jobCond cannot be null");
        }
        if (list2 == null) {
            throw new IllegalArgumentException("eventCond cannot be null");
        }
        org.glite.wsdl.types.lb.Event[] eventArray = null;
        try {
            eventArray = this.queryServer.queryEvents(list.toArray(new QueryConditions[list.size()]), list2.toArray(new QueryConditions[list2.size()]));
        }
        catch (RemoteException remoteException) {
            throw new LBException(remoteException);
        }
        ArrayList<Event> arrayList = new ArrayList<Event>();
        if (eventArray != null) {
            int n = this.queryEventsLimit != 0 && eventArray.length > this.queryEventsLimit ? this.getResultSetSize(this.queryEventsLimit, eventArray.length) : eventArray.length;
            EventConvertor eventConvertor = new EventConvertor();
            for (int i = 0; i < n; ++i) {
                arrayList.add(eventConvertor.convert(eventArray[i]));
            }
        }
        return arrayList;
    }

    public List<Jobid> queryJobs(List<QueryConditions> list) throws LBException {
        if (list == null) {
            throw new IllegalArgumentException("query cannot be null");
        }
        StringArrayHolder stringArrayHolder = new StringArrayHolder();
        try {
            this.queryServer.queryJobs(list.toArray(new QueryConditions[list.size()]), new JobFlagsValue[0], stringArrayHolder, new JobStatusArrayHolder());
        }
        catch (RemoteException remoteException) {
            throw new LBException(remoteException);
        }
        ArrayList<Jobid> arrayList = new ArrayList<Jobid>();
        if (stringArrayHolder.value != null) {
            int n = stringArrayHolder.value.length;
            int n2 = this.queryJobsLimit != 0 && n > this.queryJobsLimit ? this.getResultSetSize(this.queryJobsLimit, n) : n;
            for (int i = 0; i < n2; ++i) {
                arrayList.add(new Jobid(stringArrayHolder.value[i]));
            }
        }
        return arrayList;
    }

    public List<JobStatus> queryJobStates(List<QueryConditions> list, JobFlagsValue[] jobFlagsValueArray) throws LBException {
        if (list == null) {
            throw new IllegalArgumentException("query cannot be null");
        }
        JobStatusArrayHolder jobStatusArrayHolder = new JobStatusArrayHolder();
        try {
            this.queryServer.queryJobs(list.toArray(new QueryConditions[list.size()]), jobFlagsValueArray, new StringArrayHolder(), jobStatusArrayHolder);
        }
        catch (RemoteException remoteException) {
            throw new LBException(remoteException);
        }
        ArrayList<JobStatus> arrayList = new ArrayList<JobStatus>();
        if (jobStatusArrayHolder.value != null) {
            int n = jobStatusArrayHolder.value.length;
            int n2 = this.queryJobsLimit != 0 && n > this.queryJobsLimit ? this.getResultSetSize(this.queryJobsLimit, n) : n;
            for (int i = 0; i < n2; ++i) {
                arrayList.add(jobStatusArrayHolder.value[i]);
            }
        }
        return arrayList;
    }

    public JobStatus jobState(String string, JobFlagsValue[] jobFlagsValueArray) throws LBException {
        if (string == null) {
            throw new IllegalArgumentException("jobId cannot be null");
        }
        JobStatus jobStatus = new JobStatus();
        try {
            jobStatus = this.queryServer.jobStatus(string, jobFlagsValueArray);
        }
        catch (RemoteException remoteException) {
            throw new LBException(remoteException);
        }
        return jobStatus;
    }

    public List<JobStatus> userJobStates() throws LBException {
        JobStatusArrayHolder jobStatusArrayHolder = new JobStatusArrayHolder();
        try {
            this.queryServer.userJobs(new StringArrayHolder(), jobStatusArrayHolder);
        }
        catch (RemoteException remoteException) {
            throw new LBException(remoteException);
        }
        ArrayList<JobStatus> arrayList = new ArrayList<JobStatus>();
        if (jobStatusArrayHolder.value != null) {
            int n = jobStatusArrayHolder.value.length;
            int n2 = this.queryJobsLimit != 0 && n > this.queryJobsLimit ? this.getResultSetSize(this.queryJobsLimit, n) : n;
            for (int i = 0; i < n2; ++i) {
                arrayList.add(jobStatusArrayHolder.value[i]);
            }
        }
        return arrayList;
    }

    public List<Jobid> userJobs() throws LBException {
        StringArrayHolder stringArrayHolder = new StringArrayHolder();
        try {
            this.queryServer.userJobs(stringArrayHolder, new JobStatusArrayHolder());
        }
        catch (RemoteException remoteException) {
            throw new LBException(remoteException);
        }
        ArrayList<Jobid> arrayList = new ArrayList<Jobid>();
        if (stringArrayHolder.value != null) {
            int n = stringArrayHolder.value.length;
            int n2 = this.queryJobsLimit != 0 && n > this.queryJobsLimit ? this.getResultSetSize(this.queryJobsLimit, n) : n;
            for (int i = 0; i < n2; ++i) {
                arrayList.add(new Jobid(stringArrayHolder.value[i]));
            }
        }
        return arrayList;
    }

    private int getResultSetSize(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("queryLimit");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("results");
        }
        switch (this.queryResultsFlag) {
            case ALL: {
                return n2;
            }
            case LIMITED: {
                return n;
            }
            case NONE: {
                return 0;
            }
        }
        throw new IllegalArgumentException("wrong QueryResult");
    }

    public static enum QueryResultsFlag {
        NONE,
        LIMITED,
        ALL;

    }
}

