/*
 * Decompiled with CFR 0.152.
 */
package org.glite.lb;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.Date;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.rpc.holders.CalendarHolder;
import org.glite.jobid.Jobid;
import org.glite.lb.ILProto;
import org.glite.lb.LBCredentials;
import org.glite.lb.LBException;
import org.glite.lb.NotifParser;
import org.glite.lb.SSL;
import org.glite.wsdl.services.lb.LoggingAndBookkeepingPortType;
import org.glite.wsdl.types.lb.JobFlagsValue;
import org.glite.wsdl.types.lb.JobStatus;
import org.glite.wsdl.types.lb.QueryConditions;
import org.xml.sax.SAXException;

public class Notification {
    private int port = 0;
    private Socket socket = null;
    private static String keyStore;
    private String notifId;
    private LoggingAndBookkeepingPortType stub;
    private LBCredentials lbCredent;

    public Notification(int n, LBCredentials lBCredentials) {
        this.port = n;
        this.lbCredent = lBCredentials;
    }

    private String makeId(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        Jobid jobid = new Jobid(stringBuilder.toString(), this.port);
        stringBuilder.append("/NOTIF:");
        stringBuilder.append(jobid.getUnique());
        return stringBuilder.toString();
    }

    public String getNotifid() {
        return this.notifId;
    }

    private String getServer(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.split("/")[2]);
        char[] cArray = new char[]{stringBuilder.charAt(stringBuilder.length() - 1)};
        int n = Integer.parseInt(new String(cArray)) + 3;
        stringBuilder.replace(stringBuilder.length() - 1, stringBuilder.length() - 1, new String() + n);
        stringBuilder.insert(0, "https://");
        return stringBuilder.toString();
    }

    public Date newNotif(String string, QueryConditions[] queryConditionsArray, JobFlagsValue[] jobFlagsValueArray, Date date) throws LBException {
        try {
            CalendarHolder calendarHolder = new CalendarHolder(Calendar.getInstance());
            if (date != null) {
                calendarHolder.value.setTime(date);
            } else {
                calendarHolder.value.setTime(new Date(System.currentTimeMillis() + 86400000L));
            }
            this.stub = this.lbCredent.getStub(string);
            String string2 = "0.0.0.0:" + this.port;
            String string3 = this.makeId(string);
            this.stub.notifNew(string3, string2, queryConditionsArray, jobFlagsValueArray, calendarHolder);
            this.notifId = string3;
            return calendarHolder.value.getTime();
        }
        catch (RemoteException remoteException) {
            throw new LBException(remoteException);
        }
    }

    public void drop(String string) throws LBException {
        try {
            this.stub = this.lbCredent.getStub(this.getServer(string));
            this.stub.notifDrop(string);
        }
        catch (RemoteException remoteException) {
            throw new LBException(remoteException);
        }
    }

    public void refresh(String string, Date date) throws LBException {
        try {
            this.stub = this.lbCredent.getStub(this.getServer(string));
            CalendarHolder calendarHolder = new CalendarHolder(Calendar.getInstance());
            if (date != null) {
                calendarHolder.value.setTime(date);
            } else {
                calendarHolder.value.setTime(new Date(System.currentTimeMillis() + 86400000L));
            }
            this.stub.notifRefresh(string, calendarHolder);
        }
        catch (RemoteException remoteException) {
            throw new LBException(remoteException);
        }
    }

    public Date bind(String string, Date date) throws LBException {
        try {
            this.stub = this.lbCredent.getStub(this.getServer(string));
            String string2 = InetAddress.getLocalHost().getHostName() + ":" + this.port;
            CalendarHolder calendarHolder = new CalendarHolder(Calendar.getInstance());
            if (date != null) {
                calendarHolder.value.setTime(date);
            } else {
                calendarHolder.value.setTime(new Date(System.currentTimeMillis() + 86400000L));
            }
            this.stub.notifBind(string, string2, calendarHolder);
            return calendarHolder.value.getTime();
        }
        catch (RemoteException remoteException) {
            throw new LBException(remoteException);
        }
        catch (UnknownHostException unknownHostException) {
            throw new LBException(unknownHostException);
        }
    }

    public JobStatus receive(int n) throws LBException {
        SSL sSL = new SSL();
        sSL.setCredentials(this.lbCredent);
        ILProto iLProto = null;
        String string = null;
        try {
            if (this.socket == null) {
                this.socket = sSL.accept(this.port, n);
            }
            if ((string = (iLProto = new ILProto(this.socket)).receiveMessage()) == null) {
                this.socket = sSL.accept(this.port, n);
                iLProto = new ILProto(this.socket);
                string = iLProto.receiveMessage();
            }
            iLProto.sendReply(0, 0, "success");
            NotifParser notifParser = new NotifParser(string);
            this.notifId = notifParser.getNotifId();
            return notifParser.getJobInfo();
        }
        catch (IOException iOException) {
            throw new LBException(iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new LBException(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new LBException(sAXException);
        }
    }
}

