/*
 * Decompiled with CFR 0.152.
 */
package org.glite.lb;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Handler;
import org.apache.axis.SimpleChain;
import org.apache.axis.SimpleTargetedChain;
import org.apache.axis.configuration.SimpleProvider;
import org.glite.lb.LBException;
import org.glite.security.trustmanager.ContextWrapper;
import org.glite.security.trustmanager.axis.SSLConfigSender;
import org.glite.wsdl.services.lb.LoggingAndBookkeepingLocator;
import org.glite.wsdl.services.lb.LoggingAndBookkeepingPortType;

public class LBCredentials {
    private String proxy;
    private String caFiles;
    private String key;
    private String pass;
    private String cert;

    public LBCredentials(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("Proxy cannot be null");
        }
        this.proxy = new String(string);
        if (string2 != null) {
            this.caFiles = new String(string2);
        }
    }

    public LBCredentials(String string, String string2, String string3, String string4) {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("key and cert must not be null");
        }
        this.key = new String(string2);
        this.cert = new String(string);
        if (string3 != null) {
            this.pass = new String(string3);
        }
        if (string4 != null) {
            this.caFiles = new String(string4);
        }
    }

    protected LoggingAndBookkeepingPortType getStub(String string) throws LBException {
        if (string == null) {
            throw new IllegalArgumentException("Server cannot be null");
        }
        try {
            URL uRL = new URL(string);
            int n = uRL.getPort();
            if (n < 1 || n > 65535) {
                throw new IllegalArgumentException("port");
            }
            if (!uRL.getProtocol().equals("https")) {
                throw new IllegalArgumentException("wrong protocol");
            }
            SimpleTargetedChain simpleTargetedChain = new SimpleTargetedChain((Handler)new SimpleChain(), (Handler)new SSLConfigSender(this.makeConfig()), (Handler)new SimpleChain());
            SimpleProvider simpleProvider = new SimpleProvider();
            simpleProvider.deployTransport("http", (Handler)simpleTargetedChain);
            LoggingAndBookkeepingLocator loggingAndBookkeepingLocator = new LoggingAndBookkeepingLocator((EngineConfiguration)simpleProvider);
            return loggingAndBookkeepingLocator.getLoggingAndBookkeeping(uRL);
        }
        catch (ServiceException serviceException) {
            throw new LBException(serviceException);
        }
        catch (MalformedURLException malformedURLException) {
            throw new LBException(malformedURLException);
        }
        catch (AxisFault axisFault) {
            throw new LBException(axisFault);
        }
    }

    private Properties makeConfig() {
        Properties properties = new Properties();
        if (this.proxy != null) {
            properties.put("gridProxyFile", this.proxy);
        } else {
            properties.put("sslCertFile", this.cert);
            properties.put("sslKey", this.key);
            if (this.pass != null) {
                properties.put("sslKeyPasswd", this.pass);
            }
        }
        if (this.caFiles != null) {
            properties.put("sslCAFiles", this.caFiles);
        }
        properties.put("sslProtocol", "SSLv3");
        return properties;
    }

    protected SSLContext getSSLContext() throws LBException {
        ContextWrapper contextWrapper;
        try {
            contextWrapper = new ContextWrapper(this.makeConfig());
        }
        catch (IOException iOException) {
            throw new LBException(iOException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new LBException(generalSecurityException);
        }
        return contextWrapper.getContext();
    }
}

