/*
 * Decompiled with CFR 0.152.
 */
package org.glite.lb;

import java.util.ArrayList;
import java.util.List;
import org.glite.jobid.Jobid;
import org.glite.lb.Event;
import org.glite.lb.LBException;
import org.glite.lb.ServerConnection;
import org.glite.wsdl.types.lb.JobFlagsValue;
import org.glite.wsdl.types.lb.JobStatus;
import org.glite.wsdl.types.lb.QueryAttr;
import org.glite.wsdl.types.lb.QueryConditions;
import org.glite.wsdl.types.lb.QueryOp;
import org.glite.wsdl.types.lb.QueryRecValue;
import org.glite.wsdl.types.lb.QueryRecord;

public class Job {
    private Jobid jobId;
    private ServerConnection serverConnection;

    public Job() {
    }

    public Job(Jobid jobid, ServerConnection serverConnection) {
        if (jobid == null) {
            throw new IllegalArgumentException("jobId cannot be null");
        }
        if (serverConnection == null) {
            throw new IllegalArgumentException("server cannot be null");
        }
        this.jobId = jobid;
        this.serverConnection = serverConnection;
    }

    public Job(String string, ServerConnection serverConnection) {
        this(new Jobid(string), serverConnection);
    }

    public Jobid getJobId() {
        return this.jobId;
    }

    public void setJobId(Jobid jobid) {
        if (jobid == null) {
            throw new IllegalArgumentException("jobId");
        }
        this.jobId = jobid;
    }

    public ServerConnection getServer() {
        return this.serverConnection;
    }

    public void setServer(ServerConnection serverConnection) {
        if (serverConnection == null) {
            throw new IllegalArgumentException("server");
        }
        this.serverConnection = serverConnection;
    }

    public JobStatus getStatus(JobFlagsValue[] jobFlagsValueArray) throws LBException {
        if (this.serverConnection == null) {
            throw new IllegalStateException("serverConnection is null, please set it");
        }
        if (this.jobId == null) {
            throw new IllegalStateException("jobId is null, please set it");
        }
        return this.serverConnection.jobState(this.jobId.toString(), jobFlagsValueArray);
    }

    public List<Event> getEvents() throws LBException {
        if (this.serverConnection == null) {
            throw new IllegalStateException("serverConnection is null, please set it");
        }
        if (this.jobId == null) {
            throw new IllegalStateException("jobId is null, please set it");
        }
        QueryRecValue queryRecValue = new QueryRecValue(null, this.jobId.toString(), null);
        QueryRecord[] queryRecordArray = new QueryRecord[]{new QueryRecord(QueryOp.EQUAL, queryRecValue, null)};
        QueryConditions[] queryConditionsArray = new QueryConditions[]{new QueryConditions(QueryAttr.JOBID, null, null, queryRecordArray)};
        QueryRecValue queryRecValue2 = new QueryRecValue(this.serverConnection.getEventLoggingLevel().getInt() + 1, null, null);
        QueryRecord[] queryRecordArray2 = new QueryRecord[]{new QueryRecord(QueryOp.LESS, queryRecValue2, null)};
        QueryConditions[] queryConditionsArray2 = new QueryConditions[]{new QueryConditions(QueryAttr.LEVEL, null, null, queryRecordArray2)};
        ArrayList<QueryConditions> arrayList = new ArrayList<QueryConditions>();
        arrayList.add(queryConditionsArray[0]);
        ArrayList<QueryConditions> arrayList2 = new ArrayList<QueryConditions>();
        arrayList2.add(queryConditionsArray2[0]);
        return this.serverConnection.queryEvents(arrayList, arrayList2);
    }
}

