/*
 * Decompiled with CFR 0.152.
 */
package org.glite.lb;

import org.glite.lb.Context;
import org.glite.lb.Event;
import org.glite.lb.ILFileWriter;
import org.glite.lb.LBCredentials;
import org.glite.lb.LBException;
import org.glite.lb.SSLSend;

public class ContextLL
extends Context {
    private String address;
    private int port = 9002;
    private String prefix;
    private int repeatWriteToFile = 5;
    private int timeout = 30000;
    private LBCredentials cred;
    private SSLSend sslSend = null;

    public ContextLL() {
    }

    public ContextLL(String string, int n, String string2) {
        this.prefix = string2;
        this.address = string;
        this.port = n;
    }

    @Override
    public void log(Event event) throws LBException {
        if (event == null) {
            throw new IllegalArgumentException("ContextLL event");
        }
        if (this.prefix == null) {
            throw new IllegalArgumentException("ContextLL prefix");
        }
        if (this.address == null) {
            throw new IllegalArgumentException("ContextLL socket");
        }
        if (this.port < 0) {
            throw new IllegalArgumentException("ContextLL port");
        }
        if (this.sslSend == null) {
            this.sslSend = new SSLSend();
        }
        String string = super.createMessage(event);
        ILFileWriter.write(this.prefix, string, this.repeatWriteToFile);
        this.sslSend.send(this.cred, this.address, this.port, this.timeout, string);
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String string) {
        if (string == null) {
            throw new IllegalArgumentException("ContextLL address");
        }
        this.address = string;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("ContextLL port");
        }
        this.port = n;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String string) {
        if (string == null) {
            throw new IllegalArgumentException("ContextLL prefix");
        }
        this.prefix = string;
    }

    public int getRepeatWriteToFile() {
        return this.repeatWriteToFile;
    }

    public void setRepeatWriteToFile(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("ContextLL repeatWriteToFile");
        }
        this.repeatWriteToFile = n;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("ContextLL timout");
        }
        this.timeout = n;
    }

    public LBCredentials getCredentials() {
        return this.cred;
    }

    public void setCredentials(LBCredentials lBCredentials) {
        if (lBCredentials == null) {
            throw new IllegalArgumentException("ContextLL credentials");
        }
        this.cred = lBCredentials;
    }
}

